/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import java.util.Random;
import net.minecraft.util.Mth;

public final class MathHelper {
    public static final Random RANDOM;
    public static final double PI = Math.PI;
    public static final double PI_2 = Math.PI * 2;
    public static final float F_PI = (float)Math.PI;
    public static final float F_TAU = (float)Math.PI * 2;
    public static final double PHI = 1.618033988749894;
    public static final double TO_DEG = 57.29577951308232;
    public static final double TO_RAD = 0.017453292519943;
    public static final double SQRT_2 = 1.414213562373095;
    public static final double[] SIN_TABLE;
    public static final float[] ASIN_TABLE;

    private MathHelper() {
    }

    public static int nextInt(Random random, int min, int max) {
        return min >= max ? min : random.nextInt(max - min + 1) + min;
    }

    public static int binomialDist(int trials, double success) {
        int ret = 0;
        for (int i = 0; i < trials; ++i) {
            if (!(RANDOM.nextDouble() < success)) continue;
            ++ret;
        }
        return ret;
    }

    public static int nextInt(int min, int max) {
        return MathHelper.nextInt(RANDOM, min, max);
    }

    public static float nextFloat(Random random, float min, float max) {
        return min >= max ? min : random.nextFloat() * (max - min) + min;
    }

    public static float nextFloat(float min, float max) {
        return MathHelper.nextFloat(RANDOM, min, max);
    }

    public static double nextDouble(Random random, double min, double max) {
        return min >= max ? min : random.nextDouble() * (max - min) + min;
    }

    public static double nextDouble(double min, double max) {
        return MathHelper.nextDouble(RANDOM, min, max);
    }

    public static double sin(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f) & 0xFFFF];
    }

    public static float sin(float d) {
        return Mth.m_14031_((float)d);
    }

    public static double cos(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float cos(float d) {
        return Mth.m_14089_((float)d);
    }

    public static float asin(float d) {
        return ASIN_TABLE[(int)(d * 32768.0f + 32768.0f) & 0xFFFF];
    }

    public static float easeInCubic(float a) {
        return a * a * a;
    }

    public static float easeOutCubic(float a) {
        a = 1.0f - a;
        return 1.0f - a * a * a;
    }

    public static float easeInOutCubic(float a) {
        return (double)a < 0.5 ? 4.0f * MathHelper.easeInCubic(a) : 4.0f * MathHelper.easeInCubic(a - 1.0f) + 1.0f;
    }

    public static float easePlateau(float a) {
        return a <= 0.3333f ? MathHelper.sin(a * (float)Math.PI * 1.5f) : (a > 0.66666f ? MathHelper.sin((a * 1.5f - 0.5f) * (float)Math.PI) : 1.0f);
    }

    public static int clamp(int a, int min, int max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static float clamp(float a, float min, float max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static double clamp(double a, double min, double max) {
        return a < min ? min : (a > max ? max : a);
    }

    public static float approachLinear(float a, float b, float max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static double approachLinear(double a, double b, double max) {
        return a > b ? (a - b < max ? b : a - max) : (b - a < max ? b : a + max);
    }

    public static float interpolate(float a, float b, float d) {
        return a + (b - a) * d;
    }

    public static double interpolate(double a, double b, double d) {
        return a + (b - a) * d;
    }

    public static double approachExp(double a, double b, double ratio) {
        return a + (b - a) * ratio;
    }

    public static double approachExp(double a, double b, double ratio, double cap) {
        double d = (b - a) * ratio;
        if (Math.abs(d) > cap) {
            d = Math.signum(d) * cap;
        }
        return a + d;
    }

    public static double retreatExp(double a, double b, double c, double ratio, double kick) {
        double d = (Math.abs(c - a) + kick) * ratio;
        if (d > Math.abs(b - a)) {
            return b;
        }
        return a + Math.signum(b - a) * d;
    }

    public static boolean between(double a, double x, double b) {
        return a <= x && x <= b;
    }

    public static int approachExpI(int a, int b, double ratio) {
        int r = (int)Math.round(MathHelper.approachExp(a, b, ratio));
        return r == a ? b : r;
    }

    public static int retreatExpI(int a, int b, int c, double ratio, int kick) {
        int r = (int)Math.round(MathHelper.retreatExp(a, b, c, ratio, kick));
        return r == a ? b : r;
    }

    public static float sqrt(float a) {
        return (float)Math.sqrt(a);
    }

    public static float invSqrt(float a) {
        return 1.0f / MathHelper.sqrt(a);
    }

    public static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    public static double distSqr(double ... a) {
        double d = 0.0;
        for (double f : a) {
            d += f * f;
        }
        return d;
    }

    public static float dist(float ... a) {
        return MathHelper.sqrt(MathHelper.distSqr(a));
    }

    public static double dist(double ... a) {
        return Math.sqrt(MathHelper.distSqr(a));
    }

    public static float invDist(float ... a) {
        return 1.0f / MathHelper.dist(a);
    }

    public static double invDist(double ... a) {
        return 1.0 / MathHelper.dist(a);
    }

    public static float bevel(float f) {
        int floor = MathHelper.floor(f);
        if (f - (float)floor < 0.66667f && (floor & 1) == 0) {
            return -MathHelper.cos(4.712389f * f);
        }
        return (floor >> 1 & 1) == 0 ? 1.0f : -1.0f;
    }

    public static float frac(float f) {
        return f - (float)MathHelper.floor(f);
    }

    public static int round(double d) {
        return (int)(d + 0.5);
    }

    public static int ceil(double d) {
        return (int)(d + 0.9999);
    }

    public static int floor(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static float minF(float a, float b) {
        return a < b ? a : b;
    }

    public static float minF(int a, float b) {
        return (float)a < b ? (float)a : b;
    }

    public static float minF(float a, int b) {
        return a < (float)b ? a : (float)b;
    }

    public static float maxF(float a, float b) {
        return a > b ? a : b;
    }

    public static float maxF(int a, float b) {
        return (float)a > b ? (float)a : b;
    }

    public static float maxF(float a, int b) {
        return a > (float)b ? a : (float)b;
    }

    public static double maxAbs(double a, double b) {
        if (a < 0.0) {
            a = -a;
        }
        if (b < 0.0) {
            b = -b;
        }
        return a > b ? a : b;
    }

    public static int setBit(int mask, int bit, boolean value) {
        return mask |= (value ? 1 : 0) << bit;
    }

    public static boolean isBitSet(int mask, int bit) {
        return (mask & 1 << bit) != 0;
    }

    static {
        int i;
        RANDOM = new Random();
        SIN_TABLE = new double[65536];
        ASIN_TABLE = new float[65536];
        for (i = 0; i < 65536; ++i) {
            MathHelper.SIN_TABLE[i] = Math.sin((double)i / 65536.0 * 2.0 * Math.PI);
        }
        MathHelper.SIN_TABLE[0] = 0.0;
        MathHelper.SIN_TABLE[16384] = 1.0;
        MathHelper.SIN_TABLE[32768] = 0.0;
        MathHelper.SIN_TABLE[49152] = -1.0;
        for (i = 0; i < 65536; ++i) {
            MathHelper.ASIN_TABLE[i] = (float)Math.asin((double)(i - 32768) / 32768.0);
        }
    }
}

