/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.LocationTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DEAdvancementProvider
extends AdvancementProvider {
    public DEAdvancementProvider(DataGenerator dataGenerator, ExistingFileHelper exFileHelper) {
        super(dataGenerator, exFileHelper);
    }

    @ParametersAreNonnullByDefault
    protected void registerAdvancements(Consumer<Advancement> consumer, ExistingFileHelper exFileHelper) {
        Advancement root = this.enterAnyStructure(this.builder((ItemLike)Blocks.f_50223_, "root", new ResourceLocation("textures/block/mossy_cobblestone.png"), FrameType.TASK, false, false, false), DEStructures.getAllStructureRegistrars()).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, this.location("root"));
        Advancement HiddenUnderTheRoots = this.enterStructure(this.builder((ItemLike)Blocks.f_50144_, "hidden_under_the_roots", FrameType.TASK, true, true, false), DEStructures.MonsterMaze).m_138398_(root).m_138389_(consumer, this.location("hidden_under_the_roots"));
        Advancement ThatsADungeon = this.enterStructure(this.builder((ItemLike)Blocks.f_50310_, "thats_a_dungeon", FrameType.TASK, true, true, false), DEStructures.LargeDungeon).m_138398_(root).m_138389_(consumer, this.location("thats_a_dungeon"));
        Advancement TrapsAndCurses = this.enterStructure(this.builder((ItemLike)Blocks.f_50077_, "traps_and_curses", FrameType.TASK, true, true, false), DEStructures.DesertTemple).m_138398_(root).m_138389_(consumer, this.location("traps_and_curses"));
        Advancement AncientCivilizations = this.enterStructure(this.builder((ItemLike)Blocks.f_50571_, "ancient_civilizations", FrameType.TASK, true, true, false), DEStructures.JungleMonument).m_138398_(root).m_138389_(consumer, this.location("ancient_civilizations"));
        Advancement WarsAndKingdoms = this.enterStructure(this.builder((ItemLike)Blocks.f_50222_, "wars_and_kingdoms", FrameType.TASK, true, true, false), DEStructures.Castle).m_138398_(root).m_138389_(consumer, this.location("wars_and_kingdoms"));
        Advancement RarestStructure = this.enterStructure(this.builder((ItemLike)Items.f_41953_, "rarest_structure", FrameType.TASK, true, true, false), DEStructures.MushroomHouse).m_138398_(root).m_138389_(consumer, this.location("rarest_structure"));
        Advancement ChilledHalls = this.enterStructure(this.builder((ItemLike)Items.f_42500_, "chilled_halls", FrameType.TASK, true, true, false), DEStructures.IcePit).m_138398_(root).m_138389_(consumer, this.location("chilled_halls"));
        Advancement Ahoy = this.enterStructure(this.builder((ItemLike)Items.f_42728_, "ahoy", FrameType.TASK, true, true, false), DEStructures.PirateShip).m_138398_(root).m_138389_(consumer, this.location("ahoy"));
        Advancement InTheAir = this.enterStructure(this.builder((ItemLike)Items.f_42728_, "in_the_air", FrameType.TASK, true, true, false), DEStructures.FlyingDutchman).m_138398_(root).m_138389_(consumer, this.location("in_the_air"));
        Advancement SevenWorldWonders = this.enterAnyStructure(this.builder((ItemLike)Items.f_151059_, "seven_world_wonders", FrameType.GOAL, true, true, false), new StructureRegistrar[]{DEStructures.Castle, DEStructures.DeepCrypt, DEStructures.DesertTemple, DEStructures.IcePit, DEStructures.JungleMonument, DEStructures.MonsterMaze, DEStructures.EldersTemple}).m_138360_(RequirementsStrategy.f_15978_).m_138398_(root).m_138389_(consumer, this.location("seven_world_wonders"));
        Advancement AmbitiousExplorer = this.enterAnyStructure(this.builder((ItemLike)Items.f_42573_, "ambitious_explorer", FrameType.CHALLENGE, true, true, false), DEStructures.getAllStructureRegistrars()).m_138360_(RequirementsStrategy.f_15978_).m_138398_(root).m_138389_(consumer, this.location("ambitious_explorer"));
    }

    private Advancement.Builder enterAnyStructure(Advancement.Builder builder, StructureRegistrar<?, ?>[] structures) {
        for (StructureRegistrar<?, ?> structure : structures) {
            builder = this.enterStructure(builder, structure);
        }
        return builder;
    }

    private Advancement.Builder enterStructure(Advancement.Builder builder, StructureRegistrar<?, ?> structure) {
        DungeonsEnhanced.LOGGER.info(Objects.requireNonNull(structure.getConfigured()).m_203543_().orElseThrow() + "  test");
        return builder.m_138386_(this.enterFeatureText(structure), (CriterionTriggerInstance)LocationTrigger.TriggerInstance.m_53670_((LocationPredicate)LocationPredicate.m_207928_((ResourceKey)((ResourceKey)Objects.requireNonNull(structure.getConfigured()).m_203543_().orElseThrow()))));
    }

    private String enterFeatureText(StructureRegistrar<?, ?> structure) {
        return "entered_" + Objects.requireNonNull(structure.getRegistryName()).m_135815_();
    }

    private Advancement.Builder builder(ItemLike displayItem, String name, ResourceLocation background, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.m_138353_().m_138371_(displayItem, (Component)this.translate(name), (Component)this.translate(name + ".desc"), background, frameType, showToast, announceToChat, hidden);
    }

    private Advancement.Builder builder(ItemLike displayItem, String name, FrameType frameType, boolean showToast, boolean announceToChat, boolean hidden) {
        return this.builder(displayItem, name, null, frameType, showToast, announceToChat, hidden);
    }

    private TranslatableComponent translate(String key) {
        return new TranslatableComponent("advancements.dungeons_enhanced." + key);
    }

    private String location(String key) {
        return "dungeons_enhanced:" + key;
    }
}

