/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.legacy.structure_gel.api.config.StructureConfig;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DEConfig {
    public static final Common COMMON;
    protected static final ForgeConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        private final ForgeConfigSpec.Builder builder;
        public final StructureConfig Castle;
        public final StructureConfig DeepCrypt;
        public final StructureConfig DesertTemple;
        public final StructureConfig DesertTomb;
        public final StructureConfig DruidCircle;
        public final StructureConfig DungeonVariant;
        public final StructureConfig EldersTemple;
        public final StructureConfig FishingShip;
        public final StructureConfig FlyingDutchman;
        public final StructureConfig HayStorage;
        public final StructureConfig IcePit;
        public final StructureConfig JungleMonument;
        public final StructureConfig LargeDungeon;
        public final StructureConfig MinersHouse;
        public final StructureConfig MonsterMaze;
        public final StructureConfig MushroomHouse;
        public final StructureConfig PillagerCamp;
        public final StructureConfig PirateShip;
        public final StructureConfig RuinedBuilding;
        public final StructureConfig Stables;
        public final StructureConfig SunkenShrine;
        public final StructureConfig TallWitchHut;
        public final StructureConfig TowerOfTheUndead;
        public final StructureConfig TreeHouse;
        public final StructureConfig WatchTower;
        public final StructureConfig WitchTower;

        protected Common(ForgeConfigSpec.Builder builder) {
            this.builder = builder;
            this.Castle = this.configs("Castle", 56, 42, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:cold", "##structure_gel:snowy", "!##structure_gel:mountain", "!##structure_gel:beach");
            this.DeepCrypt = this.configs("Deep Crypt", 35, 75, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:overworld");
            this.DesertTemple = this.configs("Desert Temple", 32, 60, (ResourceKey<Level>)Level.f_46428_, "minecraft:desert");
            this.DesertTomb = this.configs("Desert Tomb", 29, 65, (ResourceKey<Level>)Level.f_46428_, "minecraft:desert");
            this.DruidCircle = this.configs("Druid Circle", 39, 40, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:neutral_temp", "!##structure_gel:wooded", "!##structure_gel:mountain", "!##structure_gel:beach");
            this.DungeonVariant = this.configs("Dungeon Variant", 16, 80, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:overworld");
            this.EldersTemple = this.configs("Elders Temple", 34, 82, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:ocean");
            this.FishingShip = this.configs("Fishing Ship", 48, 68, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:ocean");
            this.FlyingDutchman = this.configs("Flying Dutchman", 67, 40, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:ocean");
            this.HayStorage = this.configs("Hay Storage", 24, 75, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:savanna");
            this.IcePit = this.configs("Ice Pit", 35, 70, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:snowy", "##structure_gel:frozen", "!##structure_gel:mountain", "!##structure_gel:river", "!##structure_gel:beach");
            this.JungleMonument = this.configs("Jungle Monument", 41, 75, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_jungle");
            this.LargeDungeon = this.configs("Large Dungeon", 39, 35, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:neutral_temp", "##structure_gel:cold", "!##structure_gel:mountain", "!##structure_gel:beach");
            this.MinersHouse = this.configs("Miners House", 24, 80, (ResourceKey<Level>)Level.f_46428_, "minecraft:badlands", "minecraft:badlands_plateau");
            this.MonsterMaze = this.configs("Monster Maze", 34, 50, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:spooky", "##structure_gel:pumpkin", "!##structure_gel:sandy", "!##structure_gel:mountain");
            this.MushroomHouse = this.configs("Mushroom House", 15, 75, (ResourceKey<Level>)Level.f_46428_, "minecraft:mushroom_fields", "minecraft:mushroom_field_shore");
            this.PillagerCamp = this.configs("Pillager Camp", 49, 35, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:neutral_temp", "!##structure_gel:mountain", "!##structure_gel:wooded", "!##structure_gel:river", "!##structure_gel:beach");
            this.PirateShip = this.configs("Pirate Ship", 65, 49, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:ocean");
            this.RuinedBuilding = this.configs("Ruined Building", 27, 45, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:neutral_temp", "!##structure_gel:river", "!##structure_gel:beach", "!##structure_gel:mountain");
            this.Stables = this.configs("Stables", 46, 32, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:neutral_temp", "!##structure_gel:mountain", "!##structure_gel:wooded", "!##structure_gel:beach");
            this.SunkenShrine = this.configs("Sunken Shrine", 32, 55, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:ocean");
            this.TallWitchHut = this.configs("Tall Witch Hut", 18, 60, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:swamp");
            this.TowerOfTheUndead = this.configs("Tower of the Undead", 37, 35, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:neutral_temp", "##structure_gel:savanna", "##structure_gel:swamp", "!##structure_gel:mountain");
            this.TreeHouse = this.configs("Tree House", 29, 40, (ResourceKey<Level>)Level.f_46428_, "#minecraft:is_jungle");
            this.WatchTower = this.configs("Watch Tower", 33, 45, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:cold", "##structure_gel:snowy", "##structure_gel:mountain");
            this.WitchTower = this.configs("Witch Tower", 29, 45, (ResourceKey<Level>)Level.f_46428_, "##structure_gel:spruce_forest", "##structure_gel:large_spruce_forest");
        }

        private StructureConfig configs(String name, int spacing, int prob, ResourceKey<Level> dimension, String ... biomes) {
            return StructureConfig.builder((ForgeConfigSpec.Builder)this.builder, (String)name).pushPlacement().spacing(spacing).offset((int)((float)spacing / 1.5f)).probability(prob).popPlacement().pushConfigured().biomes(biomes).dimensions(new ResourceKey[]{dimension}).popConfigured().build();
        }
    }
}

