/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.DEConfig;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structures.DEDeepCrypt;
import com.barion.dungeons_enhanced.world.structures.DEDesertTemple;
import com.barion.dungeons_enhanced.world.structures.DEDesertTomb;
import com.barion.dungeons_enhanced.world.structures.DEEldersTemple;
import com.barion.dungeons_enhanced.world.structures.DEIcePit;
import com.barion.dungeons_enhanced.world.structures.DELargeDungeon;
import com.barion.dungeons_enhanced.world.structures.DEMonsterMaze;
import com.barion.dungeons_enhanced.world.structures.DEPillagerCamp;
import com.barion.dungeons_enhanced.world.structures.DEPirateShip;
import com.barion.dungeons_enhanced.world.structures.prefabs.DECellarStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEFlyingStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DESimpleStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DESwimmingStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEUndergroundStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEUnderwaterStructure;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class DEStructures {
    public static final StructureRegistrar<JigsawConfiguration, DECellarStructure> Castle = StructureRegistrar.builder((ResourceLocation)DEUtil.location("castle"), () -> new DECellarStructure(DEConfig.COMMON.Castle, false, new DETerrainAnalyzer.Settings(1, 3, 4))).pushConfigured((FeatureConfiguration)new JigsawConfiguration(DECellarStructure.CastlePool.Root, 1)).biomes(DEConfig.COMMON.Castle.getConfigured()).dimensions(DEConfig.COMMON.Castle.getConfigured()).adaptNoise().popConfigured().addPiece(DECellarStructure.Piece::new).build();
    public static final StructureRegistrar<JigsawConfiguration, DEDeepCrypt> DeepCrypt = StructureRegistrar.builder((ResourceLocation)DEUtil.location("deep_crypt"), DEDeepCrypt::new).pushConfigured((FeatureConfiguration)new JigsawConfiguration(DEDeepCrypt.Pool.Root, 4)).biomes(DEConfig.COMMON.DeepCrypt.getConfigured()).dimensions(DEConfig.COMMON.DeepCrypt.getConfigured()).popConfigured().addPiece(DEDeepCrypt.Piece::new).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DEDesertTemple> DesertTemple = StructureRegistrar.builder((ResourceLocation)DEUtil.location("desert_temple"), DEDesertTemple::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.DesertTemple.getConfigured()).dimensions(DEConfig.COMMON.DesertTemple.getConfigured()).popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<JigsawConfiguration, DEDesertTomb> DesertTomb = StructureRegistrar.builder((ResourceLocation)DEUtil.location("desert_tomb"), DEDesertTomb::new).pushConfigured((FeatureConfiguration)new JigsawConfiguration(DEDesertTomb.Pool.Root, 4)).biomes(DEConfig.COMMON.DesertTomb.getConfigured()).dimensions(DEConfig.COMMON.DesertTomb.getConfigured()).popConfigured().addPiece(DEDesertTomb.Piece::new).build();
    public static final StructureRegistrar<JigsawConfiguration, DECellarStructure> DruidCircle = StructureRegistrar.builder((ResourceLocation)DEUtil.location("druid_circle"), () -> new DECellarStructure(DEConfig.COMMON.DruidCircle, true, DETerrainAnalyzer.defaultCheckSettings)).pushConfigured((FeatureConfiguration)new JigsawConfiguration(DECellarStructure.DruidCirclePool.Root, 1)).biomes(DEConfig.COMMON.DruidCircle.getConfigured()).dimensions(DEConfig.COMMON.DruidCircle.getConfigured()).adaptNoise().popConfigured().addPiece(DECellarStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DEUndergroundStructure> DungeonVariant = StructureRegistrar.builder((ResourceLocation)DEUtil.location("dungeon_variant"), () -> new DEUndergroundStructure(DEConfig.COMMON.DungeonVariant, true, DEUtil.pieceBuilder().offset(-6, 0, -6).add("dungeon_variant/zombie").add("dungeon_variant/skeleton").add("dungeon_variant/spider").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.DungeonVariant.getConfigured()).dimensions(DEConfig.COMMON.DungeonVariant.getConfigured()).popConfigured().addPiece(DEUndergroundStructure.Piece::new).generationStep(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DEEldersTemple> EldersTemple = StructureRegistrar.builder((ResourceLocation)DEUtil.location("elders_temple"), DEEldersTemple::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.EldersTemple.getConfigured()).dimensions(DEConfig.COMMON.EldersTemple.getConfigured()).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobSpawnSettings.SpawnerData[]{DEStructures.spawn(EntityType.f_20455_, 1, 2, 4)}).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).popConfigured().addPiece(DEEldersTemple.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESwimmingStructure> FishingShip = StructureRegistrar.builder((ResourceLocation)DEUtil.location("fishing_ship"), () -> new DESwimmingStructure(DEConfig.COMMON.FishingShip, DEUtil.pieceBuilder().offset(-4, -3, -14).add("fishing_ship").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.FishingShip.getConfigured()).dimensions(DEConfig.COMMON.FishingShip.getConfigured()).popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DEFlyingStructure> FlyingDutchman = StructureRegistrar.builder((ResourceLocation)DEUtil.location("flying_dutchman"), () -> new DEFlyingStructure(DEConfig.COMMON.FlyingDutchman, false, DEUtil.pieceBuilder().offset(-4, 0, -15).add("flying_dutchman").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.FlyingDutchman.getConfigured()).dimensions(DEConfig.COMMON.FlyingDutchman.getConfigured()).popConfigured().addPiece(DEFlyingStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> HayStorage = StructureRegistrar.builder((ResourceLocation)DEUtil.location("hay_storage"), () -> new DESimpleStructure(DEConfig.COMMON.HayStorage, DEUtil.pieceBuilder().offset(-7, 0, -7).add("hay_storage/small").offset(-9, 0, -9).add("hay_storage/big").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.HayStorage.getConfigured()).dimensions(DEConfig.COMMON.HayStorage.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DEIcePit> IcePit = StructureRegistrar.builder((ResourceLocation)DEUtil.location("ice_pit"), DEIcePit::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.IcePit.getConfigured()).dimensions(DEConfig.COMMON.IcePit.getConfigured()).popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> JungleMonument = StructureRegistrar.builder((ResourceLocation)DEUtil.location("jungle_monument"), () -> new DESimpleStructure(DEConfig.COMMON.JungleMonument, DEUtil.pieceBuilder().offset(-12, -9, -12).add("jungle_monument").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.JungleMonument.getConfigured()).dimensions(DEConfig.COMMON.JungleMonument.getConfigured()).popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<JigsawConfiguration, DELargeDungeon> LargeDungeon = StructureRegistrar.builder((ResourceLocation)DEUtil.location("large_dungeon"), DELargeDungeon::new).pushConfigured((FeatureConfiguration)new JigsawConfiguration(DELargeDungeon.Pool.Root, 5)).biomes(DEConfig.COMMON.LargeDungeon.getConfigured()).dimensions(DEConfig.COMMON.LargeDungeon.getConfigured()).popConfigured().addPiece(DELargeDungeon.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> MinersHouse = StructureRegistrar.builder((ResourceLocation)DEUtil.location("miners_house"), () -> new DESimpleStructure(DEConfig.COMMON.MinersHouse, DEUtil.pieceBuilder().offset(-5, 0, -5).add("miners_house").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.MinersHouse.getConfigured()).dimensions(DEConfig.COMMON.MinersHouse.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<JigsawConfiguration, DEMonsterMaze> MonsterMaze = StructureRegistrar.builder((ResourceLocation)DEUtil.location("monster_maze"), DEMonsterMaze::new).pushConfigured((FeatureConfiguration)new JigsawConfiguration(DEMonsterMaze.Pool.Root, 7)).biomes(DEConfig.COMMON.MonsterMaze.getConfigured()).dimensions(DEConfig.COMMON.MonsterMaze.getConfigured()).popConfigured().addPiece(DEMonsterMaze.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> MushroomHouse = StructureRegistrar.builder((ResourceLocation)DEUtil.location("mushroom_house"), () -> new DESimpleStructure(DEConfig.COMMON.MushroomHouse, DEUtil.pieceBuilder().offset(-7, 0, -7).add("mushroom_house/red").add("mushroom_house/brown").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.MushroomHouse.getConfigured()).dimensions(DEConfig.COMMON.MushroomHouse.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<JigsawConfiguration, DEPillagerCamp> PillagerCamp = StructureRegistrar.builder((ResourceLocation)DEUtil.location("pillager_camp"), DEPillagerCamp::new).pushConfigured((FeatureConfiguration)new JigsawConfiguration(DEPillagerCamp.Pool.Root, 4)).biomes(DEConfig.COMMON.PillagerCamp.getConfigured()).dimensions(DEConfig.COMMON.PillagerCamp.getConfigured()).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobSpawnSettings.SpawnerData[]{DEStructures.spawn(EntityType.f_20513_, 9), DEStructures.spawn(EntityType.f_20493_, 3)}).adaptNoise().popConfigured().addPiece(DEPillagerCamp.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DEPirateShip> PirateShip = StructureRegistrar.builder((ResourceLocation)DEUtil.location("pirate_ship"), DEPirateShip::new).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.PirateShip.getConfigured()).dimensions(DEConfig.COMMON.PirateShip.getConfigured()).spawns(MobCategory.MONSTER, StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobSpawnSettings.SpawnerData[]{DEStructures.spawn(EntityType.f_20513_, 9), DEStructures.spawn(EntityType.f_20493_, 3)}).noSpawns(StructureSpawnOverride.BoundingBoxType.STRUCTURE, new MobCategory[]{MobCategory.UNDERGROUND_WATER_CREATURE, MobCategory.AXOLOTLS, MobCategory.WATER_AMBIENT, MobCategory.WATER_CREATURE}).popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> RuinedBuilding = StructureRegistrar.builder((ResourceLocation)DEUtil.location("ruined_building"), () -> new DESimpleStructure(DEConfig.COMMON.RuinedBuilding, DEUtil.pieceBuilder().offset(-5, 0, -5).weight(3).add("ruined_building/house").offset(-6, 0, -8).weight(2).add("ruined_building/house_big").offset(-4, 0, -5).weight(3).add("ruined_building/barn").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.RuinedBuilding.getConfigured()).dimensions(DEConfig.COMMON.RuinedBuilding.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> Stables = StructureRegistrar.builder((ResourceLocation)DEUtil.location("stables"), () -> new DESimpleStructure(DEConfig.COMMON.Stables, DEUtil.pieceBuilder().offset(-8, -6, -13).add("stables").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.Stables.getConfigured()).dimensions(DEConfig.COMMON.Stables.getConfigured()).popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DEUnderwaterStructure> SunkenShrine = StructureRegistrar.builder((ResourceLocation)DEUtil.location("sunken_shrine"), () -> new DEUnderwaterStructure(DEConfig.COMMON.SunkenShrine, true, DEUtil.pieceBuilder().offset(-5, -1, -8).add("sunken_shrine").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.SunkenShrine.getConfigured()).dimensions(DEConfig.COMMON.SunkenShrine.getConfigured()).popConfigured().addPiece(DEUnderwaterStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> TallWitchHut = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tall_witch_hut"), () -> new DESimpleStructure(DEConfig.COMMON.TallWitchHut, DEUtil.pieceBuilder().offset(-3, -3, -4).add("tall_witch_hut").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.TallWitchHut.getConfigured()).dimensions(DEConfig.COMMON.TallWitchHut.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> TreeHouse = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tree_house"), () -> new DESimpleStructure(DEConfig.COMMON.TreeHouse, DEUtil.pieceBuilder().offset(-11, 0, -12).add("tree_house").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.TreeHouse.getConfigured()).dimensions(DEConfig.COMMON.TreeHouse.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> TowerOfTheUndead = StructureRegistrar.builder((ResourceLocation)DEUtil.location("tower_of_the_undead"), () -> new DESimpleStructure(DEConfig.COMMON.TowerOfTheUndead, DEUtil.pieceBuilder().offset(-5, 0, -5).weight(3).add("tower_of_the_undead/small").offset(-7, 0, -7).weight(2).add("tower_of_the_undead/big").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.TowerOfTheUndead.getConfigured()).dimensions(DEConfig.COMMON.TowerOfTheUndead.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> WatchTower = StructureRegistrar.builder((ResourceLocation)DEUtil.location("watch_tower"), () -> new DESimpleStructure(DEConfig.COMMON.WatchTower, DEUtil.pieceBuilder().offset(-4, 0, -4).add("watch_tower").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.WatchTower.getConfigured()).dimensions(DEConfig.COMMON.WatchTower.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> WitchTower = StructureRegistrar.builder((ResourceLocation)DEUtil.location("witch_tower"), () -> new DESimpleStructure(DEConfig.COMMON.WitchTower, DEUtil.pieceBuilder().offset(-6, 0, -5).weight(3).add("witch_tower/normal").offset(-7, 0, -7).weight(2).add("witch_tower/big").build())).pushConfigured((FeatureConfiguration)NoneFeatureConfiguration.f_67816_).biomes(DEConfig.COMMON.WitchTower.getConfigured()).dimensions(DEConfig.COMMON.WitchTower.getConfigured()).adaptNoise().popConfigured().addPiece(DESimpleStructure.Piece::new).build();

    @SubscribeEvent
    public static void structureRegistry(RegistryEvent.Register<StructureFeature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        DEUtil.Processors.Types.register();
        for (StructureRegistrar<?, ?> structure : DEStructures.getAllStructureRegistrars()) {
            structure.handleForge(registry);
        }
        DECellarStructure.init();
        DungeonsEnhanced.LOGGER.info("Dungeons Enhanced structures loaded");
    }

    public static StructureRegistrar<?, ?>[] getAllStructureRegistrars() {
        return new StructureRegistrar[]{Castle, DeepCrypt, DesertTemple, DesertTomb, DruidCircle, DungeonVariant, EldersTemple, FishingShip, FlyingDutchman, HayStorage, IcePit, JungleMonument, LargeDungeon, MinersHouse, MonsterMaze, MushroomHouse, PillagerCamp, PirateShip, RuinedBuilding, Stables, SunkenShrine, TallWitchHut, TreeHouse, TowerOfTheUndead, WatchTower, WitchTower};
    }

    private static MobSpawnSettings.SpawnerData spawn(EntityType<?> entity, int weight) {
        return DEStructures.spawn(entity, weight, 1, 1);
    }

    private static MobSpawnSettings.SpawnerData spawn(EntityType<?> entity, int weight, int min, int max) {
        return new MobSpawnSettings.SpawnerData(entity, weight, min, max);
    }
}

