/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEStructurePiece;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEUnderwaterProcessor;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public class DEUtil {
    public static ResourceLocation location(String key) {
        return new ResourceLocation("dungeons_enhanced", key);
    }

    public static int getRandomPiece(DEStructurePiece[] variants, int maxWeight, Random rand) {
        int piece = 0;
        if (variants.length > 1) {
            int i = rand.nextInt(maxWeight + 1);
            for (int j = 0; j < variants.length; ++j) {
                if (variants[j].Weight >= i) {
                    piece = j;
                    break;
                }
                i -= variants[j].Weight;
            }
        }
        return piece;
    }

    public static int getMaxWeight(DEStructurePiece[] variants) {
        int i = 0;
        for (DEStructurePiece piece : variants) {
            i += piece.Weight;
        }
        return i;
    }

    public static DEStructurePiece.Builder pieceBuilder() {
        return new DEStructurePiece.Builder();
    }

    public static class Processors {
        public static final Holder<StructureProcessorList> AirToCobweb = Processors.register("air_to_cobweb", (StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50016_, 0.02f, Blocks.f_50033_));
        public static final StructureProcessor BrainCoral = new RandomBlockSwapProcessor(Blocks.f_50580_, 1.0f, Blocks.f_50585_);
        public static final StructureProcessor FireCoral = new RandomBlockSwapProcessor(Blocks.f_50582_, 1.0f, Blocks.f_50587_);
        public static final StructureProcessor BubbleCoral = new RandomBlockSwapProcessor(Blocks.f_50581_, 1.0f, Blocks.f_50586_);
        public static final StructureProcessor HornCoral = new RandomBlockSwapProcessor(Blocks.f_50583_, 1.0f, Blocks.f_50588_);
        public static final StructureProcessor TubeCoral = new RandomBlockSwapProcessor(Blocks.f_50579_, 1.0f, Blocks.f_50584_);

        private static Holder<StructureProcessorList> register(String key, StructureProcessor processor) {
            return RegistryHelper.registerProcessor((ResourceLocation)DEUtil.location(key), (StructureProcessor)processor);
        }

        private static Holder<StructureProcessorList> register(String key, StructureProcessorList processorList) {
            return RegistryHelper.registerProcessor((ResourceLocation)DEUtil.location(key), (StructureProcessorList)processorList);
        }

        public static class Types {
            public static final StructureProcessorType<DEUnderwaterProcessor> Underwater = () -> DEUnderwaterProcessor.CODEC;

            public static void register() {
                Types.register("underwater", Underwater);
            }

            private static <P extends StructureProcessor> void register(String key, StructureProcessorType<P> processorType) {
                Registry.m_122965_((Registry)Registry.f_122891_, (ResourceLocation)DEUtil.location(key), processorType);
            }
        }
    }
}

