/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structures;

import com.barion.dungeons_enhanced.DEConfig;
import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.api.structure.GelConfigJigsawStructure;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class DEDesertTomb
extends GelConfigJigsawStructure<JigsawConfiguration> {
    public DEDesertTomb() {
        super(JigsawConfiguration.f_67756_, DEConfig.COMMON.DesertTomb, 0, true, true, DEDesertTomb::checkLocation);
        Pool.init();
    }

    public boolean isAllowedNearWorldSpawn() {
        return true;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG)) {
            return DETerrainAnalyzer.isFlatEnough(context.f_197355_(), context.f_197352_(), DETerrainAnalyzer.defaultCheckSettings, context.f_197357_());
        }
        return false;
    }

    public static class Pool {
        public static Holder<StructureTemplatePool> Root;

        public static void init() {
        }

        static {
            JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_enhanced", "desert_tomb/");
            JigsawPoolBuilder poolBuilder = registry.builder().maintainWater(false).processors(DEUtil.Processors.AirToCobweb);
            Root = registry.register("root", (List)poolBuilder.clone().names(new String[]{"root"}).build());
            registry.register("down", (List)poolBuilder.clone().names(new String[]{"down"}).build());
            registry.register("trap", (List)poolBuilder.clone().names(new String[]{"trap"}).build());
            registry.register("cross", (List)poolBuilder.clone().names(new String[]{"t-cross"}).build());
            registry.register("main", (List)poolBuilder.clone().names((Map)ImmutableMap.of((Object)"tunnel", (Object)5, (Object)"t-cross", (Object)4, (Object)"room", (Object)4, (Object)"tomb", (Object)3, (Object)"exit", (Object)2)).build());
        }
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(StructureManager structureManager, StructurePoolElement poolElement, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
            super(structureManager, poolElement, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(serializationContext, nbt);
        }

        public StructurePieceType m_210000_() {
            return DEStructures.DesertTomb.getPieceType();
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor levelAccessor, Random random, BoundingBox box) {
        }
    }
}

