/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structures;

import com.barion.dungeons_enhanced.DEConfig;
import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEUnderwaterStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEUnderwaterProcessor;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import java.util.Optional;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DEEldersTemple
extends DEUnderwaterStructure {
    private static final ResourceLocation NE = DEUtil.location("elders_temple/ne");
    private static final ResourceLocation NW = DEUtil.location("elders_temple/nw");
    private static final ResourceLocation SE = DEUtil.location("elders_temple/se");
    private static final ResourceLocation SW = DEUtil.location("elders_temple/sw");

    public DEEldersTemple() {
        super(DEConfig.COMMON.EldersTemple, true, DEEldersTemple::checkLocation, DEEldersTemple::assembleTemple, DEUtil.pieceBuilder().add("elders_temple/se").build());
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context) {
        if (DETerrainAnalyzer.isUnderwater(context.f_197355_(), context.f_197352_(), 32, context.f_197357_())) {
            return DETerrainAnalyzer.areNearbyBiomesValid(context.f_197353_(), context.f_197355_(), context.f_197352_(), 30, context.f_197358_());
        }
        return false;
    }

    public static void assembleTemple(DEPieceAssembler.Context context) {
        Rotation rotation = Rotation.NONE;
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), SE, context.pos().m_142082_(0, 0, 0), rotation));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), SW, context.pos().m_142082_(-30, 0, 0), rotation));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), NE, context.pos().m_142082_(0, 0, -29), rotation));
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), NW, context.pos().m_142082_(-30, 0, -29), rotation));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(StructureManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super(DEStructures.EldersTemple.getPieceType(), 0, structureManager, templateName, Piece.getPlaceSettings(structureManager, templateName, pos, rotation), pos);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(DEStructures.EldersTemple.getPieceType(), nbt, serializationContext.f_192764_(), name -> Piece.getPlaceSettings(serializationContext.f_192764_(), name, new BlockPos(nbt.m_128451_("TPX"), nbt.m_128451_("TPY"), nbt.m_128451_("TPZ")), Rotation.valueOf((String)nbt.m_128461_("Rot"))));
        }

        protected static StructurePlaceSettings getPlaceSettings(StructureManager structureManager, ResourceLocation name, BlockPos pos, Rotation rotation) {
            Optional temp = structureManager.m_163774_(name);
            Vec3i size = Vec3i.f_123288_;
            if (temp.isPresent()) {
                size = ((StructureTemplate)temp.get()).m_163801_();
            }
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(true).m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2).m_7954_(Rotation.NONE));
            settings.m_74383_((StructureProcessor)DEUnderwaterProcessor.Instance).m_74383_(DEUtil.Processors.BrainCoral).m_74383_(DEUtil.Processors.BubbleCoral).m_74383_(DEUtil.Processors.FireCoral).m_74383_(DEUtil.Processors.HornCoral).m_74383_(DEUtil.Processors.TubeCoral);
            return settings;
        }

        @ParametersAreNonnullByDefault
        protected void m_7756_(String key, BlockPos pos, ServerLevelAccessor level, Random random, BoundingBox box) {
        }
    }
}

