/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structures;

import com.barion.dungeons_enhanced.DEConfig;
import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.legacy.structure_gel.api.structure.GelConfigJigsawStructure;
import com.legacy.structure_gel.api.structure.jigsaw.AbstractGelStructurePiece;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class DELargeDungeon
extends GelConfigJigsawStructure<JigsawConfiguration> {
    public DELargeDungeon() {
        super(JigsawConfiguration.f_67756_, DEConfig.COMMON.LargeDungeon, -16, true, true, DELargeDungeon::checkLocation);
        Pool.init();
    }

    public boolean isAllowedNearWorldSpawn() {
        return true;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG)) {
            return DETerrainAnalyzer.isFlatEnough(context.f_197355_(), context.f_197352_(), new DETerrainAnalyzer.Settings(1, 2, 2), context.f_197357_());
        }
        return false;
    }

    public static class Pool {
        public static Holder<StructureTemplatePool> Root;

        public static void init() {
        }

        static {
            JigsawRegistryHelper registry = new JigsawRegistryHelper("dungeons_enhanced", "large_dungeon/");
            JigsawPoolBuilder poolBuilder = registry.builder().maintainWater(false).processors(DEUtil.Processors.AirToCobweb);
            Root = registry.register("root", (List)poolBuilder.clone().names(new String[]{"root"}).build());
            JigsawPoolBuilder Cross = poolBuilder.clone().names(new String[]{"cross"});
            JigsawPoolBuilder Rooms = poolBuilder.clone().names(new String[]{"room_small1", "room_small2", "room1", "room2", "room_big", "parkour", "storage"});
            JigsawPoolBuilder Tunnels = poolBuilder.clone().names(new String[]{"tunnel"});
            JigsawPoolBuilder Stairs = poolBuilder.clone().names(new String[]{"stairs"});
            registry.register("cross", (List)Cross.build());
            registry.register("main", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{Tunnels.weight(4), Stairs.weight(2), Cross.weight(2), Rooms.weight(1)}));
        }
    }

    public static class Piece
    extends AbstractGelStructurePiece {
        public Piece(StructureManager structureManager, StructurePoolElement poolElement, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
            super(structureManager, poolElement, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(serializationContext, nbt);
        }

        public StructurePieceType m_210000_() {
            return DEStructures.LargeDungeon.getPieceType();
        }

        public void handleDataMarker(String key, BlockPos pos, ServerLevelAccessor levelAccessor, Random random, BoundingBox box) {
        }
    }
}

