/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structures.prefabs;

import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEStructurePiece;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.structure.GelConfigStructure;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class DEBaseStructure
extends GelConfigStructure<NoneFeatureConfiguration> {
    protected boolean generateNear00;

    public DEBaseStructure(StructureConfig config, DETerrainAnalyzer.GenerationType generationType, boolean generateNear00, Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheck, DEPieceAssembler assembler, DEStructurePiece[] variants) {
        super(NoneFeatureConfiguration.f_67815_, config, PieceGeneratorSupplier.m_197349_(context -> DEBaseStructure.checkLocation((PieceGeneratorSupplier.Context<NoneFeatureConfiguration>)context, locationCheck), (piecesBuilder, context) -> DEBaseStructure.generatePieces(piecesBuilder, (PieceGenerator.Context<NoneFeatureConfiguration>)context, generationType, variants, DEUtil.getMaxWeight(variants), assembler)));
        this.generateNear00 = generateNear00;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<NoneFeatureConfiguration> context, Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> locationCheck) {
        if (context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG)) {
            return locationCheck.test(context);
        }
        return false;
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, PieceGenerator.Context<NoneFeatureConfiguration> context, DETerrainAnalyzer.GenerationType generationType, DEStructurePiece[] variants, int maxWeight, DEPieceAssembler assembler) {
        int x = context.f_192705_().m_45604_();
        int z = context.f_192705_().m_45605_();
        int y = 72;
        ChunkGenerator chunkGen = context.f_192703_();
        LevelHeightAccessor heightAccessor = context.f_192707_();
        switch (generationType) {
            case onGround: 
            case onWater: {
                y = chunkGen.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
                break;
            }
            case underwater: {
                y = chunkGen.m_142647_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, heightAccessor);
                break;
            }
            case inAir: {
                int minY = chunkGen.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor) + 50;
                int maxY = 290;
                if (minY >= maxY) {
                    y = maxY;
                    break;
                }
                y = minY + context.f_192708_().nextInt(maxY - minY);
                break;
            }
            case underground: {
                int minY = chunkGen.m_142062_() + 10;
                int maxY = chunkGen.m_142647_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, heightAccessor) - 20;
                y = minY >= maxY ? maxY : minY + context.f_192708_().nextInt(maxY - minY);
            }
        }
        int piece = DEUtil.getRandomPiece(variants, maxWeight, (Random)context.f_192708_());
        assembler.assemble(new DEPieceAssembler.Context(context.f_192704_(), variants[piece].Resource, new BlockPos(x, y, z).m_141952_((Vec3i)variants[piece].Offset), Rotation.m_55956_((Random)context.f_192708_()), piecesBuilder, generationType));
    }

    public boolean isAllowedNearWorldSpawn() {
        return this.generateNear00;
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(StructurePieceType pieceType, StructureManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation, int componentType) {
            super(pieceType, componentType, structureManager, templateName, Piece.getPlaceSettings(structureManager, templateName, pos, rotation), pos);
        }

        public Piece(StructurePieceType pieceType, StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(pieceType, nbt, serializationContext.f_192764_(), name -> Piece.getPlaceSettings(serializationContext.f_192764_(), name, new BlockPos(nbt.m_128451_("TPX"), nbt.m_128451_("TPY"), nbt.m_128451_("TPZ")), Rotation.valueOf((String)nbt.m_128461_("Rot"))));
        }

        protected static StructurePlaceSettings getPlaceSettings(StructureManager structureManager, ResourceLocation name, BlockPos pos, Rotation rotation) {
            Optional temp = structureManager.m_163774_(name);
            Vec3i size = Vec3i.f_123288_;
            if (temp.isPresent()) {
                size = ((StructureTemplate)temp.get()).m_163801_();
            }
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(false).m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2).m_7954_(rotation));
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_).m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            return settings;
        }

        @ParametersAreNonnullByDefault
        protected void m_7756_(String key, BlockPos pos, ServerLevelAccessor level, Random random, BoundingBox box) {
        }
    }
}

