/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.data.providers;

import com.legacy.dungeons_plus.data.providers.DPAdvancementProv;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPSoundEvents;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;

public class DPLangProvider
extends LanguageProvider {
    public DPLangProvider(DataGenerator gen) {
        super(gen, "dungeons_plus", "en_us");
    }

    protected void addTranslations() {
        this.addAll((Registry)Registry.f_122824_, Map.of());
        this.addAll(Registry.f_122841_, Map.of());
        this.addAll(BuiltinRegistries.f_123862_, Map.of());
        this.addAll((Registry)Registry.f_122827_, Map.of());
        this.addAll((Registry)Registry.f_122826_, Map.of());
        this.add(DPLangProvider.mapName(DPStructures.REANIMATED_RUINS), "Reanimated Ruins Map");
        this.add(DPLangProvider.mapName(DPStructures.LEVIATHAN), "Leviathan Map");
        this.add(DPLangProvider.mapName(DPStructures.SNOWY_TEMPLE), "Snowy Temple Map");
        this.add(DPLangProvider.mapName(DPStructures.WARPED_GARDEN), "Warped Garden Map");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findTower, "Battle Towers?", "Find a Tower");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findReanimatedRuins, "Now this is a Dungeon", "Find the Reanimated Ruins");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findLeviathan, "Ancient Remains", "Find a Leviathan");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findSnowyTemple, "Snowed In", "Find a Snowy Temple");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findWarpedGarden, "Something Unnatural", "Find a Warped Garden");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findEndRuins, "A Ruined End", "Find End Ruins");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findSoulPrison, "Caged Tears", "Find the Soul Prison");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.killGhast, "Special Delivery", "Kill a ghast with a soul fireball");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.zombieVillagerWeakness, "Hurtful Healing", "Give a zombie villager weakness with the Leviathan Blade");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.hideInSnow, "Cold Campout", "Hide in powder snow with a Frosted Cowl");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.axePhantom, "What could go wrong?", "Throw a Warped Axe at a phantom from at least 25 meters away");
        this.add((Supplier<SoundEvent>)DPSoundEvents.SOUL_CANNON_SHOOT, "Soul Blaster shoots");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_THROW, "Warped Axe thrown");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_LAND, "Warped Axe lands");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_HIT, "Warped Axe hits");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_RETURN, "Warped Axe returns");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_TELEPORT, "Player teleports");
        this.add("death.attack.dungeons_plus.consume_soul", "%1$s consumed their own soul");
        this.add("death.attack.dungeons_plus.consume_soul.player", "%1$s consumed their soul whilst fighting %2$s");
        this.add("death.attack.dungeons_plus.warped_axe", "%1$s was cleaved by %2$s");
        this.add("death.attack.dungeons_plus.warped_axe.item", "%1$s was cleaved by %2$s with %3$s");
        this.add("item.dungeons_plus.info.hold_shift", "Hold [Shift] for info");
        this.addItemInfo((Supplier<Item>)DPItems.LEVIATHAN_BLADE, "weakness", "Afflicts targets with weakness.");
        this.addItemInfo((Supplier<Item>)DPItems.FROSTED_COWL, "freeze_immune", "Grants immunity to freezing.");
        this.addItemInfo((Supplier<Item>)DPItems.FROSTED_COWL, "slowness_immune", "Prevents the slowness potions from taking effect.");
        this.addItemInfo((Supplier<Item>)DPItems.WARPED_AXE, "teleport", "Teleports the user to who the axe was thrown at.");
        this.addItemInfo((Supplier<Item>)DPItems.SOUL_CANNON, "shoot", "Launches a fireball in the direction the user is facing.");
    }

    public static String mapName(StructureRegistrar<?, ?> structure) {
        return "filled_map." + structure.getRegistryName();
    }

    private void addAdvancement(Advancement advancement, String title, String desc) {
        DisplayInfo display = advancement.m_138320_();
        this.add(display.m_14977_().getString(), title);
        this.add(display.m_14985_().getString(), desc);
    }

    private <T> void addAll(Registry<T> registry, Map<ResourceKey<T>, String> overrides) {
        registry.m_6566_().stream().filter(name -> "dungeons_plus".equals(name.m_135827_())).map(name -> ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)name)).filter(key -> !overrides.containsKey(key)).forEach(this::add);
        overrides.forEach(this::add);
    }

    private void add(ResourceKey<?> key) {
        this.add(key, this.toName(key.m_135782_()));
    }

    private void add(ResourceKey<?> key, String translation) {
        this.add(this.makeDescriptionID(key), translation);
    }

    private void add(Supplier<SoundEvent> sound, String translation) {
        this.add("subtitle.dungeons_plus." + sound.get().m_11660_().m_135815_(), translation);
    }

    private void addItemInfo(Supplier<Item> item, String key, String translation) {
        ResourceKey resourceKey = (ResourceKey)Registry.f_122827_.m_7854_((Object)item.get()).get();
        ResourceLocation location = resourceKey.m_135782_();
        this.add(Util.m_137492_((String)resourceKey.m_211136_().m_135815_().replace('/', '.'), (ResourceLocation)new ResourceLocation(location.m_135827_(), location.m_135815_() + "." + key)), translation);
    }

    private String toName(ResourceLocation location) {
        String path = location.m_135815_();
        CharSequence[] words = path.split("_");
        for (int i = words.length - 1; i > -1; --i) {
            words[i] = ((String)words[i]).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)words[i]).substring(1).toLowerCase(Locale.ENGLISH);
        }
        return String.join((CharSequence)" ", words);
    }

    private String makeDescriptionID(ResourceKey<?> resourceKey) {
        return Util.m_137492_((String)resourceKey.m_211136_().m_135815_().replace('/', '.'), (ResourceLocation)resourceKey.m_135782_());
    }
}

