/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.legacy.dungeons_plus.registry.DPLoot;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class NamedLootItem
extends LootPoolSingletonContainer {
    private final ResourceLocation itemName;
    @Nullable
    private Item item = null;

    NamedLootItem(ResourceLocation itemName, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.itemName = itemName;
    }

    public LootPoolEntryType m_6751_() {
        return (LootPoolEntryType)DPLoot.NAMED_ITEM.get();
    }

    public void m_6948_(Consumer<ItemStack> stackAdder, LootContext context) {
        stackAdder.accept(new ItemStack((ItemLike)this.getItem()));
    }

    public Item getItem() {
        if (this.item == null) {
            this.item = ForgeRegistries.ITEMS.containsKey(this.itemName) ? (Item)ForgeRegistries.ITEMS.getValue(this.itemName) : Items.f_41852_;
        }
        return this.item;
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableItem(String namespace, String path) {
        return NamedLootItem.lootTableItem(new ResourceLocation(namespace, path));
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableItem(ResourceLocation namedItem) {
        return NamedLootItem.m_79687_((weight, quality, conditions, functions) -> new NamedLootItem(namedItem, weight, quality, conditions, functions));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<NamedLootItem> {
        public void serializeCustom(JsonObject json, NamedLootItem instance, JsonSerializationContext context) {
            super.m_7219_(json, (LootPoolSingletonContainer)instance, context);
            json.addProperty("name", instance.itemName.toString());
        }

        protected NamedLootItem deserialize(JsonObject json, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            ResourceLocation namedItem = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"name"));
            if (!ForgeRegistries.ITEMS.containsKey(namedItem)) {
                throw new IllegalArgumentException("Can't deserialize unknown item " + namedItem);
            }
            return new NamedLootItem(namedItem, weight, quality, conditions, functions);
        }
    }
}

