/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.registry;

import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.items.FrostedCowlItem;
import com.legacy.dungeons_plus.items.LeviathanBladeItem;
import com.legacy.dungeons_plus.items.SoulCannonItem;
import com.legacy.dungeons_plus.items.WarpedAxeItem;
import com.legacy.structure_gel.api.util.LazyOptional;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DPItems {
    private static List<Pair<String, LazyOptional<? extends Item>>> objs = new ArrayList<Pair<String, LazyOptional<? extends Item>>>();
    public static final LazyOptional<Item> FROSTED_COWL = DPItems.register("frosted_cowl", () -> new FrostedCowlItem(DPArmors.STRAY, EquipmentSlot.HEAD, new Item.Properties().m_41491_(CreativeModeTab.f_40757_)));
    public static final LazyOptional<Item> LEVIATHAN_BLADE = DPItems.register("leviathan_blade", () -> new LeviathanBladeItem(DPTiers.LEVIATHAN, 3, -2.6f, new Item.Properties().m_41491_(CreativeModeTab.f_40757_)));
    public static final LazyOptional<Item> WARPED_AXE = DPItems.register("warped_axe", () -> new WarpedAxeItem(DPTiers.WARPED_GOLD, 7.0f, -3.1f, new Item.Properties().m_41503_(312).m_41491_(CreativeModeTab.f_40757_)));
    public static final LazyOptional<Item> SOUL_CANNON = DPItems.register("soul_cannon", () -> new SoulCannonItem(new Item.Properties().m_41503_(250).m_41491_(CreativeModeTab.f_40757_)));

    @SubscribeEvent
    protected static void onRegistry(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        objs.forEach(p -> {
            Item item = (Item)((LazyOptional)p.getSecond()).get();
            item.setRegistryName(DungeonsPlus.locate((String)p.getFirst()));
            registry.register((IForgeRegistryEntry)item);
        });
        objs = null;
    }

    private static <T extends Item> LazyOptional<T> register(String key, Supplier<T> obj) {
        LazyOptional laz = LazyOptional.of(obj);
        objs.add((Pair<String, LazyOptional<? extends Item>>)Pair.of((Object)key, (Object)laz));
        return laz;
    }

    public static interface DPTiers {
        public static final Tier LEVIATHAN = new ForgeTier(2, 1000, 7.0f, 2.5f, 12, BlockTags.f_144285_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42262_}));
        public static final Tier WARPED_GOLD = new ForgeTier(1, 275, 10.0f, 1.0f, 18, BlockTags.f_144286_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_}));
    }

    public static interface DPArmors {
        public static final ArmorMaterial STRAY = new DPArmorMaterial(DungeonsPlus.locate("stray").toString(), 10, new int[]{1, 2, 4, 2}, 12, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_((TagKey)ItemTags.f_13167_));
    }

    private static final class DPArmorMaterial
    implements ArmorMaterial {
        private static final int[] HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
        private final String name;
        private final int durabilityMultiplier;
        private final int[] slotProtections;
        private final int enchantmentValue;
        private final SoundEvent sound;
        private final float toughness;
        private final float knockbackResistance;
        private final Lazy<Ingredient> repairIngredient;

        private DPArmorMaterial(String name, int durabilityModifier, int[] slotProtections, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
            this.name = name;
            this.durabilityMultiplier = durabilityModifier;
            this.slotProtections = slotProtections;
            this.enchantmentValue = enchantmentValue;
            this.sound = sound;
            this.toughness = toughness;
            this.knockbackResistance = knockbackResistance;
            this.repairIngredient = Lazy.of(repairIngredient);
        }

        public int m_7366_(EquipmentSlot slot) {
            return HEALTH_PER_SLOT[slot.m_20749_()] * this.durabilityMultiplier;
        }

        public int m_7365_(EquipmentSlot slot) {
            return this.slotProtections[slot.m_20749_()];
        }

        public int m_6646_() {
            return this.enchantmentValue;
        }

        public SoundEvent m_7344_() {
            return this.sound;
        }

        public Ingredient m_6230_() {
            return (Ingredient)this.repairIngredient.get();
        }

        public String m_6082_() {
            return this.name;
        }

        public float m_6651_() {
            return this.toughness;
        }

        public float m_6649_() {
            return this.knockbackResistance;
        }
    }
}

