/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.structures;

import com.legacy.dungeons_plus.DPUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ServerLevelAccessor;

public class PsuedoFeature {
    private final int minPlacements;
    private final int maxPlacements;
    private final IPlacement placement;
    private final IPlacer placer;

    public PsuedoFeature(int minPlacements, int maxPlacements, IPlacement placement, IPlacer placer) throws IllegalArgumentException {
        this.minPlacements = minPlacements;
        this.maxPlacements = maxPlacements;
        this.placement = placement;
        this.placer = placer;
        if (minPlacements < 0) {
            throw new IllegalArgumentException("SuedoFeature minPlacements cannot be negative. Value = " + minPlacements);
        }
        if (maxPlacements < minPlacements) {
            throw new IllegalArgumentException("SuedoFeature maxPlacements is less than minPlacements. " + maxPlacements + " < " + minPlacements);
        }
    }

    public void place(ServerLevelAccessor level, BlockPos pos, Random rand) {
        for (int i = rand.nextInt(this.maxPlacements + 1 - this.minPlacements) + this.minPlacements; i > -1; --i) {
            this.placer.place(level, this.placement.mutatePos(DPUtil.randOffset(pos, 6, rand), level, rand), rand);
        }
    }

    @FunctionalInterface
    public static interface IPlacement {
        public static final IPlacement NOOP = (pos, level, rand) -> pos;
        public static final IPlacement FIND_LOWEST_AIR = (pos, level, rand) -> {
            BlockPos.MutableBlockPos mutPos = pos.m_122032_();
            for (int dist = 0; level.m_8055_((BlockPos)mutPos).m_60795_() && dist < 16; ++dist) {
                mutPos.m_122173_(Direction.DOWN);
            }
            return mutPos.m_122173_(Direction.UP).m_7949_();
        };
        public static final IPlacement FIND_HIGHEST_AIR = (pos, level, rand) -> {
            BlockPos.MutableBlockPos mutPos = pos.m_122032_();
            for (int dist = 0; level.m_8055_((BlockPos)mutPos).m_60795_() && dist < 16; ++dist) {
                mutPos.m_122173_(Direction.UP);
            }
            return mutPos.m_122173_(Direction.DOWN).m_7949_();
        };

        public BlockPos mutatePos(BlockPos var1, ServerLevelAccessor var2, Random var3);
    }

    @FunctionalInterface
    public static interface IPlacer {
        public void place(ServerLevelAccessor var1, BlockPos var2, Random var3);
    }
}

