/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import samebutdifferent.ecologics.entity.Squirrel;
import samebutdifferent.ecologics.util.AnimationUtil;

@OnlyIn(value=Dist.CLIENT)
public class SquirrelModel
extends AgeableListModel<Squirrel> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("ecologics", "squirrel"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart leftThigh;
    private final ModelPart leftFoot;
    private final ModelPart rightLeg;
    private final ModelPart rightThigh;
    private final ModelPart rightFoot;
    private final ModelPart tail;

    public SquirrelModel(ModelPart root) {
        super(true, 9.0f, 2.0f);
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
        this.leftArm = this.body.m_171324_("leftArm");
        this.rightArm = this.body.m_171324_("rightArm");
        this.leftLeg = this.body.m_171324_("leftLeg");
        this.leftThigh = this.leftLeg.m_171324_("leftThigh");
        this.leftFoot = this.leftThigh.m_171324_("leftFoot");
        this.rightLeg = this.body.m_171324_("rightLeg");
        this.rightThigh = this.rightLeg.m_171324_("rightThigh");
        this.rightFoot = this.rightThigh.m_171324_("rightFoot");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(16, 15).m_171488_(-2.0f, -3.0f, -4.1667f, 4.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(11, 15).m_171488_(1.0f, -5.0f, -1.1667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(11, 15).m_171480_().m_171488_(-3.0f, -5.0f, -1.1667f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-3.8333f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -2.5f, -5.0f, 6.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)18.5f, (float)2.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.5f, (float)-3.5f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)0.5f, (float)-3.5f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)-2.0f));
        PartDefinition leftThigh = leftLeg.m_171599_("leftThigh", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-4.0f, (float)4.5f));
        PartDefinition leftFoot = leftThigh.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-1.0f, -0.5f, -7.0f, 2.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)3.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.5f, (float)-2.0f));
        PartDefinition rightThigh = rightLeg.m_171599_("rightThigh", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)-4.0f, (float)4.5f));
        PartDefinition rightFoot = rightThigh.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171480_().m_171488_(-1.0f, -0.5f, -5.5f, 2.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)1.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(16, 24).m_171488_(-1.5f, -11.0f, 0.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 15).m_171488_(-1.5f, -11.0f, 3.0f, 3.0f, 8.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.5f, (float)4.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(Squirrel entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupInitialAnimationValues();
        float swingCorrectionFactor = 0.1f;
        float correctedLimbSwing = entity.m_6162_() ? limbSwing / 3.0f : limbSwing;
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ += Mth.m_14089_((float)((float)Math.toRadians(-45.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.8f) * limbSwingAmount;
        this.head.f_104201_ = this.head.f_104201_ + (-1.0f - Mth.m_14089_((float)correctedLimbSwing)) * (float)(entity.m_6162_() ? 1 : 2) * limbSwingAmount;
        this.head.f_104202_ += 1.0f * limbSwingAmount;
        this.body.f_104203_ = (float)((double)this.body.f_104203_ + (Math.toRadians(10.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-30.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 3.5f) * (double)limbSwingAmount);
        this.body.f_104201_ += (-1.0f - Mth.m_14089_((float)correctedLimbSwing)) * 2.0f * limbSwingAmount;
        this.leftArm.f_104203_ = (float)((double)this.leftArm.f_104203_ + (Math.toRadians(-15.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-35.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 7.5f) * (double)limbSwingAmount);
        this.leftArm.f_104204_ = (float)((double)this.leftArm.f_104204_ + Math.toRadians(-5.0));
        this.leftArm.f_104205_ = (float)((double)this.leftArm.f_104205_ + (Math.toRadians(-15.0) - (double)Mth.m_14089_((float)correctedLimbSwing)) * (double)(swingCorrectionFactor * 2.0f) * (double)limbSwingAmount);
        this.leftArm.f_104202_ += (0.5f + Mth.m_14089_((float)correctedLimbSwing)) * (swingCorrectionFactor * 0.05f) * limbSwingAmount;
        this.rightArm.f_104203_ = (float)((double)this.rightArm.f_104203_ + (Math.toRadians(-15.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-45.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 7.5f) * (double)limbSwingAmount);
        this.rightArm.f_104204_ = (float)((double)this.rightArm.f_104204_ + Math.toRadians(-5.0));
        this.rightArm.f_104205_ = (float)((double)this.rightArm.f_104205_ + (Math.toRadians(15.0) - (double)Mth.m_14089_((float)correctedLimbSwing)) * (double)(swingCorrectionFactor * 2.0f) * (double)limbSwingAmount);
        this.rightArm.f_104202_ += (0.5f + Mth.m_14089_((float)((float)Math.toRadians(-25.0) + correctedLimbSwing))) * (swingCorrectionFactor * 0.05f) * limbSwingAmount;
        this.leftThigh.f_104203_ = (float)((double)this.leftThigh.f_104203_ + (Math.toRadians(45.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-45.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.5f) * (double)limbSwingAmount);
        this.leftThigh.f_104201_ += -3.0f * (swingCorrectionFactor * 7.0f) * limbSwingAmount;
        this.leftThigh.f_104202_ += Mth.m_14089_((float)((float)Math.toRadians(-35.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.1f) * limbSwingAmount;
        this.leftFoot.f_104203_ = (float)((double)this.leftFoot.f_104203_ + (Math.toRadians(25.0) + (double)Mth.m_14089_((float)((float)Math.toRadians(-125.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.0f) * (double)limbSwingAmount);
        this.leftFoot.f_104201_ += -1.0f * (swingCorrectionFactor * 2.0f) * limbSwingAmount;
        this.leftFoot.f_104202_ += (-0.5f + Mth.m_14089_((float)correctedLimbSwing)) * (swingCorrectionFactor * 0.025f) * limbSwingAmount;
        this.rightLeg.f_104201_ += -1.0f * swingCorrectionFactor * limbSwingAmount;
        this.rightThigh.f_104203_ = (float)((double)this.rightThigh.f_104203_ + (Math.toRadians(45.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-25.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.5f) * (double)limbSwingAmount);
        this.rightThigh.f_104201_ += -2.0f * (swingCorrectionFactor * 7.0f) * limbSwingAmount;
        this.rightThigh.f_104202_ += Mth.m_14089_((float)((float)Math.toRadians(-35.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.1f) * limbSwingAmount;
        this.rightFoot.f_104203_ = (float)((double)this.rightFoot.f_104203_ + (Math.toRadians(15.0) + (double)Mth.m_14089_((float)((float)Math.toRadians(-85.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 6.0f) * (double)limbSwingAmount);
        this.rightFoot.f_104201_ += -1.0f * (swingCorrectionFactor * 2.0f) * limbSwingAmount;
        this.rightFoot.f_104202_ += (-0.5f + Mth.m_14089_((float)correctedLimbSwing)) * (swingCorrectionFactor * 0.025f) * limbSwingAmount;
        this.tail.f_104203_ = (float)((double)this.tail.f_104203_ + (Math.toRadians(-40.0) - (double)Mth.m_14089_((float)((float)Math.toRadians(-120.0) + correctedLimbSwing))) * (double)(swingCorrectionFactor * 1.8f) * (double)limbSwingAmount);
        this.tail.f_104202_ += Mth.m_14089_((float)((float)Math.toRadians(-100.0) + correctedLimbSwing)) * (swingCorrectionFactor * 0.03f) * limbSwingAmount;
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body);
    }

    private void setupInitialAnimationValues() {
        AnimationUtil.setInitialValue(this.head, 0.0f, 18.0f, -3.8333f);
        AnimationUtil.setInitialValue(this.body, 0.0f, 18.5f, 2.0f);
        AnimationUtil.setInitialValue(this.leftArm, 3.0f, 0.5f, -3.5f);
        AnimationUtil.setInitialValue(this.rightArm, -3.0f, 0.5f, -3.5f);
        AnimationUtil.setInitialValue(this.leftLeg, 0.0f, 5.5f, -2.0f);
        AnimationUtil.setInitialValue(this.leftThigh, 3.0f, -4.0f, 4.5f);
        AnimationUtil.setInitialValue(this.leftFoot, 0.0f, 3.5f, 3.0f);
        AnimationUtil.setInitialValue(this.rightLeg, 0.0f, 5.5f, -2.0f);
        AnimationUtil.setInitialValue(this.rightThigh, -3.0f, -4.0f, 4.5f);
        AnimationUtil.setInitialValue(this.rightFoot, 0.0f, 3.5f, 1.5f);
        AnimationUtil.setInitialValue(this.tail, 0.0f, -2.5f, 4.0f, -0.7854f, 0.0f, 0.0f);
    }
}

