/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.particle;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ParticleSnowFlake
extends TextureSheetParticle {
    private int swirlTick;
    private final float spread;
    boolean swirls;

    public ParticleSnowFlake(ClientLevel world, double x, double y, double z, double vX, double vY, double vZ, double duration, boolean swirls) {
        super(world, x, y, z);
        this.m_107250_(1.0f, 1.0f);
        this.f_107215_ = vX;
        this.f_107216_ = vY;
        this.f_107217_ = vZ;
        this.f_107225_ = (int)duration;
        this.swirlTick = this.f_107223_.nextInt(120);
        this.spread = this.f_107223_.nextFloat();
        this.swirls = swirls;
    }

    protected float m_5952_() {
        return super.m_5952_() - (super.m_5952_() - super.m_5970_()) / 8.0f;
    }

    protected float m_5950_() {
        return super.m_5950_() - (super.m_5950_() - super.m_5951_()) / 8.0f;
    }

    public ParticleRenderType m_7556_() {
        return MMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.swirls) {
            Vector3f motionVec = new Vector3f((float)this.f_107215_, (float)this.f_107216_, (float)this.f_107217_);
            motionVec.m_122278_();
            float yaw = (float)Math.atan2(motionVec.m_122239_(), motionVec.m_122269_());
            float pitch = (float)Math.atan2(motionVec.m_122260_(), 1.0);
            float swirlRadius = 4.0f * ((float)this.f_107224_ / (float)this.f_107225_) * this.spread;
            Quaternion quatSpin = motionVec.m_122270_((float)this.swirlTick * 0.2f);
            Quaternion quatOrient = new Quaternion(pitch, yaw, 0.0f, false);
            Vector3f vec = new Vector3f(swirlRadius, 0.0f, 0.0f);
            vec.m_122251_(quatOrient);
            vec.m_122251_(quatSpin);
            this.f_107212_ += (double)vec.m_122239_();
            this.f_107213_ += (double)vec.m_122260_();
            this.f_107214_ += (double)vec.m_122269_();
        }
        if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
        ++this.f_107224_;
        ++this.swirlTick;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float var = ((float)this.f_107224_ + partialTicks) / (float)this.f_107225_;
        this.f_107230_ = (float)(1.0 - Math.exp(10.0f * (var - 1.0f)) - Math.pow(2000.0, -var));
        if ((double)this.f_107230_ < 0.01) {
            this.f_107230_ = 0.01f;
        }
        super.m_5744_(buffer, renderInfo, partialTicks);
    }

    public static class SnowflakeData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<SnowflakeData> DESERIALIZER = new ParticleOptions.Deserializer<SnowflakeData>(){

            public SnowflakeData fromCommand(ParticleType<SnowflakeData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float duration = (float)reader.readDouble();
                reader.expect(' ');
                boolean swirls = reader.readBoolean();
                return new SnowflakeData(duration, swirls);
            }

            public SnowflakeData fromNetwork(ParticleType<SnowflakeData> particleTypeIn, FriendlyByteBuf buffer) {
                return new SnowflakeData(buffer.readFloat(), buffer.readBoolean());
            }
        };
        private final float duration;
        private final boolean swirls;

        public SnowflakeData(float duration, boolean spins) {
            this.duration = duration;
            this.swirls = spins;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.duration);
            buffer.writeBoolean(this.swirls);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %b", Registry.f_122829_.m_7981_(this.m_6012_()), Float.valueOf(this.duration), this.swirls);
        }

        public ParticleType<SnowflakeData> m_6012_() {
            return (ParticleType)ParticleHandler.SNOWFLAKE.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getDuration() {
            return this.duration;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean getSwirls() {
            return this.swirls;
        }

        public static Codec<SnowflakeData> CODEC(ParticleType<SnowflakeData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.FLOAT.fieldOf("duration").forGetter(SnowflakeData::getDuration), (App)Codec.BOOL.fieldOf("swirls").forGetter(SnowflakeData::getSwirls)).apply((Applicative)codecBuilder, SnowflakeData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class SnowFlakeFactory
    implements ParticleProvider<SnowflakeData> {
        private final SpriteSet spriteSet;

        public SnowFlakeFactory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(SnowflakeData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSnowFlake particle = new ParticleSnowFlake(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getDuration(), typeIn.getSwirls());
            particle.m_108335_(this.spriteSet);
            return particle;
        }
    }
}

