/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBarako;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.client.render.MowzieRenderUtils;
import com.bobmowzie.mowziesmobs.client.render.entity.RenderSunstrike;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.SunblockLayer;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderBarako
extends MobRenderer<EntityBarako, ModelBarako<EntityBarako>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mowziesmobs", "textures/entity/barako.png");
    private static final ResourceLocation TEXTURE_OLD = new ResourceLocation("mowziesmobs", "textures/entity/barako_old.png");
    private static final float BURST_RADIUS = 3.5f;
    private static final int BURST_FRAME_COUNT = 10;
    private static final int BURST_START_FRAME = 12;

    public RenderBarako(EntityRendererProvider.Context mgr) {
        super(mgr, new ModelBarako(), 1.0f);
        this.m_115326_(new SunblockLayer(this));
    }

    protected float getFlipDegrees(EntityBarako entity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(EntityBarako entity) {
        return (Boolean)ConfigHandler.CLIENT.oldBarakoaTextures.get() != false ? TEXTURE_OLD : TEXTURE;
    }

    public void render(EntityBarako barako, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (!barako.m_20145_() && barako.getAnimation() == EntityBarako.ATTACK_ANIMATION && barako.getAnimationTick() > 12 && barako.getAnimationTick() < 21) {
            matrixStackIn.m_85836_();
            Quaternion quat = this.f_114476_.m_114470_();
            matrixStackIn.m_85845_(quat);
            matrixStackIn.m_85837_(0.0, 1.0, 0.0);
            matrixStackIn.m_85841_(0.8f, 0.8f, 0.8f);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(MMRenderType.getSolarFlare(RenderSunstrike.TEXTURE));
            PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
            Matrix4f matrix4f = matrixstack$entry.m_85861_();
            Matrix3f matrix3f = matrixstack$entry.m_85864_();
            this.drawBurst(matrix4f, matrix3f, ivertexbuilder, (float)(barako.getAnimationTick() - 12) + delta, packedLightIn);
            matrixStackIn.m_85849_();
        }
        super.m_7392_((Mob)barako, entityYaw, delta, matrixStackIn, bufferIn, packedLightIn);
        if (barako.getAnimation() == EntityBarako.SUPERNOVA_ANIMATION && barako.betweenHandPos != null && barako.betweenHandPos.length > 0) {
            barako.betweenHandPos[0] = MowzieRenderUtils.getWorldPosFromModel((Entity)barako, entityYaw, ((ModelBarako)this.m_7200_()).betweenHands);
        }
    }

    private void drawBurst(Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer builder, float tick, int packedLightIn) {
        int frame;
        int dissapateFrame = 6;
        float firstSpeed = 2.0f;
        float secondSpeed = 1.0f;
        int n = frame = (int)(tick * firstSpeed) <= dissapateFrame ? (int)(tick * firstSpeed) : (int)((float)dissapateFrame + (tick - (float)dissapateFrame / firstSpeed) * secondSpeed);
        if (frame > 10) {
            frame = 10;
        }
        float minU = 0.0625f * (float)frame;
        float maxU = minU + 0.0625f;
        float minV = 0.5f;
        float maxV = minV + 0.5f;
        float offset = 0.219f * (float)(frame % 2);
        float opacity = tick < 8.0f ? 0.8f : 0.4f;
        this.drawVertex(matrix4f, matrix3f, builder, -3.5f + offset, -3.5f + offset, 0.0f, minU, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -3.5f + offset, 3.5f + offset, 0.0f, minU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 3.5f + offset, 3.5f + offset, 0.0f, maxU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 3.5f + offset, -3.5f + offset, 0.0f, maxU, minV, opacity, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        vertexBuilder.m_85982_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f * alpha).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

