/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelBarakoa;
import com.bobmowzie.mowziesmobs.client.render.MowzieRenderUtils;
import com.bobmowzie.mowziesmobs.client.render.entity.layer.ItemLayer;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderBarakoa
extends MobRenderer<EntityBarakoa, ModelBarakoa<EntityBarakoa>> {
    private static final EnumMap<MaskType, ResourceLocation> TEXTURES = MaskType.newEnumMap(ResourceLocation.class, new ResourceLocation[0]);
    private static final EnumMap<MaskType, ResourceLocation> WADOO_TEXTURES = MaskType.newEnumMap(ResourceLocation.class, new ResourceLocation[0]);

    public RenderBarakoa(EntityRendererProvider.Context mgr) {
        super(mgr, new ModelBarakoa(), 0.6f);
        this.m_115326_(new ItemLayer(this, ((ModelBarakoa)this.m_7200_()).bone, Items.f_42500_.m_7968_(), ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND));
        this.m_115326_(new ItemLayer(this, ((ModelBarakoa)this.m_7200_()).spear, ItemHandler.SPEAR.m_7968_(), ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND));
        this.m_115326_(new ItemLayer(this, ((ModelBarakoa)this.m_7200_()).blowgun, ItemHandler.BLOWGUN.m_7968_(), ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND));
        this.m_115326_(new ItemLayer(this, ((ModelBarakoa)this.m_7200_()).staff, ItemHandler.SUNBLOCK_STAFF.m_7968_(), ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND));
    }

    public void render(EntityBarakoa entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        boolean healingAnim = entityIn.getAnimation() == EntityBarakoa.HEAL_LOOP_ANIMATION || entityIn.getAnimation() == EntityBarakoa.HEAL_START_ANIMATION || entityIn.getAnimation() == EntityBarakoa.HEAL_STOP_ANIMATION;
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20884_, (float)entityIn.f_20883_);
        if (healingAnim && entityIn.staffPos != null && entityIn.staffPos.length > 0) {
            entityIn.staffPos[0] = MowzieRenderUtils.getWorldPosFromModel((Entity)entityIn, f, ((ModelBarakoa)this.m_7200_()).staffEnd);
        }
    }

    protected float getFlipDegrees(EntityBarakoa entity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(EntityBarakoa entity) {
        String s = ChatFormatting.m_126649_((String)entity.m_7755_().getString());
        if (s != null && s.equals("Wadoo")) {
            return WADOO_TEXTURES.get((Object)entity.getMask());
        }
        return TEXTURES.get((Object)entity.getMask());
    }

    static {
        for (MaskType mask : MaskType.values()) {
            TEXTURES.put(mask, new ResourceLocation("mowziesmobs", "textures/entity/barakoa_" + mask.name + ((Boolean)ConfigHandler.CLIENT.oldBarakoaTextures.get() != false ? "_old" : "") + ".png"));
            WADOO_TEXTURES.put(mask, new ResourceLocation("mowziesmobs", "textures/entity/barakoa_" + mask.name + "_wadoo.png"));
        }
    }
}

