/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity.player;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelGeckoPlayerFirstPerson;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.render.MowzieRenderUtils;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatableModel;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;
import software.bernie.geckolib3.util.RenderUtils;

@OnlyIn(value=Dist.CLIENT)
public class GeckoFirstPersonRenderer
extends ItemInHandRenderer
implements IGeoRenderer<GeckoPlayer> {
    public MultiBufferSource rtb;
    public static GeckoPlayer.GeckoPlayerFirstPerson GECKO_PLAYER_FIRST_PERSON;
    private static HashMap<Class<? extends GeckoPlayer>, GeckoFirstPersonRenderer> modelsToLoad;
    private ModelGeckoPlayerFirstPerson modelProvider;
    boolean mirror;

    public GeckoFirstPersonRenderer(Minecraft mcIn, ModelGeckoPlayerFirstPerson modelProvider) {
        super(mcIn);
        this.modelProvider = modelProvider;
    }

    public GeckoFirstPersonRenderer getModelProvider(Class<? extends GeckoPlayer> animatable) {
        return modelsToLoad.get(animatable);
    }

    public HashMap<Class<? extends GeckoPlayer>, GeckoFirstPersonRenderer> getModelsToLoad() {
        return modelsToLoad;
    }

    public void renderItemInFirstPerson(AbstractClientPlayer player, float pitch, float partialTicks, InteractionHand handIn, float swingProgress, ItemStack stack, float equippedProgress, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, GeckoPlayer geckoPlayer) {
        this.rtb = bufferIn;
        boolean flag = handIn == InteractionHand.MAIN_HAND;
        HumanoidArm handside = flag ? player.m_5737_() : player.m_5737_().m_20828_();
        boolean bl = this.mirror = player.m_5737_() == HumanoidArm.LEFT;
        if (flag) {
            this.modelProvider.setTextureFromPlayer(player);
            this.modelProvider.setLivingAnimations(geckoPlayer, (Integer)player.m_142081_().hashCode());
            RenderType rendertype = RenderType.m_110467_((ResourceLocation)this.getTextureLocation(geckoPlayer));
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(rendertype);
            matrixStackIn.m_85837_(0.0, -2.0, -1.0);
            this.render(this.getGeoModelProvider().getModel(this.getGeoModelProvider().getModelLocation((Object)geckoPlayer)), geckoPlayer, partialTicks, rendertype, matrixStackIn, bufferIn, ivertexbuilder, combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        PlayerAbility.HandDisplay handDisplay = PlayerAbility.HandDisplay.DEFAULT;
        float offHandEquipProgress = 0.0f;
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
        if (abilityCapability != null && abilityCapability.getActiveAbility() != null) {
            Ability ability = abilityCapability.getActiveAbility();
            if (ability instanceof PlayerAbility) {
                ItemStack stackOverride;
                PlayerAbility playerAbility = (PlayerAbility)ability;
                ItemStack itemStack = stackOverride = flag ? playerAbility.heldItemMainHandOverride() : playerAbility.heldItemOffHandOverride();
                if (stackOverride != null) {
                    stack = stackOverride;
                }
                PlayerAbility.HandDisplay handDisplay2 = handDisplay = flag ? playerAbility.getFirstPersonMainHandDisplay() : playerAbility.getFirstPersonOffHandDisplay();
            }
            if (ability.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
                offHandEquipProgress = Mth.m_14036_((float)(1.0f - ((float)ability.getTicksInSection() + partialTicks) / 5.0f), (float)0.0f, (float)1.0f);
            } else if (ability.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.RECOVERY && ability.getCurrentSection() instanceof AbilitySection.AbilitySectionDuration) {
                offHandEquipProgress = Mth.m_14036_((float)(((float)ability.getTicksInSection() + partialTicks - (float)((AbilitySection.AbilitySectionDuration)ability.getCurrentSection()).duration + 5.0f) / 5.0f), (float)0.0f, (float)1.0f);
            }
        }
        if (handDisplay != PlayerAbility.HandDisplay.DONT_RENDER && this.modelProvider.isInitialized()) {
            int sideMult;
            int n = sideMult = handside == HumanoidArm.RIGHT ? -1 : 1;
            if (this.mirror) {
                handside = handside.m_20828_();
            }
            String sideName = handside == HumanoidArm.RIGHT ? "Right" : "Left";
            String boneName = sideName + "Arm";
            MowzieGeoBone bone = this.modelProvider.getMowzieBone(boneName);
            PoseStack newMatrixStack = new PoseStack();
            float fixedPitchController = 1.0f - this.modelProvider.getControllerValue("FixedPitchController" + sideName);
            newMatrixStack.m_85845_(new Quaternion(Vector3f.f_122223_, pitch * fixedPitchController, true));
            newMatrixStack.m_85850_().m_85864_().m_8178_(bone.getWorldSpaceNormal());
            newMatrixStack.m_85850_().m_85861_().m_27644_(bone.getWorldSpaceXform());
            newMatrixStack.m_85837_((double)sideMult * 0.547, 0.7655, 0.625);
            if (this.mirror) {
                handside = handside.m_20828_();
            }
            if (stack.m_41619_() && !flag && handDisplay == PlayerAbility.HandDisplay.FORCE_RENDER && !player.m_20145_()) {
                newMatrixStack.m_85837_(0.0, (double)(-1.0f * offHandEquipProgress), 0.0);
                super.m_109346_(newMatrixStack, bufferIn, combinedLightIn, 0.0f, 0.0f, handside);
            } else {
                super.m_109371_(player, partialTicks, pitch, handIn, 0.0f, stack, 0.0f, newMatrixStack, bufferIn, combinedLightIn);
            }
        }
    }

    public void setSmallArms() {
        this.modelProvider.setUseSmallArms(true);
    }

    public GeoModelProvider<GeckoPlayer> getGeoModelProvider() {
        return this.modelProvider;
    }

    public ModelGeckoPlayerFirstPerson getAnimatedPlayerModel() {
        return this.modelProvider;
    }

    public ResourceLocation getTextureLocation(GeckoPlayer geckoPlayer) {
        return ((AbstractClientPlayer)geckoPlayer.getPlayer()).m_108560_();
    }

    public void renderRecursively(GeoBone bone, PoseStack matrixStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStack.m_85836_();
        if (this.mirror) {
            MowzieRenderUtils.translateMirror(bone, matrixStack);
            MowzieRenderUtils.moveToPivotMirror(bone, matrixStack);
            MowzieRenderUtils.rotateMirror(bone, matrixStack);
            RenderUtils.scale((GeoBone)bone, (PoseStack)matrixStack);
        } else {
            RenderUtils.translate((GeoBone)bone, (PoseStack)matrixStack);
            RenderUtils.moveToPivot((GeoBone)bone, (PoseStack)matrixStack);
            RenderUtils.rotate((GeoBone)bone, (PoseStack)matrixStack);
            RenderUtils.scale((GeoBone)bone, (PoseStack)matrixStack);
        }
        if (bone instanceof MowzieGeoBone) {
            MowzieGeoBone mowzieBone = (MowzieGeoBone)bone;
            if (mowzieBone.name.equals("LeftArm") || mowzieBone.name.equals("RightArm")) {
                matrixStack.m_85836_();
                PoseStack.Pose entry = matrixStack.m_85850_();
                mowzieBone.setWorldSpaceNormal(entry.m_85864_().m_8183_());
                mowzieBone.setWorldSpaceXform(entry.m_85861_().m_27658_());
                matrixStack.m_85849_();
            }
        }
        if (this.mirror) {
            MowzieRenderUtils.moveBackFromPivotMirror(bone, matrixStack);
        } else {
            RenderUtils.moveBackFromPivot((GeoBone)bone, (PoseStack)matrixStack);
        }
        if (!bone.isHidden) {
            for (GeoCube cube : bone.childCubes) {
                matrixStack.m_85836_();
                this.renderCube(cube, matrixStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
                matrixStack.m_85849_();
            }
            for (GeoBone childBone : bone.childBones) {
                this.renderRecursively(childBone, matrixStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
        matrixStack.m_85849_();
    }

    public void setCurrentRTB(MultiBufferSource rtb) {
        this.rtb = rtb;
    }

    public MultiBufferSource getCurrentRTB() {
        return this.rtb;
    }

    static {
        modelsToLoad = new HashMap();
        AnimationController.addModelFetcher(object -> {
            if (object instanceof GeckoPlayer.GeckoPlayerFirstPerson) {
                GeckoFirstPersonRenderer render = modelsToLoad.get(object.getClass());
                return (IAnimatableModel)render.getGeoModelProvider();
            }
            return null;
        });
    }
}

