/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities.geomancy;

import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.ability.PlayerAbility;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityPillar;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;

public class SpawnPillarAbility
extends PlayerAbility {
    private static int MAX_DURATION = 120;
    private static int MAX_RANGE_TO_GROUND = 12;
    private BlockPos spawnPillarPos;
    private BlockState spawnPillarBlock;
    private EntityPillar pillar;

    public SpawnPillarAbility(AbilityType<Player, ? extends Ability> abilityType, Player user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, 2), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.ACTIVE, MAX_DURATION)});
    }

    @Override
    public void start() {
        super.start();
        this.playAnimation("spawn_boulder_start", false);
    }

    @Override
    public boolean tryAbility() {
        Vec3 to;
        Vec3 from = ((Player)this.getUser()).m_20182_();
        BlockHitResult result = ((Player)this.getUser()).f_19853_.m_45547_(new ClipContext(from, to = from.m_82492_(0.0, (double)MAX_RANGE_TO_GROUND, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.getUser()));
        if (result.m_6662_() != HitResult.Type.MISS) {
            BlockState blockAbove;
            this.spawnPillarPos = result.m_82425_();
            this.spawnPillarBlock = ((Player)this.getUser()).f_19853_.m_8055_(this.spawnPillarPos);
            if (result.m_82434_() != Direction.UP && ((blockAbove = ((Player)this.getUser()).f_19853_.m_8055_(this.spawnPillarPos.m_7494_())).m_60828_((BlockGetter)((Player)this.getUser()).f_19853_, this.spawnPillarPos.m_7494_()) || blockAbove.m_60795_())) {
                return false;
            }
            return EffectGeomancy.isBlockDiggable(this.spawnPillarBlock);
        }
        return false;
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
    }

    @Override
    protected void beginSection(AbilitySection section) {
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            this.spawnPillar();
        }
    }

    private void spawnPillar() {
        this.playAnimation("spawn_boulder_instant", false);
        this.pillar = new EntityPillar((EntityType<? extends EntityPillar>)((EntityType)EntityHandler.PILLAR.get()), ((Player)this.getUser()).f_19853_, (LivingEntity)this.getUser(), this.spawnPillarBlock, this.spawnPillarPos);
        this.pillar.m_6034_((float)this.spawnPillarPos.m_123341_() + 0.5f, this.spawnPillarPos.m_123342_() + 1, (float)this.spawnPillarPos.m_123343_() + 0.5f);
        if (!((Player)this.getUser()).f_19853_.f_46443_ && this.pillar.checkCanSpawn()) {
            ((Player)this.getUser()).f_19853_.m_7967_((Entity)this.pillar);
        }
    }

    @Override
    public void end() {
        super.end();
        if (this.pillar != null) {
            this.pillar.stopRising();
        }
        this.pillar = null;
    }

    @Override
    public boolean canUse() {
        return EffectGeomancy.canUse(this.getUser()) && super.canUse();
    }

    @Override
    public void onJump(LivingEvent.LivingJumpEvent event) {
        super.onJump(event);
    }

    @Override
    public void onSneakUp(Player player) {
        super.onSneakUp(player);
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.ACTIVE && this.isUsing()) {
            if (this.pillar != null) {
                this.pillar.stopRising();
            }
            this.nextSection();
        }
    }
}

