/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.entity.IAnimationTickable;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class MowzieGeckoEntity
extends MowzieEntity
implements IAnimatable,
IAnimationTickable {
    protected AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    protected MowzieAnimationController<MowzieGeckoEntity> controller = new MowzieAnimationController<MowzieGeckoEntity>(this, "controller", 10.0f, this::predicate);

    public MowzieGeckoEntity(EntityType<? extends MowzieEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public int tickTimer() {
        return this.f_19797_;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Override
    protected int getDeathDuration() {
        return 20;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
    }

    protected <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        this.getController().transitionLengthTicks = 0.0;
        AbilityCapability.IAbilityCapability abilityCapability = this.getAbilityCapability();
        if (abilityCapability == null) {
            return PlayState.STOP;
        }
        if (abilityCapability.getActiveAbility() != null) {
            return abilityCapability.animationPredicate(event, null);
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle"));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(this.controller);
    }

    public MowzieAnimationController<MowzieGeckoEntity> getController() {
        return this.controller;
    }

    public AbilityType<?, ?>[] getAbilities() {
        return new AbilityType[0];
    }

    public AbilityCapability.IAbilityCapability getAbilityCapability() {
        return AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)this);
    }

    public Ability getActiveAbility() {
        AbilityCapability.IAbilityCapability capability = this.getAbilityCapability();
        if (capability == null) {
            return null;
        }
        return this.getAbilityCapability().getActiveAbility();
    }

    public Ability getAbility(AbilityType abilityType) {
        AbilityCapability.IAbilityCapability capability = this.getAbilityCapability();
        if (capability == null) {
            return null;
        }
        return this.getAbilityCapability().getAbilityMap().get(abilityType);
    }

    public void sendAbilityMessage(AbilityType abilityType) {
        AbilityHandler.INSTANCE.sendAbilityMessage(this, abilityType);
    }
}

