/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.barakoa;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.advancement.AdvancementHandler;
import com.bobmowzie.mowziesmobs.server.ai.BarakoaHurtByTargetAI;
import com.bobmowzie.mowziesmobs.server.ai.NearestAttackableTargetPredicateGoal;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationDieAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationRadiusAttack;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSolarBeam;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSpawnBarakoa;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationSunStrike;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationTakeDamage;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.MowzieLLibraryEntity;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoa;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaya;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySuperNova;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerBarakoTrade;
import com.bobmowzie.mowziesmobs.server.item.BarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.base.Supplier;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityBarako
extends MowzieLLibraryEntity
implements LeaderSunstrikeImmune,
Enemy {
    public static final Animation DIE_ANIMATION = Animation.create(130);
    public static final Animation HURT_ANIMATION = Animation.create(13);
    public static final Animation BELLY_ANIMATION = Animation.create(40);
    public static final Animation TALK_ANIMATION = Animation.create(80);
    public static final Animation SUNSTRIKE_ANIMATION = Animation.create(15);
    public static final Animation ATTACK_ANIMATION = Animation.create(30);
    public static final Animation SPAWN_ANIMATION = Animation.create(17);
    public static final Animation SPAWN_SUNBLOCKERS_ANIMATION = Animation.create(17);
    public static final Animation SOLAR_BEAM_ANIMATION = Animation.create(100);
    public static final Animation BLESS_ANIMATION = Animation.create(60);
    public static final Animation SUPERNOVA_ANIMATION = Animation.create(100);
    private static final int MAX_HEALTH = 150;
    private static final int SUNSTRIKE_PAUSE_MAX = 50;
    private static final int SUNSTRIKE_PAUSE_MIN = 30;
    private static final int LASER_PAUSE = 230;
    private static final int SUPERNOVA_PAUSE = 230;
    private static final int BARAKOA_PAUSE = 200;
    private static final int HEAL_PAUSE = 75;
    private static final int HEALTH_LOST_BETWEEN_SUNBLOCKERS = 45;
    private static final EntityDataAccessor<Integer> DIRECTION = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DIALOGUE = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> ANGRY = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> DESIRES = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<CompoundTag> TRADED_PLAYERS = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Float> HEALTH_LOST = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> MISBEHAVED_PLAYER = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> IS_TRADING = SynchedEntityData.m_135353_(EntityBarako.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ControlledAnimation legsUp = new ControlledAnimation(15);
    public ControlledAnimation angryEyebrow = new ControlledAnimation(5);
    private Player customer;
    public int barakoaSpawnCount = 0;
    private int direction = 0;
    private boolean blocksByFeet = true;
    private int timeUntilSunstrike = 0;
    private int timeUntilLaser = 0;
    private int timeUntilBarakoa = 0;
    private int timeUntilSupernova = 0;
    private int timeUntilHeal = 0;
    public Player blessingPlayer;
    private BarakoaHurtByTargetAI hurtByTargetAI;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] betweenHandPos;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] blessingPlayerPos;
    private static final TargetingConditions GIVE_ACHIEVEMENT_PRED = TargetingConditions.m_148352_().m_26893_();
    private static ParticleComponent.KeyTrack superNovaKeyTrack1 = new ParticleComponent.KeyTrack(new float[]{0.0f, 20.0f, 20.0f, 0.0f}, new float[]{0.0f, 0.5f, 0.9f, 1.0f});
    private static ParticleComponent.KeyTrack superNovaKeyTrack2 = ParticleComponent.KeyTrack.oscillate(0.0f, 1.0f, 30);

    public EntityBarako(EntityType<? extends EntityBarako> type, Level world) {
        super(type, world);
        if (this.getDirectionData() == 0) {
            this.setDirection(this.f_19796_.nextInt(4) + 1);
        }
        this.f_21364_ = 45;
        if (world.f_46443_) {
            this.betweenHandPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
            this.blessingPlayerPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.hurtByTargetAI = new BarakoaHurtByTargetAI(this, new Class[0]);
        this.f_21346_.m_25352_(3, (Goal)this.hurtByTargetAI);
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetPredicateGoal<Player>((Mob)this, Player.class, 0, false, true, TargetingConditions.m_148352_().m_26883_(this.m_21133_(Attributes.f_22277_)).m_26888_(target -> {
            if (target instanceof Player) {
                if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                ItemStack headArmorStack = (ItemStack)((Player)target).m_150109_().f_35975_.get(3);
                return !(headArmorStack.m_41720_() instanceof BarakoaMask) || target == this.getMisbehavedPlayer();
            }
            return true;
        }).m_148355_()){

            public void m_8041_() {
                super.m_8041_();
                EntityBarako.this.setMisbehavedPlayerId(null);
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 0, false, false, null));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 0, false, false, e -> !(e instanceof ZombifiedPiglin)));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, 0, false, false, null));
        this.f_21345_.m_25352_(6, new SimpleAnimationAI<EntityBarako>(this, BELLY_ANIMATION, false, true));
        this.f_21345_.m_25352_(6, (Goal)new SimpleAnimationAI<EntityBarako>(this, TALK_ANIMATION, false, true){

            @Override
            public void m_8056_() {
                super.m_8056_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new SimpleAnimationAI<EntityBarako>(this, BLESS_ANIMATION, false){

            @Override
            public void m_8056_() {
                super.m_8056_();
                EntityBarako.this.blessingPlayer = EntityBarako.this.getCustomer();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new SimpleAnimationAI<EntityBarako>(this, SUPERNOVA_ANIMATION, false){

            @Override
            public void m_8056_() {
                super.m_8056_();
                EntityBarako.this.m_5496_((SoundEvent)MMSounds.ENTITY_SUPERNOVA_START.get(), 3.0f, 1.0f);
            }

            public void m_8037_() {
                super.m_8037_();
                if (((EntityBarako)this.entity).getAnimationTick() == 30) {
                    EntityBarako.this.m_5496_((SoundEvent)MMSounds.ENTITY_SUPERNOVA_BLACKHOLE.get(), 2.0f, 1.2f);
                }
                if (((EntityBarako)this.entity).getAnimationTick() == 40) {
                    EntityBarako.this.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKO_SCREAM.get(), 1.5f, 1.0f);
                }
                if (!((EntityBarako)this.entity).f_19853_.f_46443_ && ((EntityBarako)this.entity).getAnimationTick() == 44) {
                    Vec3 offset = new Vec3((double)1.1f, 0.0, 0.0);
                    offset = offset.m_82524_((float)Math.toRadians(-((EntityBarako)this.entity).m_146908_() - 90.0f));
                    EntitySuperNova superNova = new EntitySuperNova((EntityType<? extends EntitySuperNova>)((EntityType)EntityHandler.SUPER_NOVA.get()), ((EntityBarako)this.entity).f_19853_, (LivingEntity)this.entity, ((EntityBarako)this.entity).m_20185_() + offset.f_82479_, ((EntityBarako)this.entity).m_20186_() + 0.05, ((EntityBarako)this.entity).m_20189_() + offset.f_82481_);
                    EntityBarako.this.f_19853_.m_7967_((Entity)superNova);
                }
            }
        });
        this.f_21345_.m_25352_(2, new AnimationSunStrike<EntityBarako>(this, SUNSTRIKE_ANIMATION));
        this.f_21345_.m_25352_(2, (Goal)new AnimationRadiusAttack<EntityBarako>(this, ATTACK_ANIMATION, 4.0f, 1.0f, 3.0f, 12, true){

            @Override
            public void m_8056_() {
                super.m_8056_();
                EntityBarako.this.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKO_BURST.get(), 1.7f, 1.5f);
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new AnimationSpawnBarakoa(this, SPAWN_ANIMATION, false));
        this.f_21345_.m_25352_(2, (Goal)new AnimationSpawnBarakoa(this, SPAWN_SUNBLOCKERS_ANIMATION, true));
        this.f_21345_.m_25352_(2, new AnimationSolarBeam<EntityBarako>(this, SOLAR_BEAM_ANIMATION));
        this.f_21345_.m_25352_(3, new AnimationTakeDamage<EntityBarako>(this));
        this.f_21345_.m_25352_(1, new AnimationDieAI<EntityBarako>(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, EntityBarakoa.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.4f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return MowzieEntity.createAttributes().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 40.0);
    }

    protected boolean isMovementNoisy() {
        return false;
    }

    public boolean m_8023_() {
        return true;
    }

    protected SoundEvent m_7515_() {
        if (this.getAnimation() == NO_ANIMATION) {
            if (this.m_5448_() == null && !this.m_21525_()) {
                int soundType = Mth.m_14072_((Random)this.f_19796_, (int)0, (int)9);
                if (soundType < MMSounds.ENTITY_BARAKO_TALK.size()) {
                    this.m_5496_((SoundEvent)((Supplier)MMSounds.ENTITY_BARAKO_TALK.get(soundType)).get(), 2.0f, 1.0f);
                    this.setWhichDialogue(soundType + 1);
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, TALK_ANIMATION);
                }
            } else {
                int soundType = Mth.m_14072_((Random)this.f_19796_, (int)1, (int)10);
                if (soundType < 7) {
                    this.m_5496_((SoundEvent)((Supplier)MMSounds.ENTITY_BARAKO_ANGRY.get(soundType - 1)).get(), 2.0f, 1.0f);
                }
            }
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)MMSounds.ENTITY_BARAKO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        this.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKO_DIE.get(), 2.0f, 1.0f);
        return null;
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    public void m_8119_() {
        double oz;
        double oy;
        double ox;
        this.legsUp.updatePrevTimer();
        this.angryEyebrow.updatePrevTimer();
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.direction = this.getDirectionData();
        }
        if (this.getAnimation() != ATTACK_ANIMATION || this.getAnimationTick() < 12 || this.getAnimationTick() > 14) {
            this.repelEntities(1.2f, 1.2f, 1.2f, 1.2f);
        }
        this.m_146922_((this.direction - 1) * 90);
        this.f_20883_ = this.m_146908_();
        if (!this.f_19853_.f_46443_ && this.getHealthLost() >= 45.0f && this.getAnimation() == NO_ANIMATION && !this.m_21525_() && this.getEntitiesNearby(EntityBarakoaya.class, 40.0).size() < 3) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, SPAWN_SUNBLOCKERS_ANIMATION);
            this.setHealthLost(0.0f);
        }
        if (this.m_5448_() != null) {
            boolean targetComingCloser;
            LivingEntity target = this.m_5448_();
            this.setAngry(true);
            float entityHitAngle = (float)((Math.atan2(target.m_20189_() - this.m_20189_(), target.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.m_146908_() % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = Math.abs(entityHitAngle - entityAttackingAngle);
            Vec3 betweenEntitiesVec = this.m_20182_().m_82546_(target.m_20182_());
            boolean bl = targetComingCloser = target.m_20184_().m_82526_(betweenEntitiesVec) > 0.0 && target.m_20184_().m_82556_() > 0.015;
            if (this.getAnimation() == NO_ANIMATION && !this.m_21525_() && this.f_19796_.nextInt(80) == 0 && ((double)this.targetDistance > 5.5 || this.m_21023_(EffectHandler.SUNBLOCK)) && this.timeUntilBarakoa <= 0 && this.getEntitiesNearby(EntityBarakoa.class, 50.0).size() < 4) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SPAWN_ANIMATION);
                this.timeUntilBarakoa = 200;
            } else if (this.getAnimation() == NO_ANIMATION && !this.m_21525_() && (double)this.getHealthRatio() <= 0.6 && this.timeUntilLaser <= 0 && (entityRelativeAngle < 60.0f || entityRelativeAngle > 300.0f) && this.m_21574_().m_148306_((Entity)target) && (double)this.targetDistance < 30.0) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SOLAR_BEAM_ANIMATION);
                this.timeUntilLaser = 230;
            } else if (this.getAnimation() == NO_ANIMATION && !this.m_21525_() && (double)this.getHealthRatio() <= 0.6 && !this.m_21023_(EffectHandler.SUNBLOCK) && this.timeUntilSupernova <= 0 && (double)this.targetDistance <= 10.5) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SUPERNOVA_ANIMATION);
                this.timeUntilSupernova = 230;
            } else if (this.getAnimation() == NO_ANIMATION && !this.m_21525_() && (this.targetDistance <= 6.0f && targetComingCloser || this.targetDistance < 4.0f)) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, ATTACK_ANIMATION);
            } else if (this.getAnimation() == NO_ANIMATION && !this.m_21525_() && this.timeUntilSunstrike <= 0) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, SUNSTRIKE_ANIMATION);
                this.timeUntilSunstrike = this.getTimeUntilSunstrike();
            }
            if (this.hurtByTargetAI != null && !this.hurtByTargetAI.m_8045_()) {
                this.hurtByTargetAI.m_8041_();
            }
        } else if (!this.f_19853_.f_46443_) {
            this.setAngry(false);
        }
        if (this.f_19797_ % 20 == 0) {
            this.blocksByFeet = this.checkBlocksByFeet();
        }
        if (this.blocksByFeet) {
            this.legsUp.increaseTimer();
        } else {
            this.legsUp.decreaseTimer();
        }
        if (this.getAngry()) {
            this.angryEyebrow.increaseTimer();
        } else {
            this.angryEyebrow.decreaseTimer();
        }
        if (this.getAnimation() == NO_ANIMATION && !this.m_21525_() && this.m_5448_() == null && this.f_19796_.nextInt(200) == 0) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, BELLY_ANIMATION);
        }
        if (this.getAnimation() == BELLY_ANIMATION && (this.getAnimationTick() == 9 || this.getAnimationTick() == 29)) {
            this.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKO_BELLY.get(), 3.0f, 1.0f);
        }
        if (this.getAnimation() == ATTACK_ANIMATION) {
            this.f_20885_ = this.m_146908_();
            if (this.getAnimationTick() == 10) {
                if (this.f_19853_.f_46443_) {
                    this.spawnExplosionParticles(30);
                }
                this.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKO_ATTACK.get(), 1.7f, 0.9f);
            }
            if (this.getAnimationTick() <= 6 && this.f_19853_.f_46443_) {
                int particleCount = 8;
                while (--particleCount != 0) {
                    double radius = 2.0;
                    double yaw = (double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI;
                    double pitch = (double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI;
                    ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    oy = radius * Math.cos(pitch);
                    oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    float offsetX = (float)(-0.3 * Math.sin((double)this.m_146908_() * Math.PI / 180.0));
                    float offsetZ = (float)(-0.3 * Math.cos((double)this.m_146908_() * Math.PI / 180.0));
                    float offsetY = 1.0f;
                    this.f_19853_.m_7106_((ParticleOptions)new ParticleOrb.OrbData((float)this.m_20185_() + offsetX, (float)this.m_20186_() + offsetY, (float)this.m_20189_() + offsetZ, 6.0f), this.m_20185_() + ox + (double)offsetX, this.m_20186_() + (double)offsetY + oy, this.m_20189_() + oz + (double)offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.getAnimation() == BLESS_ANIMATION) {
            this.f_20885_ = this.m_146908_();
            if (this.getAnimationTick() == 1) {
                this.blessingPlayer = this.getCustomer();
            }
            if (this.f_19853_.f_46443_ && this.blessingPlayer != null) {
                this.blessingPlayerPos[0] = this.blessingPlayer.m_20182_().m_82549_(new Vec3(0.0, (double)(this.blessingPlayer.m_20206_() / 2.0f), 0.0));
                if (this.getAnimationTick() > 5 && this.getAnimationTick() < 40) {
                    int particleCount = 2;
                    while (--particleCount != 0) {
                        double radius = 0.7f;
                        double yaw = (double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI;
                        double pitch = (double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI;
                        ox = radius * Math.sin(yaw) * Math.sin(pitch);
                        oy = radius * Math.cos(pitch);
                        oz = radius * Math.cos(yaw) * Math.sin(pitch);
                        AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.ORB2.get()), this.m_20185_() + ox, this.m_20186_() + (double)0.8f + oy, this.m_20189_() + oz, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 20.0, true, true, new ParticleComponent[]{new ParticleComponent.Attractor(this.blessingPlayerPos, 0.5f, 0.2f, ParticleComponent.Attractor.EnumAttractorBehavior.LINEAR), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, new ParticleComponent.Oscillator(0.0f, (float)ox, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, new ParticleComponent.Oscillator(0.0f, (float)oy, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, new ParticleComponent.Oscillator(0.0f, (float)oz, 6.0f, 2.5f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f}, new float[]{0.0f, 0.8f}), false)});
                    }
                }
                if (this.getAnimationTick() % 15 == 0) {
                    AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), this.m_20185_(), this.m_20186_() + (double)0.8f, this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 1.0, 0.8745098114013672, 0.25882354378700256, 1.0, 1.0, 15.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(5.0f, 35.0f), false)});
                }
            }
        }
        if (this.getAnimation() == SUPERNOVA_ANIMATION) {
            if (this.f_19853_.f_46443_ && this.betweenHandPos.length > 0) {
                this.superNovaEffects();
            }
            if (this.getAnimationTick() < 30) {
                List<LivingEntity> entities = this.getEntityLivingBaseNearby(16.0, 16.0, 16.0, 16.0);
                for (LivingEntity inRange : entities) {
                    if (inRange instanceof LeaderSunstrikeImmune || inRange instanceof Player && ((Player)inRange).m_150110_().f_35934_) continue;
                    Vec3 diff = inRange.m_20182_().m_82546_(this.m_20182_().m_82520_(0.0, 3.0, 0.0));
                    diff = diff.m_82541_().m_82490_(0.03);
                    inRange.m_20256_(inRange.m_20184_().m_82546_(diff));
                    if (!(inRange.m_20186_() < this.m_20186_() + 3.0)) continue;
                    inRange.m_20256_(inRange.m_20184_().m_82520_(0.0, 0.075, 0.0));
                }
            }
        }
        if (this.f_19797_ % 40 == 0) {
            for (Player player : this.getPlayersNearby(15.0, 15.0, 15.0, 15.0)) {
                ItemStack headArmorStack = (ItemStack)player.m_150109_().f_35975_.get(3);
                if (this.m_5448_() == player || !this.m_21040_((LivingEntity)player, GIVE_ACHIEVEMENT_PRED) || !(headArmorStack.m_41720_() instanceof BarakoaMask) || !(player instanceof ServerPlayer)) continue;
                AdvancementHandler.SNEAK_VILLAGE_TRIGGER.trigger((ServerPlayer)player);
            }
        }
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null && this.getAnimation() != SOLAR_BEAM_ANIMATION && this.getAnimation() != SUPERNOVA_ANIMATION) {
            --this.timeUntilHeal;
            if (((Boolean)ConfigHandler.COMMON.MOBS.BARAKO.healsOutOfBattle.get()).booleanValue() && this.timeUntilHeal <= 0) {
                this.m_5634_(0.3f);
            }
            if (this.m_21223_() == this.m_21233_()) {
                this.setHealthLost(0.0f);
            }
        } else {
            this.timeUntilHeal = 75;
        }
        if (this.timeUntilSunstrike > 0) {
            --this.timeUntilSunstrike;
        }
        if (this.timeUntilLaser > 0 && this.getAnimation() != SUPERNOVA_ANIMATION) {
            --this.timeUntilLaser;
        }
        if (this.timeUntilBarakoa > 0) {
            --this.timeUntilBarakoa;
        }
        if (this.timeUntilSupernova > 0 && this.getAnimation() != SOLAR_BEAM_ANIMATION) {
            --this.timeUntilSupernova;
        }
    }

    private void superNovaEffects() {
        double value;
        int i;
        if (this.getAnimationTick() == 1) {
            superNovaKeyTrack1 = new ParticleComponent.KeyTrack(new float[]{0.0f, 25.0f, 32.0f, 0.0f}, new float[]{0.0f, 0.6f, 0.85f, 1.0f});
            superNovaKeyTrack2 = ParticleComponent.KeyTrack.oscillate(0.0f, 7.0f, 24);
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.SUN.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 33.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack1, false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, superNovaKeyTrack2, true)});
        }
        if (this.getAnimationTick() == 33) {
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.SUN_NOVA.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 20.0, 1.0, 1.0, 1.0, 0.0, 1.0, 13.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{11.0f, 7.0f, 5.5f, 1.0f, 30.0f}, new float[]{0.0f, 0.15f, 0.8f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 1.0f, 1.0f, 0.0f}, new float[]{0.0f, 0.15f, 0.89f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.PARTICLE_ANGLE, ParticleComponent.KeyTrack.startAndEnd(0.0f, -6.0f), false)});
        }
        if (this.getAnimationTick() == 32) {
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.FLARE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 0.7, 1.0, 3.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.15f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 22.0f, 0.0f}, new float[]{0.0f, 0.2f, 1.0f}), false)});
        }
        if (this.getAnimationTick() > 30 && this.getAnimationTick() < 41) {
            for (i = 0; i < 6; ++i) {
                float phaseOffset = this.f_19796_.nextFloat();
                value = this.f_19796_.nextDouble() * 0.3 + 0.05;
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), this.betweenHandPos[0].f_82479_, this.betweenHandPos[0].f_82480_, this.betweenHandPos[0].f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 6.0, false, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.0f}, new float[]{0.0f, 0.2f}), false), new ParticleComponent.Orbit(this.betweenHandPos, ParticleComponent.KeyTrack.startAndEnd(0.0f + phaseOffset, -0.4f + phaseOffset), ParticleComponent.KeyTrack.startAndEnd(0.5f + this.f_19796_.nextFloat(), 0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), ParticleComponent.constant(0.0f), true)});
            }
        }
        if (this.getAnimationTick() > 1 && this.getAnimationTick() < 27) {
            for (i = 0; i < 6; ++i) {
                Vec3 particlePos = new Vec3((double)(this.f_19796_.nextFloat() * 5.0f), 0.0, 0.0);
                particlePos = particlePos.m_82524_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82496_((float)((double)(this.f_19796_.nextFloat() * 2.0f) * Math.PI));
                particlePos = particlePos.m_82549_(this.betweenHandPos[0]);
                value = this.f_19796_.nextDouble() * 0.5 + 0.1;
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.PIXEL.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, value, value, value, 1.0, 1.0, 7.0, false, true, new ParticleComponent[]{new ParticleComponent.Attractor(this.betweenHandPos, 1.1f, 1.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 3.5f}, new float[]{0.0f, 0.2f}), false)});
            }
        }
        float timeFrac = Math.min((float)this.getAnimationTick() / 20.0f, 1.0f);
        if (this.getAnimationTick() > 1 && this.getAnimationTick() < 25 && this.getAnimationTick() % (int)(4.0f * (1.0f - timeFrac) + 1.0f) == 0) {
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_SPARKS.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, this.f_19796_.nextFloat() * (float)Math.PI * 2.0f, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 6.0f + this.f_19796_.nextFloat() * 3.0f, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(10.0f + 20.0f * timeFrac * timeFrac + 10.0f * this.f_19796_.nextFloat() * timeFrac, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 0.7f), false)});
        }
        if (this.getAnimationTick() == 14) {
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.FLARE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 18.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, ParticleComponent.constant(-0.1f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f, 35.0f, 0.0f}, new float[]{0.0f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-5.0f, 5.0f, 42.0f, 0.0f), true)});
        }
        if (this.getAnimationTick() == 32) {
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.BURST_IN.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.betweenHandPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(25.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 1.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.Oscillator(-2.0f, 2.0f, 42.0f, 0.0f), true)});
        }
        if (this.getAnimationTick() == 44) {
            float scale = 85.0f;
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING_BIG.get()), this.betweenHandPos[0].f_82479_, this.betweenHandPos[0].f_82480_, this.betweenHandPos[0].f_82481_, 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 40.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, 1.0f * scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
            scale = 120.0f;
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.GLOW.get()), this.betweenHandPos[0].f_82479_, this.betweenHandPos[0].f_82480_, this.betweenHandPos[0].f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 0.95, 0.9, 0.35, 1.0, 1.0, 40.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{0.0f * scale, 0.59f * scale, 0.87f * scale, 0.974f * scale, 0.998f * scale, 1.0f * scale}, new float[]{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(1.0f, 0.0f), false)});
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_21023_(EffectHandler.SUNBLOCK) && !source.m_19378_()) {
            if (source.m_7640_() != null) {
                this.m_5496_((SoundEvent)MMSounds.ENTITY_WROUGHT_UNDAMAGED.get(), 0.4f, 2.0f);
            }
            return false;
        }
        this.timeUntilHeal = 75;
        float prevHealth = this.m_21223_();
        boolean superResult = super.m_6469_(source, damage);
        if (superResult) {
            float diffHealth = prevHealth - this.m_21223_();
            this.setHealthLost(this.getHealthLost() + diffHealth);
        }
        return superResult;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    private boolean checkBlocksByFeet() {
        BlockState blockRight;
        BlockState blockLeft;
        if (this.direction == 1) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            blockLeft = this.f_19853_.m_8055_(posLeft);
            blockRight = this.f_19853_.m_8055_(posRight);
        } else if (this.direction == 2) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            blockLeft = this.f_19853_.m_8055_(posLeft);
            blockRight = this.f_19853_.m_8055_(posRight);
        } else if (this.direction == 3) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) - 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            blockLeft = this.f_19853_.m_8055_(posLeft);
            blockRight = this.f_19853_.m_8055_(posRight);
        } else if (this.direction == 4) {
            BlockPos posLeft = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) - 1);
            BlockPos posRight = new BlockPos(Mth.m_14107_((double)this.m_20185_()) + 1, Math.round((float)(this.m_20186_() - 1.0)), Mth.m_14107_((double)this.m_20189_()) + 1);
            blockLeft = this.f_19853_.m_8055_(posLeft);
            blockRight = this.f_19853_.m_8055_(posRight);
        } else {
            return false;
        }
        return blockLeft.m_60767_().m_76334_() || blockRight.m_60767_().m_76334_();
    }

    private void spawnExplosionParticles(int amount) {
        for (int i = 0; i < amount; ++i) {
            float velocity = 0.25f;
            float yaw = (float)i * ((float)Math.PI * 2 / (float)amount);
            float vy = this.f_19796_.nextFloat() * 0.1f - 0.05f;
            float vx = 0.25f * Mth.m_14089_((float)yaw);
            float vz = 0.25f * Mth.m_14031_((float)yaw);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), (double)vx, (double)vy, (double)vz);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DIRECTION, (Object)0);
        this.m_20088_().m_135372_(DIALOGUE, (Object)0);
        this.m_20088_().m_135372_(ANGRY, (Object)false);
        Item tradeItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)ConfigHandler.COMMON.MOBS.BARAKO.whichItem.get()));
        this.m_20088_().m_135372_(DESIRES, (Object)new ItemStack((ItemLike)tradeItem, ((Integer)ConfigHandler.COMMON.MOBS.BARAKO.howMany.get()).intValue()));
        this.m_20088_().m_135372_(TRADED_PLAYERS, (Object)new CompoundTag());
        this.m_20088_().m_135372_(HEALTH_LOST, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(MISBEHAVED_PLAYER, Optional.empty());
        this.m_20088_().m_135372_(IS_TRADING, (Object)false);
    }

    public int getDirectionData() {
        return (Integer)this.m_20088_().m_135370_(DIRECTION);
    }

    public void setDirection(int direction) {
        this.m_20088_().m_135381_(DIRECTION, (Object)direction);
    }

    public int getWhichDialogue() {
        return (Integer)this.m_20088_().m_135370_(DIALOGUE);
    }

    public void setWhichDialogue(int dialogue) {
        this.m_20088_().m_135381_(DIALOGUE, (Object)dialogue);
    }

    public boolean getAngry() {
        return (Boolean)this.m_20088_().m_135370_(ANGRY);
    }

    public void setAngry(boolean angry) {
        this.m_20088_().m_135381_(ANGRY, (Object)angry);
    }

    public void setDesires(ItemStack stack) {
        this.m_20088_().m_135381_(DESIRES, (Object)stack);
    }

    public ItemStack getDesires() {
        return (ItemStack)this.m_20088_().m_135370_(DESIRES);
    }

    public void setTradedPlayersCompound(ListTag players) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("players", (Tag)players);
        this.m_20088_().m_135381_(TRADED_PLAYERS, (Object)compound);
    }

    public Set<UUID> getTradedPlayers() {
        HashSet<UUID> tradedPlayers = new HashSet<UUID>();
        CompoundTag compound = (CompoundTag)this.m_20088_().m_135370_(TRADED_PLAYERS);
        ListTag players = compound.m_128437_("players", 11);
        for (Tag player : players) {
            tradedPlayers.add(NbtUtils.m_129233_((Tag)player));
        }
        return tradedPlayers;
    }

    public float getHealthLost() {
        return ((Float)this.m_20088_().m_135370_(HEALTH_LOST)).floatValue();
    }

    public void setHealthLost(float amount) {
        this.m_20088_().m_135381_(HEALTH_LOST, (Object)Float.valueOf(amount));
    }

    public boolean doesItemSatisfyDesire(ItemStack stack) {
        return EntityBarako.canPayFor(stack, this.getDesires());
    }

    public boolean fulfillDesire(Slot input) {
        ItemStack desires = this.getDesires();
        if (EntityBarako.canPayFor(input.m_7993_(), desires)) {
            input.m_6201_(desires.m_41613_());
            return true;
        }
        return false;
    }

    public boolean hasTradedWith(Player player) {
        return this.getTradedPlayers().contains(Player.m_36198_((GameProfile)player.m_36316_()));
    }

    public void rememberTrade(Player player) {
        UUID uuid = Player.m_36198_((GameProfile)player.m_36316_());
        CompoundTag compound = (CompoundTag)this.m_20088_().m_135370_(TRADED_PLAYERS);
        ListTag players = compound.m_128437_("players", 11);
        players.add((Object)NbtUtils.m_129226_((UUID)uuid));
        compound.m_128365_("players", (Tag)players);
        this.m_20088_().m_135381_(TRADED_PLAYERS, (Object)compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("direction", this.getDirectionData());
        CompoundTag compoundTradedPlayers = (CompoundTag)this.m_20088_().m_135370_(TRADED_PLAYERS);
        ListTag players = compoundTradedPlayers.m_128437_("players", 11);
        compound.m_128365_("players", (Tag)players);
        compound.m_128405_("HomePosX", this.m_21534_().m_123341_());
        compound.m_128405_("HomePosY", this.m_21534_().m_123342_());
        compound.m_128405_("HomePosZ", this.m_21534_().m_123343_());
        compound.m_128350_("healthLost", this.getHealthLost());
        if (this.getMisbehavedPlayerId() != null) {
            compound.m_128362_("MisbehavedPlayer", this.getMisbehavedPlayerId());
        }
    }

    public void m_7378_(CompoundTag compound) {
        UUID uuid;
        super.m_7378_(compound);
        this.setDirection(compound.m_128451_("direction"));
        ListTag players = compound.m_128437_("players", 11);
        this.setTradedPlayersCompound(players);
        int i = compound.m_128451_("HomePosX");
        int j = compound.m_128451_("HomePosY");
        int k = compound.m_128451_("HomePosZ");
        this.m_21446_(new BlockPos(i, j, k), -1);
        this.setHealthLost(compound.m_128451_("healthLost"));
        if (compound.m_128403_("MisbehavedPlayer")) {
            uuid = compound.m_128342_("MisbehavedPlayer");
        } else {
            String s = compound.m_128461_("MisbehavedPlayer");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setMisbehavedPlayerId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getMisbehavedPlayerId() {
        return ((Optional)this.f_19804_.m_135370_(MISBEHAVED_PLAYER)).orElse(null);
    }

    public void setMisbehavedPlayerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(MISBEHAVED_PLAYER, Optional.ofNullable(p_184754_1_));
    }

    @Nullable
    public LivingEntity getMisbehavedPlayer() {
        try {
            UUID uuid = this.getMisbehavedPlayerId();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
    }

    private int getTimeUntilSunstrike() {
        float damageRatio = 1.0f - this.getHealthRatio();
        if ((double)damageRatio > 0.6) {
            damageRatio = 0.6f;
        }
        return (int)(50.0f - damageRatio / 0.6f * 20.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{DIE_ANIMATION, HURT_ANIMATION, BELLY_ANIMATION, TALK_ANIMATION, SUNSTRIKE_ANIMATION, ATTACK_ANIMATION, SPAWN_ANIMATION, SPAWN_SUNBLOCKERS_ANIMATION, SOLAR_BEAM_ANIMATION, BLESS_ANIMATION, SUPERNOVA_ANIMATION};
    }

    @Override
    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        List<EntityBarakoa> barakoa = this.getEntitiesNearby(EntityBarakoa.class, 30.0, 20.0, 30.0, 30.0);
        for (EntityBarakoa entityBarakoa : barakoa) {
            if (!entityBarakoa.isBarakoDevoted()) continue;
            if (entityBarakoa instanceof EntityBarakoaya) {
                ((EntityBarakoaya)entityBarakoa).hasTriedOrSucceededTeleport = true;
            }
            entityBarakoa.timeUntilDeath = this.f_19796_.nextInt(20);
        }
        super.m_6667_(cause);
    }

    public void setTrading(boolean trading) {
        this.f_19804_.m_135381_(IS_TRADING, (Object)trading);
    }

    public boolean isTrading() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRADING);
    }

    public Player getCustomer() {
        return this.customer;
    }

    public void setCustomer(Player customer) {
        this.setTrading(customer != null);
        this.customer = customer;
    }

    public void openGUI(Player playerEntity) {
        this.setCustomer(playerEntity);
        MowziesMobs.PROXY.setReferencedMob((Entity)this);
        if (!this.f_19853_.f_46443_ && this.m_5448_() == null && this.m_6084_()) {
            playerEntity.m_5893_(new MenuProvider(){

                public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                    return new ContainerBarakoTrade(id, EntityBarako.this, playerInventory);
                }

                public Component m_5446_() {
                    return EntityBarako.this.m_5446_();
                }
            });
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.canTradeWith(player) && this.m_5448_() == null && this.m_6084_()) {
            this.openGUI(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canTradeWith(Player player) {
        if (this.isTrading() || this.m_21223_() <= 0.0f) {
            return false;
        }
        ItemStack headStack = (ItemStack)player.m_150109_().f_35975_.get(3);
        return headStack.m_41720_() instanceof BarakoaMask;
    }

    private static boolean canPayFor(ItemStack stack, ItemStack worth) {
        return stack.m_41720_() == worth.m_41720_() && stack.m_41613_() >= worth.m_41613_();
    }

    @Override
    protected boolean hasBossBar() {
        return (Boolean)ConfigHandler.COMMON.MOBS.BARAKO.hasBossBar.get();
    }

    @Override
    protected BossEvent.BossBarColor bossBarColor() {
        return BossEvent.BossBarColor.YELLOW;
    }

    protected ResourceLocation m_7582_() {
        return LootTableHandler.BARAKO;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.BARAKO.combatConfig;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingData, CompoundTag compound) {
        List<Player> players;
        if (reason == MobSpawnType.SPAWN_EGG && !(players = this.getPlayersNearby(5.0, 5.0, 5.0, 5.0)).isEmpty()) {
            Player closestPlayer = players.get(0);
            float closestPlayerDist = 6.0f;
            for (Player player : players) {
                float thisDist;
                if (player.m_21205_().m_41720_() != ItemHandler.BARAKO_SPAWN_EGG && player.m_21205_().m_41720_() != ItemHandler.BARAKO_SPAWN_EGG || !((thisDist = this.m_20270_((Entity)player)) < closestPlayerDist)) continue;
                closestPlayer = player;
                closestPlayerDist = thisDist;
            }
            float angle = (float)this.getAngleBetweenEntities((Entity)this, (Entity)closestPlayer) + 225.0f;
            int direction = (int)(angle / 90.0f) % 4 + 1;
            this.setDirection(direction);
        }
        if (reason != MobSpawnType.STRUCTURE) {
            this.m_21446_(this.m_142538_(), -1);
        }
        return super.m_6518_(world, difficulty, reason, livingData, compound);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_5997_(double x, double y, double z) {
        super.m_5997_(0.0, y, 0.0);
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)MMSounds.MUSIC_BARAKO_THEME.get();
    }
}

