/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class EntityBlockSwapper
extends Entity {
    private static final EntityDataAccessor<Optional<BlockState>> ORIG_BLOCK_STATE = SynchedEntityData.m_135353_(EntityBlockSwapper.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private static final EntityDataAccessor<Integer> RESTORE_TIME = SynchedEntityData.m_135353_(EntityBlockSwapper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockPos> POS = SynchedEntityData.m_135353_(EntityBlockSwapper.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private int duration;
    private final boolean breakParticlesEnd;
    private BlockPos pos;

    public EntityBlockSwapper(EntityType<? extends EntityBlockSwapper> type, Level world) {
        super(type, world);
        this.breakParticlesEnd = false;
    }

    public EntityBlockSwapper(EntityType<? extends EntityBlockSwapper> type, Level world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        super(type, world);
        List swappers;
        this.setStorePos(pos);
        this.setRestoreTime(duration);
        this.breakParticlesEnd = breakParticlesEnd;
        this.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        if (!world.f_46443_) {
            this.setOrigBlock(world.m_8055_(pos));
            if (breakParticlesStart) {
                world.m_46961_(pos, false);
            }
            world.m_7731_(pos, newBlock, 19);
        }
        if (!(swappers = world.m_45976_(EntityBlockSwapper.class, this.m_142469_())).isEmpty()) {
            EntityBlockSwapper swapper = (EntityBlockSwapper)((Object)swappers.get(0));
            this.setOrigBlock(swapper.getOrigBlock());
            swapper.m_146870_();
        }
    }

    public static void swapBlock(Level world, BlockPos pos, BlockState newBlock, int duration, boolean breakParticlesStart, boolean breakParticlesEnd) {
        if (!world.f_46443_) {
            EntityBlockSwapper swapper = new EntityBlockSwapper((EntityType<? extends EntityBlockSwapper>)((EntityType)EntityHandler.BLOCK_SWAPPER.get()), world, pos, newBlock, duration, breakParticlesStart, breakParticlesEnd);
            world.m_7967_((Entity)swapper);
        }
    }

    public boolean m_6000_(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return false;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ORIG_BLOCK_STATE, Optional.of(Blocks.f_50493_.m_49966_()));
        this.m_20088_().m_135372_(RESTORE_TIME, (Object)20);
        this.m_20088_().m_135372_(POS, (Object)new BlockPos(0, 0, 0));
    }

    public int getRestoreTime() {
        return (Integer)this.f_19804_.m_135370_(RESTORE_TIME);
    }

    public void setRestoreTime(int restoreTime) {
        this.f_19804_.m_135381_(RESTORE_TIME, (Object)restoreTime);
        this.duration = restoreTime;
    }

    public BlockPos getStorePos() {
        return (BlockPos)this.f_19804_.m_135370_(POS);
    }

    public void setStorePos(BlockPos bpos) {
        this.f_19804_.m_135381_(POS, (Object)bpos);
        this.pos = bpos;
    }

    @Nullable
    public BlockState getOrigBlock() {
        Optional opState = (Optional)this.m_20088_().m_135370_(ORIG_BLOCK_STATE);
        return opState.orElse(null);
    }

    public void setOrigBlock(BlockState block) {
        this.m_20088_().m_135381_(ORIG_BLOCK_STATE, Optional.of(block));
    }

    public void restoreBlock() {
        if (!this.f_19853_.f_46443_) {
            if (this.breakParticlesEnd) {
                this.f_19853_.m_46961_(this.pos, false);
            }
            this.f_19853_.m_7731_(this.pos, this.getOrigBlock(), 19);
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > this.duration && this.f_19853_.m_45976_(Player.class, this.m_142469_()).isEmpty()) {
            this.restoreBlock();
        }
    }

    public void m_7380_(CompoundTag compound) {
        Optional blockOption = (Optional)this.m_20088_().m_135370_(ORIG_BLOCK_STATE);
        blockOption.ifPresent(blockState -> compound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)blockState)));
        compound.m_128405_("restoreTime", this.getRestoreTime());
        compound.m_128405_("storePosX", this.getStorePos().m_123341_());
        compound.m_128405_("storePosY", this.getStorePos().m_123342_());
        compound.m_128405_("storePosZ", this.getStorePos().m_123343_());
    }

    public void m_7378_(CompoundTag compound) {
        Tag blockNBT = compound.m_128423_("block");
        if (blockNBT != null) {
            BlockState blockState = NbtUtils.m_129241_((CompoundTag)((CompoundTag)blockNBT));
            this.setOrigBlock(blockState);
        }
        this.setRestoreTime(compound.m_128451_("restoreTime"));
        this.setStorePos(new BlockPos(compound.m_128451_("storePosX"), compound.m_128451_("storePosY"), compound.m_128451_("storePosZ")));
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

