/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class EntityMagicEffect
extends Entity {
    public LivingEntity caster;
    private static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.m_135353_(EntityMagicEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityMagicEffect(EntityType<? extends EntityMagicEffect> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityMagicEffect(EntityType<? extends EntityMagicEffect> type, Level world, LivingEntity caster) {
        super(type, world);
        if (!world.f_46443_ && caster != null) {
            this.setCasterID(caster.m_142049_());
        }
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(CASTER, (Object)-1);
    }

    public int getCasterID() {
        return (Integer)this.m_20088_().m_135370_(CASTER);
    }

    public void setCasterID(int id) {
        this.m_20088_().m_135381_(CASTER, (Object)id);
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_8119_() {
        Entity casterEntity;
        super.m_8119_();
        if (this.f_19797_ == 1 && (casterEntity = this.f_19853_.m_6815_(this.getCasterID())) instanceof LivingEntity) {
            this.caster = (LivingEntity)this.f_19853_.m_6815_(this.getCasterID());
        }
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setCasterID(compound.m_128451_("caster"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("caster", this.getCasterID());
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double radius) {
        return this.getEntitiesNearby(LivingEntity.class, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_142469_().m_82377_(r, r, r), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f));
    }

    public <T extends Entity> List<T> getEntitiesNearbyCube(Class<T> entityClass, double r) {
        return this.f_19853_.m_6443_(entityClass, this.m_142469_().m_82377_(r, r, r), e -> e != this);
    }

    public boolean raytraceCheckEntity(Entity entity) {
        Vec3 from = this.m_20182_();
        int numChecks = 3;
        for (int i = 0; i < numChecks; ++i) {
            float increment = entity.m_20206_() / (float)(numChecks + 1);
            Vec3 to = entity.m_20182_().m_82520_(0.0, (double)(increment * (float)(i + 1)), 0.0);
            BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (result.m_6662_() == HitResult.Type.BLOCK) continue;
            return true;
        }
        return false;
    }
}

