/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerBarakoTrade;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class MessageBarakoTrade {
    private int entityID;

    public MessageBarakoTrade() {
    }

    public MessageBarakoTrade(LivingEntity sender) {
        this.entityID = sender.m_142049_();
    }

    public static void serialize(MessageBarakoTrade message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityID);
    }

    public static MessageBarakoTrade deserialize(FriendlyByteBuf buf) {
        MessageBarakoTrade message = new MessageBarakoTrade();
        message.entityID = buf.m_130242_();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessageBarakoTrade, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageBarakoTrade message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            ServerPlayer player = context.getSender();
            context.enqueueWork(() -> {
                if (player != null) {
                    Entity entity = player.f_19853_.m_6815_(message.entityID);
                    if (!(entity instanceof EntityBarako)) {
                        return;
                    }
                    EntityBarako barako = (EntityBarako)entity;
                    if (barako.getCustomer() != player) {
                        return;
                    }
                    AbstractContainerMenu container = player.f_36096_;
                    if (!(container instanceof ContainerBarakoTrade)) {
                        return;
                    }
                    boolean satisfied = barako.hasTradedWith((Player)player);
                    if (!satisfied && (satisfied = barako.fulfillDesire(container.m_38853_(0)))) {
                        barako.rememberTrade((Player)player);
                        ((ContainerBarakoTrade)container).returnItems();
                        container.m_38946_();
                    }
                    if (satisfied) {
                        player.m_7292_(new MobEffectInstance((MobEffect)EffectHandler.SUNS_BLESSING, (Integer)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.effectDuration.get() * 60 * 20, 0, false, false));
                        if (barako.getAnimation() != EntityBarako.BLESS_ANIMATION) {
                            barako.setAnimationTick(0);
                            AnimationHandler.INSTANCE.sendAnimationMessage(barako, EntityBarako.BLESS_ANIMATION);
                            barako.m_5496_((SoundEvent)MMSounds.ENTITY_BARAKO_BLESS.get(), 2.0f, 1.0f);
                        }
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

