/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoaVillager;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.item.ItemBarakoaMask;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.FeatureHandler;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec2;

public class BarakoaVillagePieces {
    private static final Set<Block> BLOCKS_NEEDING_POSTPROCESSING = ImmutableSet.builder().add((Object)Blocks.f_50198_).add((Object)Blocks.f_50081_).add((Object)Blocks.f_50082_).add((Object)Blocks.f_50132_).add((Object)Blocks.f_50479_).add((Object)Blocks.f_50483_).add((Object)Blocks.f_50482_).add((Object)Blocks.f_50480_).add((Object)Blocks.f_50481_).add((Object)Blocks.f_50155_).add((Object)Blocks.f_50183_).add((Object)Blocks.f_50310_).build();
    public static final ResourceLocation HOUSE = new ResourceLocation("mowziesmobs", "barakoa_house");
    public static final ResourceLocation ROOF = new ResourceLocation("mowziesmobs", "barakoa_house_roof");
    public static final ResourceLocation HOUSE_SIDE = new ResourceLocation("mowziesmobs", "barakoa_house_side");
    public static final ResourceLocation THRONE = new ResourceLocation("mowziesmobs", "barako_throne");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)HOUSE, (Object)new BlockPos(-3, 1, -3), (Object)ROOF, (Object)new BlockPos(-3, 5, -3), (Object)HOUSE_SIDE, (Object)new BlockPos(2, 1, -2), (Object)THRONE, (Object)new BlockPos(-3, 0, 0));

    public static StructurePiece addPiece(ResourceLocation resourceLocation, StructureManager manager, BlockPos pos, Rotation rot, StructurePieceAccessor pieces, WorldgenRandom rand) {
        Piece newPiece = new Piece(manager, resourceLocation, rot, pos);
        pieces.m_142679_((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, StructureManager manager, BlockPos pos, Rotation rot, StructurePieceAccessor pieces, WorldgenRandom rand, List<StructurePiece> ignore) {
        Piece newPiece = new Piece(manager, resourceLocation, rot, pos);
        StructurePiece collisionPiece = pieces.m_141921_(newPiece.m_73547_());
        if (!ignore.contains(collisionPiece)) {
            return null;
        }
        pieces.m_142679_((StructurePiece)newPiece);
        return newPiece;
    }

    public static StructurePiece addHouse(StructureManager manager, BlockPos pos, Rotation rot, StructurePiecesBuilder builder, WorldgenRandom rand) {
        HousePiece newPiece = new HousePiece(manager, HOUSE, rot, pos);
        if (builder.m_141921_(newPiece.m_73547_()) != null) {
            return null;
        }
        builder.m_142679_((StructurePiece)newPiece);
        newPiece.tableCorner = rand.nextInt(6);
        newPiece.tableContent = rand.nextInt(4);
        newPiece.bedCorner = rand.nextInt(6);
        newPiece.bedDirection = rand.nextInt(2);
        newPiece.chestCorner = rand.nextInt(6);
        newPiece.chestDirection = rand.nextInt(2);
        return newPiece;
    }

    public static StructurePiece addPieceCheckBounds(ResourceLocation resourceLocation, StructureManager manager, BlockPos pos, Rotation rot, StructurePiecesBuilder pieces, WorldgenRandom rand) {
        return BarakoaVillagePieces.addPieceCheckBounds(resourceLocation, manager, pos, rot, (StructurePieceAccessor)pieces, rand, Collections.emptyList());
    }

    public static class Piece
    extends TemplateStructurePiece {
        protected ResourceLocation resourceLocation;

        public Piece(StructurePieceType pieceType, StructureManager manager, ResourceLocation resourceLocationIn, Rotation rotation, BlockPos pos) {
            super(pieceType, 0, manager, resourceLocationIn, resourceLocationIn.toString(), Piece.makeSettings(rotation, resourceLocationIn), Piece.makePosition(resourceLocationIn, pos, rotation));
            this.resourceLocation = resourceLocationIn;
        }

        public Piece(StructurePieceType pieceType, StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(pieceType, tagCompound, context.f_192764_(), resourceLocation -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.m_128461_("Rot")), resourceLocation));
        }

        public Piece(StructureManager manager, ResourceLocation resourceLocationIn, Rotation rotation, BlockPos pos) {
            this(FeatureHandler.BARAKOA_VILLAGE_PIECE, manager, resourceLocationIn, rotation, pos);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            this(FeatureHandler.BARAKOA_VILLAGE_PIECE, context, tagCompound);
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation, ResourceLocation resourceLocation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        private static BlockPos makePosition(ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
            return pos.m_141952_((Vec3i)OFFSET.get(resourceLocation).m_7954_(rotation));
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super.m_183620_(context, tagCompound);
            tagCompound.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        protected void m_7756_(String function, BlockPos pos, ServerLevelAccessor worldIn, Random rand, BoundingBox sbb) {
            Rotation rotation = this.f_73657_.m_74404_();
            if (function.equals("support")) {
                worldIn.m_7731_(pos, Blocks.f_50132_.m_49966_(), 3);
                this.fillAirLiquidDown((LevelAccessor)worldIn, Blocks.f_50132_.m_49966_(), pos.m_7495_());
            } else if (function.equals("leg")) {
                worldIn.m_7731_(pos, Blocks.f_50003_.m_49966_(), 3);
                this.fillAirLiquidDown((LevelAccessor)worldIn, Blocks.f_50003_.m_49966_(), pos.m_7495_());
            } else if (function.equals("stairs")) {
                Direction stairDirection = Direction.EAST;
                stairDirection = rotation.m_55954_(stairDirection);
                this.setBlockState((LevelAccessor)worldIn, pos.m_5484_(Direction.UP, 1), Blocks.f_50016_.m_49966_());
                this.setBlockState((LevelAccessor)worldIn, pos.m_5484_(Direction.UP, 2), Blocks.f_50016_.m_49966_());
                this.setBlockState((LevelAccessor)worldIn, pos, (BlockState)Blocks.f_50269_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)stairDirection.m_122424_()));
                pos = pos.m_142300_(Direction.DOWN);
                this.setBlockState((LevelAccessor)worldIn, pos, (BlockState)((BlockState)Blocks.f_50269_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)stairDirection)).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP));
                for (int i = 1; i < 20 && !Block.m_49936_((BlockGetter)worldIn, (BlockPos)(pos = pos.m_142300_(stairDirection))); ++i) {
                    this.setBlockState((LevelAccessor)worldIn, pos, (BlockState)Blocks.f_50269_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)stairDirection.m_122424_()));
                    pos = pos.m_142300_(Direction.DOWN);
                    this.setBlockState((LevelAccessor)worldIn, pos, (BlockState)((BlockState)Blocks.f_50269_.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)stairDirection)).m_61124_((Property)StairBlock.f_56842_, (Comparable)Half.TOP));
                }
            } else if (function.equals("barako")) {
                this.setBlockState((LevelAccessor)worldIn, pos, Blocks.f_50016_.m_49966_());
                EntityBarako barako = new EntityBarako((EntityType<? extends EntityBarako>)((EntityType)EntityHandler.BARAKO.get()), (Level)worldIn.m_6018_());
                barako.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                int i = rotation.m_55949_(3, 4);
                barako.setDirection(i);
                barako.m_6518_(worldIn, worldIn.m_6436_(barako.m_142538_()), MobSpawnType.STRUCTURE, null, null);
                BlockPos offset = new BlockPos(0, 0, -18);
                offset = offset.m_7954_(rotation);
                BlockPos firePitPos = pos.m_141952_((Vec3i)offset);
                firePitPos = worldIn.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, firePitPos);
                barako.m_21446_(firePitPos, -1);
                worldIn.m_7967_((Entity)barako);
            } else {
                worldIn.m_7471_(pos, false);
            }
        }

        protected void setBlockState(LevelAccessor worldIn, BlockPos pos, BlockState state) {
            FluidState ifluidstate = worldIn.m_6425_(pos);
            if (!ifluidstate.m_76178_()) {
                worldIn.m_183324_().m_183588_(pos, (Object)ifluidstate.m_76152_());
                if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
            }
            worldIn.m_7731_(pos, state, 2);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.m_60734_())) {
                worldIn.m_46865_(pos).m_8113_(pos);
            }
        }

        public void fillAirLiquidDown(LevelAccessor worldIn, BlockState state, BlockPos startPos) {
            int i = startPos.m_123341_();
            int k = startPos.m_123343_();
            for (int j = startPos.m_123342_(); !Block.m_49936_((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                this.setBlockState(worldIn, pos, state);
            }
        }
    }

    public static class HousePiece
    extends Piece {
        private int tableCorner;
        private int tableContent;
        private int bedCorner;
        private int bedDirection;
        private int chestCorner;
        private int chestDirection;

        public HousePiece(StructureManager manager, ResourceLocation resourceLocationIn, Rotation rotation, BlockPos pos) {
            super(FeatureHandler.BARAKOA_VILLAGE_HOUSE, manager, resourceLocationIn, rotation, pos);
        }

        public HousePiece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_HOUSE, context, tagCompound);
            this.tableCorner = tagCompound.m_128451_("TableCorner");
            this.tableContent = tagCompound.m_128451_("TableContent");
            this.bedCorner = tagCompound.m_128451_("BedCorner");
            this.bedDirection = tagCompound.m_128451_("bedDirection");
            this.chestCorner = tagCompound.m_128451_("ChestCorner");
            this.chestDirection = tagCompound.m_128451_("ChestDirection");
        }

        @Override
        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super.m_183620_(context, tagCompound);
            tagCompound.m_128405_("TableCorner", this.tableCorner);
            tagCompound.m_128405_("TableContent", this.tableContent);
            tagCompound.m_128405_("BedCorner", this.bedCorner);
            tagCompound.m_128405_("bedDirection", this.bedDirection);
            tagCompound.m_128405_("ChestCorner", this.chestCorner);
            tagCompound.m_128405_("ChestDirection", this.chestDirection);
        }

        @Override
        protected void m_7756_(String function, BlockPos pos, ServerLevelAccessor worldIn, Random rand, BoundingBox sbb) {
            Rotation rotation = this.f_73657_.m_74404_();
            if ("corner".equals(function.substring(0, function.length() - 1))) {
                worldIn.m_7471_(pos, false);
                pos = pos.m_7495_();
                int whichCorner = Integer.parseInt(function.substring(function.length() - 1));
                Rotation cornerRotation = Rotation.values()[4 - whichCorner];
                if (whichCorner == this.tableCorner) {
                    this.setBlockState((LevelAccessor)worldIn, pos, (BlockState)Blocks.f_50402_.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP));
                    if (this.tableContent <= 1) {
                        this.setBlockState((LevelAccessor)worldIn, pos.m_7494_(), Blocks.f_50081_.m_49966_());
                    } else if (this.tableContent == 2) {
                        int skullRot = cornerRotation.m_55949_(rotation.m_55949_(2, 16), 16);
                        this.setBlockState((LevelAccessor)worldIn, pos.m_7494_(), (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(skullRot)));
                    }
                } else if (whichCorner == this.bedCorner) {
                    this.setBlockState((LevelAccessor)worldIn, pos, Blocks.f_50340_.m_49966_());
                    BlockPos offset = new BlockPos(1, 0, 0);
                    if (this.bedDirection == 1) {
                        offset = new BlockPos(0, 0, -1);
                    }
                    offset = offset.m_7954_(rotation);
                    offset = offset.m_7954_(cornerRotation);
                    this.setBlockState((LevelAccessor)worldIn, pos.m_141952_((Vec3i)offset), Blocks.f_50340_.m_49966_());
                } else if (whichCorner == this.chestCorner) {
                    Direction facing = Direction.NORTH;
                    if (this.chestDirection == 1) {
                        facing = Direction.EAST;
                    }
                    facing = rotation.m_55954_(facing);
                    facing = cornerRotation.m_55954_(facing);
                    this.m_73420_(worldIn, sbb, rand, pos, LootTableHandler.BARAKOA_VILLAGE_HOUSE, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing));
                } else {
                    worldIn.m_7471_(pos, false);
                }
            } else if ("mask".equals(function)) {
                worldIn.m_7471_(pos, false);
                ItemFrame itemFrame = new ItemFrame((Level)worldIn.m_6018_(), pos, rotation.m_55954_(Direction.EAST));
                int i = rand.nextInt(MaskType.values().length);
                MaskType type = MaskType.values()[i];
                ItemBarakoaMask mask = ItemHandler.BARAKOA_MASK_FURY;
                switch (type) {
                    case BLISS: {
                        mask = ItemHandler.BARAKOA_MASK_BLISS;
                        break;
                    }
                    case FEAR: {
                        mask = ItemHandler.BARAKOA_MASK_FEAR;
                        break;
                    }
                    case FURY: {
                        mask = ItemHandler.BARAKOA_MASK_FURY;
                        break;
                    }
                    case MISERY: {
                        mask = ItemHandler.BARAKOA_MASK_MISERY;
                        break;
                    }
                    case RAGE: {
                        mask = ItemHandler.BARAKOA_MASK_RAGE;
                        break;
                    }
                    case FAITH: {
                        mask = ItemHandler.BARAKOA_MASK_FAITH;
                    }
                }
                ItemStack stack = new ItemStack((ItemLike)mask);
                itemFrame.m_31789_(stack, false);
                worldIn.m_7967_((Entity)itemFrame);
            } else {
                super.m_7756_(function, pos, worldIn, rand, sbb);
            }
        }
    }

    public static class AltarPiece
    extends NonTemplatePiece {
        public AltarPiece(int x, int y, int z, Direction direction) {
            super(FeatureHandler.BARAKOA_VILLAGE_ALTAR, x - 2, y - 1, z - 2, 5, 4, 5, direction);
        }

        public AltarPiece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_STAKE, tagCompound);
        }

        public void m_183269_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random randomIn, BoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            Vec2[] fenceSkullPositions;
            Vec2[] groundSkullPositions;
            Vec2[] thatchPositions;
            for (Vec2 pos : thatchPositions = new Vec2[]{new Vec2(0.0f, 1.0f), new Vec2(0.0f, 2.0f), new Vec2(0.0f, 3.0f), new Vec2(1.0f, 0.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 2.0f), new Vec2(1.0f, 3.0f), new Vec2(1.0f, 4.0f), new Vec2(2.0f, 0.0f), new Vec2(2.0f, 1.0f), new Vec2(2.0f, 2.0f), new Vec2(2.0f, 3.0f), new Vec2(2.0f, 4.0f), new Vec2(3.0f, 0.0f), new Vec2(3.0f, 1.0f), new Vec2(3.0f, 2.0f), new Vec2(3.0f, 3.0f), new Vec2(3.0f, 4.0f), new Vec2(4.0f, 1.0f), new Vec2(4.0f, 2.0f), new Vec2(4.0f, 3.0f)}) {
                BlockPos placePos = this.findGround((LevelAccessor)worldIn, (int)pos.f_82470_, (int)pos.f_82471_).m_7495_();
                worldIn.m_7731_(placePos, ((Block)BlockHandler.THATCH.get()).m_49966_(), 2);
            }
            for (Vec2 pos : groundSkullPositions = new Vec2[]{new Vec2(0.0f, 1.0f), new Vec2(0.0f, 3.0f), new Vec2(2.0f, 4.0f), new Vec2(3.0f, 3.0f), new Vec2(4.0f, 2.0f)}) {
                this.setBlockState((LevelAccessor)worldIn, this.findGround((LevelAccessor)worldIn, (int)pos.f_82470_, (int)pos.f_82471_), (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(randomIn.nextInt(16))));
            }
            for (Vec2 pos : fenceSkullPositions = new Vec2[]{new Vec2(0.0f, 2.0f), new Vec2(1.0f, 4.0f), new Vec2(3.0f, 4.0f), new Vec2(4.0f, 1.0f), new Vec2(4.0f, 3.0f)}) {
                BlockPos groundPos = this.findGround((LevelAccessor)worldIn, (int)pos.f_82470_, (int)pos.f_82471_);
                this.setBlockState((LevelAccessor)worldIn, groundPos, Blocks.f_50132_.m_49966_());
                this.setBlockState((LevelAccessor)worldIn, groundPos.m_7494_(), (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(randomIn.nextInt(16))));
            }
        }

        @Override
        public BlockPos findGround(LevelAccessor worldIn, int x, int z) {
            int i = this.m_73392_(x, z);
            int k = this.m_73525_(x, z);
            int j = worldIn.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, i, k);
            return new BlockPos(i, j, k);
        }
    }

    public static class StakePiece
    extends NonTemplatePiece {
        private final boolean skull;
        private final int skullDir;

        public StakePiece(Random random, int x, int y, int z) {
            super(FeatureHandler.BARAKOA_VILLAGE_STAKE, x, y, z, 1, 3, 1, Direction.NORTH);
            this.skull = random.nextBoolean();
            this.skullDir = random.nextInt(16);
        }

        public StakePiece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_STAKE, tagCompound);
            this.skull = tagCompound.m_128471_("Skull");
            this.skullDir = tagCompound.m_128451_("SkullDir");
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super.m_183620_(context, tagCompound);
            tagCompound.m_128379_("Skull", this.skull);
            tagCompound.m_128405_("SkullDir", this.skullDir);
        }

        public void m_183269_(WorldGenLevel worldIn, StructureFeatureManager p_230383_2_, ChunkGenerator p_230383_3_, Random p_230383_4_, BoundingBox mutableBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            this.m_73434_(worldIn, Blocks.f_50132_.m_49966_(), 0, 1, 0, mutableBoundingBoxIn);
            if (this.skull) {
                this.m_73434_(worldIn, (BlockState)Blocks.f_50310_.m_49966_().m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(this.skullDir)), 0, 2, 0, mutableBoundingBoxIn);
            } else {
                this.m_73434_(worldIn, Blocks.f_50081_.m_49966_(), 0, 2, 0, mutableBoundingBoxIn);
            }
            this.fillAirLiquidBelowHeightmap((LevelAccessor)worldIn, Blocks.f_50132_.m_49966_(), 0, 0);
        }
    }

    public static class FirepitPiece
    extends NonTemplatePiece {
        public FirepitPiece(Random random, int x, int z) {
            super(FeatureHandler.BARAKOA_VILLAGE_FIREPIT, x, 64, z, 9, 3, 9, Direction.NORTH);
        }

        public FirepitPiece(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super(FeatureHandler.BARAKOA_VILLAGE_FIREPIT, tagCompound);
        }

        public void m_183269_(WorldGenLevel worldIn, StructureFeatureManager structureManager, ChunkGenerator chunkGenerator, Random randomIn, BoundingBox p_230383_5_, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
            Vec2[] positions;
            BlockPos centerPos = this.findGround((LevelAccessor)worldIn, 4, 4);
            worldIn.m_7731_(centerPos, Blocks.f_50683_.m_49966_(), 2);
            this.fillAirLiquidBelowHeightmap((LevelAccessor)worldIn, Blocks.f_50003_.m_49966_(), 4, 4);
            for (Vec2 pos : positions = new Vec2[]{new Vec2(0.0f, 3.0f), new Vec2(0.0f, 5.0f), new Vec2(8.0f, 3.0f), new Vec2(8.0f, 5.0f), new Vec2(3.0f, 0.0f), new Vec2(5.0f, 0.0f), new Vec2(3.0f, 8.0f), new Vec2(5.0f, 8.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 7.0f), new Vec2(7.0f, 1.0f), new Vec2(7.0f, 7.0f)}) {
                worldIn.m_7731_(this.findGround((LevelAccessor)worldIn, (int)pos.f_82470_, (int)pos.f_82471_), Blocks.f_50003_.m_49966_(), 2);
                this.fillAirLiquidBelowHeightmap((LevelAccessor)worldIn, Blocks.f_50003_.m_49966_(), (int)pos.f_82470_, (int)pos.f_82471_);
            }
            int numBarakoa = randomIn.nextInt(5) + 5;
            block1: for (int i = 1; i <= numBarakoa; ++i) {
                EntityBarakoaVillager barakoa = new EntityBarakoaVillager((EntityType<? extends EntityBarakoaVillager>)((EntityType)EntityHandler.BARAKOA_VILLAGER.get()), (Level)worldIn.m_6018_());
                for (int j = 1; j <= 20; ++j) {
                    int distance = randomIn.nextInt(10) + 2;
                    int angle = randomIn.nextInt(360);
                    int x = (int)((double)distance * Math.sin(Math.toRadians(angle))) + 4;
                    int z = (int)((double)distance * Math.cos(Math.toRadians(angle))) + 4;
                    BlockPos bPos = this.findGround((LevelAccessor)worldIn, x, z);
                    barakoa.m_6034_(bPos.m_123341_(), bPos.m_123342_(), bPos.m_123343_());
                    if (bPos.m_123342_() <= 0 || !barakoa.m_5545_((LevelAccessor)worldIn, MobSpawnType.STRUCTURE) || !worldIn.m_45772_(barakoa.m_142469_())) continue;
                    barakoa.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(barakoa.m_142538_()), MobSpawnType.STRUCTURE, null, null);
                    barakoa.m_21446_(centerPos, 25);
                    worldIn.m_7967_((Entity)barakoa);
                    continue block1;
                }
            }
        }
    }

    public static abstract class NonTemplatePiece
    extends ScatteredFeaturePiece {
        protected NonTemplatePiece(StructurePieceType structurePieceTypeIn, int xIn, int yIn, int zIn, int widthIn, int heightIn, int depthIn, Direction direction) {
            super(structurePieceTypeIn, xIn, yIn, zIn, widthIn, heightIn, depthIn, direction);
        }

        protected NonTemplatePiece(StructurePieceType structurePieceTypeIn, CompoundTag nbt) {
            super(structurePieceTypeIn, nbt);
        }

        public BlockPos findGround(LevelAccessor worldIn, int x, int z) {
            int i = this.m_73392_(x, z);
            int k = this.m_73525_(x, z);
            int j = worldIn.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, i, k);
            return new BlockPos(i, j, k);
        }

        public void fillAirLiquidBelowHeightmap(LevelAccessor worldIn, BlockState state, int x, int z) {
            int i = this.m_73392_(x, z);
            int k = this.m_73525_(x, z);
            for (int j = worldIn.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, i, k) - 2; !Block.m_49936_((BlockGetter)worldIn, (BlockPos)new BlockPos(i, j, k)) && j > 1; --j) {
                BlockPos pos = new BlockPos(i, j, k);
                FluidState ifluidstate = worldIn.m_6425_(pos);
                BlockState toPut = state;
                if (!ifluidstate.m_76178_()) {
                    worldIn.m_183324_().m_183588_(pos, (Object)ifluidstate.m_76152_());
                    if (toPut.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        toPut = (BlockState)toPut.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                    }
                }
                worldIn.m_7731_(pos, toPut, 2);
                if (!BLOCKS_NEEDING_POSTPROCESSING.contains(state.m_60734_())) continue;
                worldIn.m_46865_(pos).m_8113_(pos);
            }
        }

        protected void setBlockState(LevelAccessor worldIn, BlockPos pos, BlockState state) {
            FluidState ifluidstate = worldIn.m_6425_(pos);
            if (!ifluidstate.m_76178_()) {
                worldIn.m_183324_().m_183588_(pos, (Object)ifluidstate.m_76152_());
                if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
            }
            worldIn.m_7731_(pos, state, 2);
            if (BLOCKS_NEEDING_POSTPROCESSING.contains(state.m_60734_())) {
                worldIn.m_46865_(pos).m_8113_(pos);
            }
        }
    }
}

