/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public abstract class MowzieStructure
extends StructureFeature<NoneFeatureConfiguration> {
    private final ConfigHandler.GenerationConfig config;

    public MowzieStructure(Codec<NoneFeatureConfiguration> codec, ConfigHandler.GenerationConfig config, Set<ResourceLocation> allowedBiomes, PieceGenerator<NoneFeatureConfiguration> generator, boolean doCheckHeight, boolean doAvoidWater, boolean doAvoidStructures) {
        super(codec, PieceGeneratorSupplier.m_197349_(c -> MowzieStructure.checkLocation(c, config, allowedBiomes, doCheckHeight, doAvoidWater, doAvoidStructures), generator), PostPlacementProcessor.f_192427_);
        this.config = config;
    }

    public MowzieStructure(Codec<NoneFeatureConfiguration> codec, ConfigHandler.GenerationConfig config, Set<ResourceLocation> allowedBiomes, PieceGenerator<NoneFeatureConfiguration> generator) {
        this(codec, config, allowedBiomes, generator, true, true, true);
    }

    protected static <C extends FeatureConfiguration> boolean checkLocation(PieceGeneratorSupplier.Context<C> context, ConfigHandler.GenerationConfig config, Set<ResourceLocation> allowedBiomes, boolean checkHeight, boolean avoidWater, boolean avoidStructures) {
        if ((Integer)config.generationDistance.get() < 0) {
            return false;
        }
        ChunkPos chunkPos = context.f_197355_();
        BlockPos centerOfChunk = new BlockPos((chunkPos.f_45578_ << 4) + 7, 0, (chunkPos.f_45579_ << 4) + 7);
        if (!context.m_197380_(Heightmap.Types.WORLD_SURFACE_WG)) {
            return false;
        }
        int i = chunkPos.m_151390_();
        int j = chunkPos.m_151393_();
        int k = context.f_197352_().m_156179_(i, j, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        Holder biome = context.f_197352_().m_203495_(QuartPos.m_175400_((int)i), QuartPos.m_175400_((int)k), QuartPos.m_175400_((int)j));
        if (!allowedBiomes.contains(((Biome)biome.m_203334_()).getRegistryName())) {
            return false;
        }
        if (checkHeight) {
            double minHeight = (Double)config.heightMin.get();
            double maxHeight = (Double)config.heightMax.get();
            int landHeight = context.m_197372_(16, 16);
            if (minHeight != -65.0 && (double)landHeight < minHeight) {
                return false;
            }
            if (maxHeight != -65.0 && (double)landHeight > maxHeight) {
                return false;
            }
        }
        if (avoidWater) {
            ChunkGenerator chunkGenerator = context.f_197352_();
            LevelHeightAccessor heightLimitView = context.f_197357_();
            int centerHeight = chunkGenerator.m_142647_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
            NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), heightLimitView);
            BlockState topBlock = columnOfBlocks.m_183556_(centerHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        if (avoidStructures) {
            List structuresToAvoid = (List)config.avoidStructures.get();
            Registry structureSetRegistry = context.f_197360_().m_175515_(Registry.f_211073_);
            for (String structureName : structuresToAvoid) {
                Optional resourceKeyOptional;
                Optional structureSetOptional = structureSetRegistry.m_6612_(new ResourceLocation(structureName));
                if (structureSetOptional.isEmpty() || (resourceKeyOptional = structureSetRegistry.m_7854_((Object)((StructureSet)structureSetOptional.get()))).isEmpty() || !context.f_197352_().m_212265_((ResourceKey)resourceKeyOptional.get(), context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, 5)) continue;
                return false;
            }
        }
        return true;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public ConfigHandler.GenerationConfig getConfig() {
        return this.config;
    }
}

