/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.structurepiececounter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.structurepiececounter.JSONConditionsRegistry;
import com.telepathicgrunt.repurposedstructures.misc.structurepiececounter.StructurePieceCountsAdditionsMerger;
import com.telepathicgrunt.repurposedstructures.misc.structurepiececounter.StructurePieceCountsObj;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class StructurePieceCountsManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private Map<ResourceLocation, List<StructurePieceCountsObj>> StructureToPieceCountsObjs = new HashMap<ResourceLocation, List<StructurePieceCountsObj>>();
    private final Map<ResourceLocation, Map<ResourceLocation, RequiredPieceNeeds>> cachedRequirePiecesMap = new HashMap<ResourceLocation, Map<ResourceLocation, RequiredPieceNeeds>>();
    private final Map<ResourceLocation, Map<ResourceLocation, Integer>> cachedMaxCountPiecesMap = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();

    public StructurePieceCountsManager() {
        super(GSON, "rs_pieces_spawn_counts");
    }

    @MethodsReturnNonnullByDefault
    private List<StructurePieceCountsObj> getStructurePieceCountsObjs(ResourceLocation fileIdentifier, JsonElement jsonElement) throws Exception {
        List piecesSpawnCounts = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("pieces_spawn_counts"), new TypeToken<List<StructurePieceCountsObj>>(){}.getType());
        for (int i = piecesSpawnCounts.size() - 1; i >= 0; --i) {
            StructurePieceCountsObj entry = (StructurePieceCountsObj)piecesSpawnCounts.get(i);
            if (entry.alwaysSpawnThisMany != null && entry.neverSpawnMoreThanThisMany != null && entry.alwaysSpawnThisMany > entry.neverSpawnMoreThanThisMany) {
                throw new Exception("Repurposed Structures Error: Found " + entry.nbtPieceName + " entry has alwaysSpawnThisMany greater than neverSpawnMoreThanThisMany which is invalid.");
            }
            if (entry.condition == null) continue;
            Optional optionalSupplier = JSONConditionsRegistry.RS_JSON_CONDITIONS_REGISTRY.m_6612_(new ResourceLocation(entry.condition));
            optionalSupplier.ifPresentOrElse(condition -> {
                if (!((Boolean)condition.get()).booleanValue()) {
                    piecesSpawnCounts.remove(entry);
                }
            }, () -> RepurposedStructures.LOGGER.error("Repurposed Structures Error: Found {} entry has a condition that does not exist. Extra info: {}", (Object)entry.nbtPieceName, (Object)fileIdentifier));
        }
        return piecesSpawnCounts;
    }

    protected void apply(Map<ResourceLocation, JsonElement> loader, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, List<StructurePieceCountsObj>> mapBuilder = new HashMap<ResourceLocation, List<StructurePieceCountsObj>>();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                mapBuilder.put((ResourceLocation)fileIdentifier, this.getStructurePieceCountsObjs((ResourceLocation)fileIdentifier, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("Repurposed Structures Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON looks like: {}", fileIdentifier, jsonElement, (Object)e);
            }
        });
        this.StructureToPieceCountsObjs = mapBuilder;
        this.cachedRequirePiecesMap.clear();
        StructurePieceCountsAdditionsMerger.performCountsAdditionsDetectionAndMerger(manager);
    }

    public void parseAndAddCountsJSONObj(ResourceLocation structureRL, List<JsonElement> jsonElements) {
        jsonElements.forEach(jsonElement -> {
            try {
                this.StructureToPieceCountsObjs.computeIfAbsent(structureRL, rl -> new ArrayList()).addAll(this.getStructurePieceCountsObjs(structureRL, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("Repurposed Structures Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON looks like: {}", (Object)structureRL, jsonElement, (Object)e);
            }
        });
    }

    @Nullable
    public Map<ResourceLocation, RequiredPieceNeeds> getRequirePieces(ResourceLocation structureRL) {
        if (!this.StructureToPieceCountsObjs.containsKey(structureRL)) {
            return null;
        }
        if (this.cachedRequirePiecesMap.containsKey(structureRL)) {
            return this.cachedRequirePiecesMap.get(structureRL);
        }
        HashMap<ResourceLocation, RequiredPieceNeeds> requirePiecesMap = new HashMap<ResourceLocation, RequiredPieceNeeds>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.alwaysSpawnThisMany != null) {
                    requirePiecesMap.put(new ResourceLocation(entry.nbtPieceName), new RequiredPieceNeeds(entry.alwaysSpawnThisMany, entry.minimumDistanceFromCenterPiece != null ? entry.minimumDistanceFromCenterPiece : 0));
                }
            });
        }
        this.cachedRequirePiecesMap.put(structureRL, requirePiecesMap);
        return requirePiecesMap;
    }

    @MethodsReturnNonnullByDefault
    public Map<ResourceLocation, Integer> getMaximumCountForPieces(ResourceLocation structureRL) {
        if (this.cachedMaxCountPiecesMap.containsKey(structureRL)) {
            return this.cachedMaxCountPiecesMap.get(structureRL);
        }
        HashMap<ResourceLocation, Integer> maxCountPiecesMap = new HashMap<ResourceLocation, Integer>();
        List<StructurePieceCountsObj> structurePieceCountsObjs = this.StructureToPieceCountsObjs.get(structureRL);
        if (structurePieceCountsObjs != null) {
            structurePieceCountsObjs.forEach(entry -> {
                if (entry.neverSpawnMoreThanThisMany != null) {
                    maxCountPiecesMap.put(new ResourceLocation(entry.nbtPieceName), entry.neverSpawnMoreThanThisMany);
                }
            });
        }
        this.cachedMaxCountPiecesMap.put(structureRL, maxCountPiecesMap);
        return maxCountPiecesMap;
    }

    public record RequiredPieceNeeds(int maxLimit, int minDistanceFromCenter) {
        public int getRequiredAmount() {
            return this.maxLimit;
        }

        public int getMinDistanceFromCenter() {
            return this.minDistanceFromCenter;
        }
    }
}

