/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSGenericConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class GenericJigsawStructure<C extends RSGenericConfig>
extends AbstractBaseStructure<C> {
    public GenericJigsawStructure(Codec<C> codec) {
        super(codec, GenericJigsawStructure::isGenericFeatureChunk, GenericJigsawStructure::generateGenericPieces);
    }

    public GenericJigsawStructure(Codec<C> codec, Predicate<PieceGeneratorSupplier.Context<C>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<C>, Optional<PieceGenerator<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends RSGenericConfig> boolean isGenericFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        ChunkPos chunkPos = context.f_197355_();
        RSGenericConfig config = (RSGenericConfig)context.f_197356_();
        if (!(context.f_197353_() instanceof CheckerboardColumnBiomeSource)) {
            for (int curChunkX = chunkPos.f_45578_ - config.biomeRadius; curChunkX <= chunkPos.f_45578_ + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - config.biomeRadius; curChunkZ <= chunkPos.f_45579_ + config.biomeRadius; ++curChunkZ) {
                    int yValue = config.doNotUseHeightmap ? config.setFixedYSpawn : config.setFixedYSpawn + context.f_197352_().m_156174_(curChunkX << 4, curChunkZ << 4, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    Holder biome = context.f_197353_().m_203407_(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.f_197352_().m_183403_());
                    if (context.f_197358_().test(biome)) continue;
                    return false;
                }
            }
        }
        if (config.cannotSpawnInLiquid) {
            BlockPos centerOfChunk = chunkPos.m_151394_(0);
            int landHeight = context.f_197352_().m_156179_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = context.f_197352_().m_141914_(centerOfChunk.m_123341_(), centerOfChunk.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(centerOfChunk.m_123342_() + landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        for (ResourceKey<StructureSet> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.f_197352_().m_212265_(structureSetToAvoid, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, config.structureAvoidRadius)) continue;
            return false;
        }
        if (config.allowedTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX = chunkPos.f_45578_ - config.terrainHeightCheckRadius; curChunkX <= chunkPos.f_45578_ + config.terrainHeightCheckRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - config.terrainHeightCheckRadius; curChunkZ <= chunkPos.f_45579_ + config.terrainHeightCheckRadius; ++curChunkZ) {
                    int height = context.f_197352_().m_142647_((curChunkX << 4) + 7, (curChunkZ << 4) + 7, Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= config.minYAllowed) continue;
                    return false;
                }
            }
            if (maxTerrainHeight - minTerrainHeight > config.allowedTerrainHeightRange) {
                return false;
            }
        }
        return true;
    }

    public static <CC extends RSGenericConfig> Optional<PieceGenerator<CC>> generateGenericPieces(PieceGeneratorSupplier.Context<CC> context) {
        RSGenericConfig config = (RSGenericConfig)context.f_197356_();
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), config.setFixedYSpawn, context.f_197355_().m_45605_());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), blockpos, !config.doNotUseHeightmap, !config.doNotUseHeightmap, Integer.MAX_VALUE, Integer.MIN_VALUE, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            GeneralUtils.centerAllPieces(blockpos, pieces);
            ((PoolElementStructurePiece)pieces.get(0)).m_6324_(0, config.centerYOffset, 0);
        });
    }
}

