/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSShipwreckEndConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public class ShipwreckEndStructure<C extends RSShipwreckEndConfig>
extends AbstractBaseStructure<C> {
    public ShipwreckEndStructure(Codec<C> codec) {
        super(codec, ShipwreckEndStructure::isShipwreckEndFeatureChunk, ShipwreckEndStructure::generateShipwreckEndPieces);
    }

    protected static <CC extends RSShipwreckEndConfig> boolean isShipwreckEndFeatureChunk(PieceGeneratorSupplier.Context<CC> context) {
        int zBlockPos;
        ChunkPos chunkPos = context.f_197355_();
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), context.f_197352_().m_6337_(), chunkPos.m_45605_());
        RSShipwreckEndConfig config = (RSShipwreckEndConfig)context.f_197356_();
        int radius = config.distanceFromOrigin;
        int xBlockPos = context.f_197355_().m_45604_();
        if (xBlockPos * xBlockPos + (zBlockPos = context.f_197355_().m_45605_()) * zBlockPos <= radius * radius) {
            return false;
        }
        int checkRadius = 16;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                NoiseColumn blockView = context.f_197352_().m_141914_(xOffset + blockPos.m_123341_(), zOffset + blockPos.m_123343_(), context.f_197357_());
                int topY = context.f_197352_().m_156179_(xOffset + blockPos.m_123341_(), zOffset + blockPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
                for (int yOffset = 0; yOffset <= 10; yOffset += 5) {
                    mutable.m_122190_((Vec3i)blockPos).m_122184_(xOffset, topY - yOffset, zOffset);
                    if (!blockView.m_183556_(mutable.m_123342_()).m_60795_()) continue;
                    return false;
                }
            }
        }
        for (ResourceKey<StructureSet> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.f_197352_().m_212265_(structureSetToAvoid, context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_, config.structureAvoidRadius)) continue;
            return false;
        }
        return ShipwreckEndStructure.getGenerationHeight(context.f_197355_(), context.f_197352_(), context.f_197357_()) >= Math.min(GeneralUtils.getMaxTerrainLimit(context.f_197352_()), config.minYAllowed);
    }

    private static int getGenerationHeight(ChunkPos chunkPos1, ChunkGenerator chunkGenerator, LevelHeightAccessor heightLimitView) {
        int x = chunkPos1.f_45578_ * 16;
        int z = chunkPos1.f_45579_ * 16;
        int heightmap1 = chunkGenerator.m_156179_(x + 5, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int heightmap2 = chunkGenerator.m_156179_(x, z + 5, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int heightmap3 = chunkGenerator.m_156179_(x - 5, z, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        int heightmap4 = chunkGenerator.m_156179_(x, z - 5, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView);
        return Math.min(Math.min(heightmap1, heightmap2), Math.min(heightmap3, heightmap4));
    }

    public static <CC extends RSShipwreckEndConfig> Optional<PieceGenerator<CC>> generateShipwreckEndPieces(PieceGeneratorSupplier.Context<CC> context) {
        RSShipwreckEndConfig config = (RSShipwreckEndConfig)context.f_197356_();
        BlockPos blockpos = new BlockPos(context.f_197355_().m_45604_(), ShipwreckEndStructure.getGenerationHeight(context.f_197355_(), context.f_197352_(), context.f_197357_()), context.f_197355_().m_45605_());
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new JigsawConfiguration(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.f_197360_()), blockpos, false, false, Integer.MAX_VALUE, Integer.MIN_VALUE, (structurePiecesBuilder, pieces) -> GeneralUtils.centerAllPieces(blockpos, pieces));
    }
}

