/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructurePieces;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class MirroringSingleJigsawPiece
extends SinglePoolElement {
    public static final Codec<MirroringSingleJigsawPiece> CODEC = RecordCodecBuilder.create(jigsawPieceInstance -> jigsawPieceInstance.group((App)MirroringSingleJigsawPiece.m_210465_(), (App)MirroringSingleJigsawPiece.m_210462_(), (App)MirroringSingleJigsawPiece.m_210538_(), MirroringSingleJigsawPiece.mirrorCodec()).apply((Applicative)jigsawPieceInstance, MirroringSingleJigsawPiece::new));
    protected final Mirror mirror;

    protected static <E extends MirroringSingleJigsawPiece> RecordCodecBuilder<E, Mirror> mirrorCodec() {
        return Codec.STRING.fieldOf("mirror").xmap(Mirror::valueOf, Enum::toString).forGetter(jigsawPieceInstance -> jigsawPieceInstance.mirror);
    }

    public MirroringSingleJigsawPiece(SinglePoolElement singleJigsawPiece, Mirror mirror) {
        this(((SinglePoolElementAccessor)singleJigsawPiece).repurposedstructures_getTemplate(), ((SinglePoolElementAccessor)singleJigsawPiece).repurposedstructures_getProcessors(), singleJigsawPiece.m_210539_(), mirror);
    }

    protected MirroringSingleJigsawPiece(Either<ResourceLocation, StructureTemplate> locationTemplateEither, Holder<StructureProcessorList> processorListSupplier, StructureTemplatePool.Projection placementBehaviour, Mirror mirror) {
        super(locationTemplateEither, processorListSupplier, placementBehaviour);
        this.mirror = mirror;
    }

    public MirroringSingleJigsawPiece(StructureTemplate template) {
        this((Either<ResourceLocation, StructureTemplate>)Either.right((Object)template), (Holder<StructureProcessorList>)ProcessorLists.f_127198_, StructureTemplatePool.Projection.RIGID, Mirror.NONE);
    }

    private StructureTemplate getTemplate(StructureManager templateManager) {
        return (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureManager)templateManager).m_74341_(arg_0), Function.identity());
    }

    public List<StructureTemplate.StructureBlockInfo> m_207245_(StructureManager templateManager, BlockPos blockPos, Rotation rotation, Random random) {
        StructureTemplate template = this.getTemplate(templateManager);
        List list = template.m_74607_(blockPos, new StructurePlaceSettings().m_74379_(rotation), Blocks.f_50678_, true);
        Collections.shuffle(list, random);
        return list;
    }

    public BoundingBox m_207470_(StructureManager templateManager, BlockPos blockPos, Rotation rotation) {
        StructureTemplate template = this.getTemplate(templateManager);
        return template.m_74633_(new StructurePlaceSettings().m_74379_(rotation).m_74377_(this.mirror), blockPos);
    }

    public boolean m_207251_(StructureManager templateManager, WorldGenLevel worldGenLevel, StructureFeatureManager structureManager, ChunkGenerator chunkGenerator, BlockPos blockPos, BlockPos blockPos1, Rotation rotation, BoundingBox mutableBoundingBox, Random random, boolean doNotReplaceJigsaw) {
        StructurePlaceSettings placementsettings;
        StructureTemplate template = this.getTemplate(templateManager);
        if (!template.m_74536_((ServerLevelAccessor)worldGenLevel, blockPos, blockPos1, placementsettings = this.m_207169_(rotation, mutableBoundingBox, doNotReplaceJigsaw), random, 18)) {
            return false;
        }
        for (StructureTemplate.StructureBlockInfo template$blockinfo : StructureTemplate.m_74517_((LevelAccessor)worldGenLevel, (BlockPos)blockPos, (BlockPos)blockPos1, (StructurePlaceSettings)placementsettings, (List)this.m_210457_(templateManager, blockPos, rotation, false))) {
            this.m_210472_((LevelAccessor)worldGenLevel, template$blockinfo, blockPos, rotation, random, mutableBoundingBox);
        }
        return true;
    }

    protected StructurePlaceSettings m_207169_(Rotation rotation, BoundingBox mutableBoundingBox, boolean doNotReplaceJigsaw) {
        StructurePlaceSettings placementsettings = new StructurePlaceSettings();
        placementsettings.m_74381_(mutableBoundingBox);
        placementsettings.m_74379_(rotation);
        placementsettings.m_74377_(this.mirror);
        placementsettings.m_74392_(false);
        placementsettings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        placementsettings.m_74405_(true);
        if (!doNotReplaceJigsaw) {
            placementsettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.f_210412_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)placementsettings).m_74383_(arg_0));
        return placementsettings;
    }

    public StructurePoolElementType<?> m_207234_() {
        return RSStructurePieces.MIRROR_SINGLE;
    }

    public String toString() {
        return "Mirror_Single[" + this.f_210411_ + "]";
    }
}

