/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.block;

import com.google.common.collect.ImmutableList;
import com.legacy.structure_gel.api.block.base.IStructureGel;
import com.legacy.structure_gel.api.item.StructureGelItem;
import com.legacy.structure_gel.core.SGConfig;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureGelBlock
extends Block
implements IStructureGel {
    public static final IntegerProperty COUNT = IntegerProperty.m_61631_((String)"count", (int)0, (int)51);
    public final ImmutableList<IStructureGel.IBehavior> behaviors;
    private static final Lazy<Set<Item>> ITEMS = Lazy.of(() -> (Set)Util.m_137469_(new HashSet(), set -> {
        set.add(Items.f_42751_);
        set.add(Items.f_42403_);
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof StructureGelItem).forEach(set::add);
    }));

    public StructureGelBlock(IStructureGel.IBehavior ... behaviors) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.0f).m_60993_().m_60955_().m_60918_(SoundType.f_56750_).m_60922_((state, reader, pos, entity) -> false).m_60960_((state, reader, pos) -> false).m_60971_((state, reader, pos) -> false));
        this.behaviors = ImmutableList.copyOf((Object[])behaviors);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)COUNT, (Comparable)Integer.valueOf(50)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        if (player != null && player.m_7500_()) {
            BlockState hookState = this.onHandPlaceHook(context);
            if (hookState != null) {
                return hookState;
            }
            int count = 50;
            if (player.m_6144_()) {
                count = 0;
                if (this.behaviors.contains((Object)IStructureGel.Behavior.DYNAMIC_SPREAD_DIST)) {
                    count = Math.min(Math.max(50 - context.m_43722_().m_41613_(), 0), 50);
                }
            }
            return (BlockState)this.m_49966_().m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count));
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_186460_(pos, (Block)this, 2);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if ((Integer)state.m_61143_((Property)COUNT) < 50) {
            if (!this.spreadHookPre(state, (Level)level, pos, rand)) {
                return;
            }
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.m_142300_(d);
                this.addGel(state, (Level)level, offset, (Integer)state.m_61143_((Property)COUNT) + 1);
                if (!this.behaviors.contains((Object)IStructureGel.Behavior.DIAGONAL_SPREAD)) continue;
                if (d == Direction.UP || d == Direction.DOWN) {
                    for (int i = 0; i < 4; ++i) {
                        this.addGel(state, (Level)level, offset.m_142300_(Direction.m_122407_((int)i)), (Integer)state.m_61143_((Property)COUNT) + 1);
                    }
                    continue;
                }
                this.addGel(state, (Level)level, offset.m_142300_(d.m_122427_()), (Integer)state.m_61143_((Property)COUNT) + 1);
            }
            this.setGel(state, (Level)level, pos, 50);
            this.spreadHookPost(state, (Level)level, pos, rand);
        } else if ((Integer)state.m_61143_((Property)COUNT) == 51) {
            if (!this.removalHookPre(state, (Level)level, pos, rand)) {
                return;
            }
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.m_142300_(d);
                this.removeGel(state, (Level)level, offset);
                if (!this.behaviors.contains((Object)IStructureGel.Behavior.DIAGONAL_SPREAD)) continue;
                if (d == Direction.UP || d == Direction.DOWN) {
                    for (int i = 0; i < 4; ++i) {
                        this.removeGel(state, (Level)level, offset.m_142300_(Direction.m_122407_((int)i)));
                    }
                    continue;
                }
                this.removeGel(state, (Level)level, offset.m_142300_(d.m_122427_()));
            }
            level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            this.removalHookPost(state, (Level)level, pos, rand);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_7500_() && player.m_21120_(hand).m_41720_() == Items.f_42403_) {
            this.removeGel(state, level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.m_7500_()) {
            for (Direction d : Direction.values()) {
                BlockPos offset = pos.m_142300_(d);
                if (level.m_8055_(offset).m_60734_() != this) continue;
                this.removeGel(state, level, offset);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void addGel(BlockState state, Level level, BlockPos pos, int count) {
        if (level.m_46859_(pos) && this.checkAbove(level, pos) && this.checkPlacementHook(level, pos, count)) {
            this.setGel(state, level, pos, count);
        }
    }

    public void removeGel(BlockState state, Level level, BlockPos pos) {
        if (level.m_8055_(pos).m_60734_() == this) {
            this.setGel(state, level, pos, 51);
        }
    }

    public void setGel(BlockState state, Level level, BlockPos pos, int count) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count)), 2);
        level.m_186460_(pos, level.m_8055_(pos).m_60734_(), 2);
    }

    public boolean checkAbove(Level level, BlockPos pos) {
        if (!this.behaviors.contains((Object)IStructureGel.Behavior.PHOTOSENSITIVE)) {
            return true;
        }
        if (!level.m_45527_(pos)) {
            return true;
        }
        int dy = 1;
        while (pos.m_6630_(dy).m_123342_() < 256) {
            if (!level.m_46859_(pos.m_6630_(dy))) {
                return true;
            }
            ++dy;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COUNT});
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        block2: {
            block4: {
                block3: {
                    Player player;
                    EntityCollisionContext eContext;
                    Entity entity;
                    if (!SGConfig.COMMON.advancedGelBehavior()) break block2;
                    if (context == CollisionContext.m_82749_()) break block3;
                    if (!((Set)ITEMS.get()).stream().anyMatch(arg_0 -> ((CollisionContext)context).m_7142_(arg_0)) && (!(context instanceof EntityCollisionContext) || !((entity = (eContext = (EntityCollisionContext)context).m_193113_()) instanceof Player) || !(player = (Player)entity).m_6144_() && player.m_7500_())) break block4;
                }
                return Shapes.m_83144_();
            }
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (SGConfig.COMMON.advancedGelBehavior()) {
            Player player = context.m_43723_();
            if (player != null) {
                Item item = context.m_43722_().m_41720_();
                if (player.m_6144_() || ((Set)ITEMS.get()).contains(item)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block oldBlock, BlockPos neighborPos, boolean flag) {
        BlockState newState;
        if (SGConfig.COMMON.advancedGelBehavior() && (newState = level.m_8055_(neighborPos)).m_60795_() && newState.m_60734_() != oldBlock && !(oldBlock instanceof StructureGelBlock)) {
            level.m_7731_(neighborPos, state, 2);
        }
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.m_60734_() == this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

