/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.renderers.BuildingToolRenderer;
import com.legacy.structure_gel.core.client.widget.MultiWidget;
import com.legacy.structure_gel.core.client.widget.PropertyEditBox;
import com.legacy.structure_gel.core.client.widget.PropertyImageButton;
import com.legacy.structure_gel.core.client.widget.TexturedEditBox;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.network.UndoRedoPacket;
import com.legacy.structure_gel.core.network.UpdateBuildingToolPacket;
import com.legacy.structure_gel.core.registry.SGItems;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;

public class BuildingToolScreen
extends Screen {
    private static final String FOLDER = "textures/gui/building_tool/";
    private static final ResourceLocation RADIAL_A = StructureGelMod.locate("textures/gui/building_tool/radial_a.png");
    private static final ResourceLocation RADIAL_B = StructureGelMod.locate("textures/gui/building_tool/radial_b.png");
    private static final ResourceLocation RADIAL_SELECTED_A = StructureGelMod.locate("textures/gui/building_tool/radial_selected_a.png");
    private static final ResourceLocation RADIAL_SELECTED_B = StructureGelMod.locate("textures/gui/building_tool/radial_selected_b.png");
    public static final ResourceLocation WIDGETS = StructureGelMod.locate("textures/gui/building_tool/widgets.png");
    public static final String UNDO_KEY = "info.structure_gel.building_tool.undo";
    private static final Component UNDO_TEXT = new TranslatableComponent("info.structure_gel.building_tool.undo");
    private static final String UNDO_DESC = "info.structure_gel.building_tool.undo.description";
    public static final String REDO_KEY = "info.structure_gel.building_tool.redo";
    private static final Component REDO_TEXT = new TranslatableComponent("info.structure_gel.building_tool.redo");
    private static final String REDO_DESC = "info.structure_gel.building_tool.redo.description";
    private static final Component SELECT_POS_TEXT = new TranslatableComponent("info.structure_gel.building_tool.select_pos");
    private static final String SELECT_POS_DESC = "info.structure_gel.building_tool.select_pos.description";
    private static final Component SELECT_STATE = new TranslatableComponent("info.structure_gel.building_tool.selected_state");
    private static final String SELECT_STATE_DESC = "info.structure_gel.building_tool.selected_state.description";
    private static final Component SELECT_STATE_NONE = new TranslatableComponent("info.structure_gel.building_tool.selected_state.none");
    public static final int TEXT_COLOR = 0xCDCDCD;
    public static final int HOVERED_TEXT_COLOR = 0xFFFFFF;
    private final List<RadialSlice> radialSlices = (List)Util.m_137469_(new ArrayList(8), list -> {
        float d = 22.5f;
        int i = 45;
        list.add(new RadialSlice(360.0f - d, d, RADIAL_A, RADIAL_SELECTED_A, 60, 0, 80, 80, 84, 15, BuildingToolMode.EXTEND));
        list.add(new RadialSlice(d, d += (float)i, RADIAL_B, RADIAL_SELECTED_B, 100, 0, 100, 100, 133, 35, BuildingToolMode.FLOOD));
        list.add(new RadialSlice(d, d += (float)i, RADIAL_A, RADIAL_SELECTED_A, 120, 60, 80, 80, 153, 84, BuildingToolMode.FILL));
        list.add(new RadialSlice(d, d += (float)i, RADIAL_B, RADIAL_SELECTED_B, 100, 100, 100, 100, 133, 133, BuildingToolMode.LINE));
        list.add(new RadialSlice(d, d += (float)i, RADIAL_A, RADIAL_SELECTED_A, 60, 120, 80, 80, 84, 153, BuildingToolMode.CLONE));
        list.add(new RadialSlice(d, d += (float)i, RADIAL_B, RADIAL_SELECTED_B, 0, 100, 100, 100, 35, 133, BuildingToolMode.MOVE));
        list.add(new RadialSlice(d, d += (float)i, RADIAL_A, RADIAL_SELECTED_A, 0, 60, 80, 80, 15, 84, BuildingToolMode.CLEAR));
        list.add(new RadialSlice(d, d += (float)i, RADIAL_B, RADIAL_SELECTED_B, 0, 0, 100, 100, 35, 35, BuildingToolMode.SHAPE));
    });
    private final ItemStack stack;
    private final InteractionHand hand;
    private BuildingToolMode mode = BuildingToolMode.NONE;
    private final Map<ToolModeProperty<?>, Object> properties = new HashMap();
    private Optional<BlockPos> selectedPos = Optional.empty();
    private Optional<BlockState> selectedState = Optional.empty();
    private Optional<ItemStack> selectedStateRender = Optional.empty();
    private int hoveredRadial = -1;
    private int selectedRadial = -1;
    private int tick = 0;
    private TexturedEditBox selectedStateEditBox;
    private final List<Widget> widgetsToRender = new ArrayList<Widget>(2);
    private final MultiWidget propertiesWidget = new MultiWidget();
    private static boolean sentWarning = false;

    public BuildingToolScreen(ItemStack stack, InteractionHand hand) {
        super(TextComponent.f_131282_);
        this.stack = stack;
        this.hand = hand;
        this.setSelectedState(BuildingToolItem.getSelectedState(stack));
        this.mode = BuildingToolItem.getMode(stack);
        this.setupProperties(this.mode);
        for (int i = 0; i < this.radialSlices.size(); ++i) {
            if (this.radialSlices.get((int)i).mode != this.mode) continue;
            this.selectedRadial = i;
            break;
        }
    }

    protected void m_7856_() {
        this.widgetsToRender.clear();
        int undoH = 16;
        int undoW = 25;
        int texSize = 256;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        this.widgetsToRender.add((Widget)this.m_7787_((GuiEventListener)new ImageButton(centerX - 187, centerY - 80, undoW, undoH, 0, 0, undoH, WIDGETS, texSize, texSize, button -> PacketHandler.sendToServer(new UndoRedoPacket(true)), (button, poseStack, x, y) -> this.renderDescription(poseStack, UNDO_TEXT, UNDO_DESC, ((BuildingToolItem)((Object)((Object)SGItems.BUILDING_TOOL.get()))).m_7968_().m_41786_(), ((KeyMapping)ClientProxy.UNDO_KEY.get()).m_90863_().getString()), UNDO_TEXT)));
        this.widgetsToRender.add((Widget)this.m_7787_((GuiEventListener)new ImageButton(centerX - 158, centerY - 80, undoW, undoH, undoW, 0, undoH, WIDGETS, texSize, texSize, button -> PacketHandler.sendToServer(new UndoRedoPacket(false)), (button, poseStack, x, y) -> this.renderDescription(poseStack, REDO_TEXT, REDO_DESC, ((BuildingToolItem)((Object)((Object)SGItems.BUILDING_TOOL.get()))).m_7968_().m_41786_(), ((KeyMapping)ClientProxy.REDO_KEY.get()).m_90863_().getString()), REDO_TEXT)));
        this.m_7787_(this.propertiesWidget);
        this.setupPropertiesWidgets(this.mode);
        int selectStateW = 206;
        this.selectedStateEditBox = (TexturedEditBox)this.m_142416_((GuiEventListener)new TexturedEditBox(this.f_96541_.f_91062_, centerX - selectStateW / 2, centerY - 50, selectStateW, 24, 50, 48, texSize, texSize, WIDGETS, SELECT_STATE));
        this.selectedStateEditBox.m_94194_(false);
        this.selectedStateEditBox.m_94199_(300);
        if (this.selectedState.isPresent()) {
            this.selectedStateEditBox.m_94144_(BlockStateParser.m_116769_((BlockState)(this.selectedState.get().m_60713_(Blocks.f_50626_) ? Blocks.f_50016_.m_49966_() : this.selectedState.get())));
        }
    }

    private void setSelectedState(String val) {
        BlockStateParser stateParser = new BlockStateParser(new StringReader(val), false);
        try {
            stateParser.m_116806_(true);
            this.setSelectedState(Optional.ofNullable(stateParser.m_116808_()));
        }
        catch (CommandSyntaxException e) {
            this.setSelectedState(Optional.empty());
        }
    }

    private void setSelectedState(Optional<BlockState> selectedState) {
        if (selectedState.isPresent() && selectedState.get().m_60713_(Blocks.f_50016_)) {
            selectedState = Optional.of(Blocks.f_50626_.m_49966_());
        }
        this.selectedState = selectedState;
        ItemStack selectedStateStack = null;
        if (this.selectedState.isPresent()) {
            Block block = this.selectedState.get().m_60734_();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                selectedStateStack = liquidBlock.getFluid().m_6859_().m_7968_();
            } else {
                selectedStateStack = block.m_5456_().m_7968_();
            }
            if (selectedStateStack.m_150930_(Items.f_41852_)) {
                selectedStateStack = Items.f_42446_.m_7968_();
            }
        }
        this.selectedStateRender = Optional.ofNullable(selectedStateStack);
    }

    private void setupProperties(BuildingToolMode mode) {
        this.properties.clear();
        if (BuildingToolItem.getMode(this.stack).equals(this.mode)) {
            for (ToolModeProperty<?> property : mode.getProperties().values()) {
                this.properties.put(property, BuildingToolItem.getProperty(this.stack, property));
            }
        } else {
            for (ToolModeProperty<?> property : mode.getProperties().values()) {
                this.properties.put(property, property.getDefaultValue());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setupPropertiesWidgets(BuildingToolMode mode) {
        centerX = this.f_96543_ / 2;
        centerY = this.f_96544_ / 2;
        texSize = 256;
        this.propertiesWidget.clear();
        if (mode instanceof BuildingToolMode.ForCorners) {
            setPosW = 20;
            this.propertiesWidget.addListener(new ImageButton(centerX - 170, centerY - 108, setPosW, setPosW, 150, 0, setPosW, BuildingToolScreen.WIDGETS, texSize, texSize, (Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$setupPropertiesWidgets$5(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((BuildingToolScreen)this), (Button.OnTooltip)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;Lcom/mojang/blaze3d/vertex/PoseStack;II)V, lambda$setupPropertiesWidgets$6(net.minecraft.client.gui.components.Button com.mojang.blaze3d.vertex.PoseStack int int ), (Lnet/minecraft/client/gui/components/Button;Lcom/mojang/blaze3d/vertex/PoseStack;II)V)((BuildingToolScreen)this), BuildingToolScreen.SELECT_POS_TEXT));
        }
        y = 60;
        for (Map.Entry<String, ToolModeProperty<?>> entry : mode.getProperties().entrySet()) {
            prop = entry.getValue();
            currentVal = this.properties.get(prop);
            if (!(prop instanceof ToolModeProperty.SelectionProp)) ** GOTO lbl-1000
            selectionProp = (ToolModeProperty.SelectionProp)prop;
            if (currentVal instanceof StringRepresentable) {
                this.propertiesWidget.addListener(new PropertyImageButton<StringRepresentable>(centerX - 210, centerY - y, 100, 24, 50, 0, (PropertyImageButton.OnPress<PropertyImageButton<T>>)LambdaMetafactory.metafactory(null, null, null, (Lcom/legacy/structure_gel/core/client/widget/PropertyImageButton;)V, lambda$setupPropertiesWidgets$7(com.legacy.structure_gel.core.client.widget.PropertyImageButton ), (Lcom/legacy/structure_gel/core/client/widget/PropertyImageButton;)V)((BuildingToolScreen)this), (Button.OnTooltip)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;Lcom/mojang/blaze3d/vertex/PoseStack;II)V, lambda$setupPropertiesWidgets$8(com.legacy.structure_gel.core.item.building_tool.ToolModeProperty net.minecraft.client.gui.components.Button com.mojang.blaze3d.vertex.PoseStack int int ), (Lnet/minecraft/client/gui/components/Button;Lcom/mojang/blaze3d/vertex/PoseStack;II)V)((BuildingToolScreen)this, prop), prop.getNameComponent(), selectionProp, (StringRepresentable)currentVal));
            } else lbl-1000:
            // 2 sources

            {
                editBox = new PropertyEditBox<Object>(this.f_96541_.f_91062_, centerX - 210, centerY - y, 100, 24, 50, 0, prop, currentVal);
                editBox.m_94151_((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$setupPropertiesWidgets$9(com.legacy.structure_gel.core.item.building_tool.ToolModeProperty java.lang.String ), (Ljava/lang/String;)V)((BuildingToolScreen)this, prop));
                editBox.setOnTooltip((TexturedEditBox.OnTooltip)LambdaMetafactory.metafactory(null, null, null, (Lcom/legacy/structure_gel/core/client/widget/TexturedEditBox;Lcom/mojang/blaze3d/vertex/PoseStack;II)V, lambda$setupPropertiesWidgets$10(com.legacy.structure_gel.core.item.building_tool.ToolModeProperty com.legacy.structure_gel.core.client.widget.TexturedEditBox com.mojang.blaze3d.vertex.PoseStack int int ), (Lcom/legacy/structure_gel/core/client/widget/TexturedEditBox;Lcom/mojang/blaze3d/vertex/PoseStack;II)V)((BuildingToolScreen)this, prop));
                this.propertiesWidget.addListener(editBox);
            }
            y -= 30;
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        int r;
        float mixedTick = (float)this.tick + Minecraft.m_91087_().m_91296_();
        float animationTime = 2.5f;
        int g = r = 30;
        int b = r;
        int a = 150;
        int alpha = mixedTick < animationTime ? (int)((float)a * mixedTick / animationTime) : a;
        int rgb = ((alpha << 8 | r) << 8 | g) << 8 | b;
        int rgb2 = ((alpha << 8 | (r /= 3)) << 8 | (g /= 3)) << 8 | (b /= 3);
        this.m_93179_(poseStack, 0, 0, this.f_96543_, this.f_96544_, rgb, rgb2);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        double xCoord = mouseX - this.f_96543_ / 2;
        double yCoord = this.f_96544_ - mouseY - this.f_96544_ / 2;
        double theta = Math.atan2(xCoord, yCoord) * 57.29577951308232;
        if (theta < 0.0) {
            theta = 360.0 + theta;
        }
        double dist = Math.sqrt(xCoord * xCoord + yCoord * yCoord);
        if (mixedTick < animationTime) {
            float scale = mixedTick / animationTime;
            float invscale = 1.0f - scale;
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)(this.f_96543_ / 2) * invscale), (double)((float)(this.f_96544_ / 2) * invscale), 0.0);
            poseStack.m_85841_(scale, scale, scale);
        }
        this.hoveredRadial = -1;
        if (!this.selectedStateEditBox.m_94213_()) {
            for (int i = this.radialSlices.size() - 1; i > -1; --i) {
                boolean wrapAround;
                RadialSlice slice = this.radialSlices.get(i);
                boolean hovered = false;
                float minDegree = slice.minDegree;
                float maxDegree = slice.maxDegree;
                boolean bl = wrapAround = minDegree > maxDegree;
                if ((wrapAround ? (theta > 180.0 ? theta > (double)minDegree : theta > (double)(minDegree - 360.0f)) && (theta > 180.0 ? theta < (double)(maxDegree + 360.0f) : theta < (double)maxDegree) : theta > (double)minDegree && theta < (double)maxDegree) && dist > 30.0 && dist < 110.0) {
                    hovered = true;
                    this.hoveredRadial = i;
                }
                if (this.selectedRadial == i && this.hoveredRadial != i) {
                    RenderSystem.m_157429_((float)1.0f, (float)0.7f, (float)1.0f, (float)1.0f);
                } else {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)(hovered || this.selectedRadial == i ? slice.selectedTexture : slice.texture));
                this.m_93228_(poseStack, centerX - (100 - slice.x), centerY - (100 - slice.y), slice.x, slice.y, slice.u, slice.v);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)slice.mode.getIconTexture());
                if (this.hoveredRadial != i && this.selectedRadial != i) {
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                }
                BuildingToolScreen.m_93133_((PoseStack)poseStack, (int)(centerX - (100 - slice.iconX)), (int)(centerY - (100 - slice.iconY)), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)WIDGETS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (dist < 21.0) {
            this.hoveredRadial = -2;
        }
        this.m_93228_(poseStack, centerX - 20, centerY - 20, 0, dist < 21.0 ? 72 : 32, 40, 40);
        this.widgetsToRender.forEach(w -> {
            w.m_6305_(poseStack, mouseX, mouseY, partialTick);
            RenderSystem.m_69478_();
        });
        if (!this.selectedStateEditBox.m_94213_()) {
            this.propertiesWidget.m_6305_(poseStack, mouseX, mouseY, partialTick);
        }
        if (this.hoveredRadial >= 0) {
            BuildingToolMode mode = this.radialSlices.get((int)this.hoveredRadial).mode;
            this.renderDescription(poseStack, mode.getComponent(), mode.getDescKey(), mode.getDescArgs());
        } else if (this.hoveredRadial == -2) {
            Optional<Component> stateComponent = this.selectedState.map(s -> s.m_60713_(Blocks.f_50626_) ? Blocks.f_50016_.m_49954_() : s.m_60734_().m_49954_());
            this.renderDescription(poseStack, SELECT_STATE, SELECT_STATE_DESC, stateComponent.orElse(SELECT_STATE_NONE).getString());
        }
        if (this.selectedStateRender.isPresent()) {
            this.f_96541_.m_91291_().m_115203_(this.selectedStateRender.get(), centerX - 8, centerY - 8);
        }
        if (mixedTick < animationTime) {
            poseStack.m_85849_();
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void renderDescription(PoseStack poseStack, Component title, String descriptionKey, Object ... descriptionArgs) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        LinkedList<FormattedCharSequence> lines = new LinkedList<FormattedCharSequence>();
        lines.add(title.m_7532_());
        int remainingWidth = Math.max(0, this.f_96543_ / 2 - 100 - 15);
        lines.addAll(this.f_96541_.f_91062_.m_92923_((FormattedText)new TranslatableComponent(descriptionKey, descriptionArgs).m_130940_(ChatFormatting.GRAY), remainingWidth));
        this.m_96617_(poseStack, lines, centerX + 100, centerY - 75);
    }

    public void m_96624_() {
        ++this.tick;
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        if (this.hoveredRadial == -1) {
            boolean clicked = super.m_6375_(mouseX, mouseY, clickType);
            if (!clicked && clickType == 0) {
                this.close();
            }
            return clicked;
        }
        if (this.hoveredRadial == -2) {
            boolean wasVisible = this.selectedStateEditBox.m_94213_();
            this.selectedStateEditBox.m_94194_(!wasVisible);
            this.m_7522_(null);
            this.selectedStateEditBox.m_94178_(false);
            BuildingToolScreen.playClickSound();
            if (wasVisible) {
                this.setSelectedState(this.selectedStateEditBox.m_94155_());
            } else {
                this.m_94718_((GuiEventListener)this.selectedStateEditBox);
            }
            this.f_96541_.f_91068_.m_90926_(!wasVisible);
            return true;
        }
        BuildingToolMode newMode = this.radialSlices.get((int)this.hoveredRadial).mode;
        BuildingToolScreen.playClickSound();
        if (this.mode != newMode) {
            this.mode = newMode;
            this.selectedRadial = this.hoveredRadial;
            this.setupProperties(this.mode);
            this.setupPropertiesWidgets(this.mode);
        } else {
            this.close();
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean pressedEnter;
        InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(keyCode);
        int escape = 256;
        int tab = 258;
        boolean bl = pressedEnter = keyCode == 257 || keyCode == 335;
        if (this.selectedStateEditBox.m_94213_() && this.selectedStateEditBox.m_93696_()) {
            if (pressedEnter || keyCode == escape || keyCode == tab) {
                this.m_5755_(true);
            }
            if (pressedEnter) {
                BuildingToolScreen.playClickSound();
                this.selectedStateEditBox.m_94194_(false);
                this.setSelectedState(this.selectedStateEditBox.m_94155_());
            }
            return this.selectedStateEditBox.m_7933_(keyCode, scanCode, modifiers);
        }
        if (((KeyMapping)ClientProxy.UNDO_KEY.get()).isActiveAndMatches(key)) {
            PacketHandler.sendToServer(new UndoRedoPacket(true));
            BuildingToolScreen.playClickSound();
            return true;
        }
        if (((KeyMapping)ClientProxy.REDO_KEY.get()).isActiveAndMatches(key)) {
            PacketHandler.sendToServer(new UndoRedoPacket(false));
            BuildingToolScreen.playClickSound();
            return true;
        }
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key) || pressedEnter) {
            this.close();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private void close() {
        Minecraft.m_91087_().m_91152_(null);
        this.m_7379_();
    }

    public void m_7379_() {
        if (!sentWarning && this.f_96541_.f_91066_.m_92174_() == CloudStatus.OFF) {
            this.f_96541_.f_91065_.m_93076_().m_93785_((Component)new TextComponent("Cloud rendering is currently disabled in your options. For technical reasons, this needs to be enabled to render building tool effects.").m_130940_(ChatFormatting.RED));
            sentWarning = true;
        }
        BuildingToolRenderer.needsUpdated();
        Minecraft mc = this.f_96541_;
        LocalPlayer player = mc.f_91074_;
        ItemStack stack = this.stack;
        if (stack.m_150930_((Item)SGItems.BUILDING_TOOL.get())) {
            BuildingToolMode buildingToolMode;
            if (BuildingToolItem.getMode(stack) != this.mode) {
                BuildingToolItem.clearPoses(stack);
            }
            BuildingToolItem.setMode(stack, this.mode);
            for (Map.Entry<ToolModeProperty<?>, Object> entry : this.properties.entrySet()) {
                ToolModeProperty<?> prop = entry.getKey();
                BuildingToolItem.setProperty(stack, prop, entry.getValue());
            }
            if (this.selectedPos.isPresent() && (buildingToolMode = this.mode) instanceof BuildingToolMode.ForCorners) {
                BuildingToolMode.ForCorners cornerMode = (BuildingToolMode.ForCorners)buildingToolMode;
                cornerMode.setPosition((Player)player, this.selectedPos.get(), stack);
            }
            if (this.selectedState.isPresent()) {
                BuildingToolItem.setSelectedState(stack, this.selectedState.get());
            }
            player.m_6674_(this.hand);
        }
        PacketHandler.sendToServer(new UpdateBuildingToolPacket(this.mode, this.hand, this.properties, this.selectedPos, this.selectedState));
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    public static void playClickSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$10(ToolModeProperty prop, TexturedEditBox box, PoseStack poseStack, int mouseX, int mouseY) {
        this.renderDescription(poseStack, prop.getNameComponent(), prop.getDescKey(), new Object[0]);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$9(ToolModeProperty prop, String s) {
        this.properties.put(prop, prop.read(s));
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$8(ToolModeProperty prop, Button button, PoseStack poseStack, int mouseX, int mouseY) {
        this.renderDescription(poseStack, prop.getNameComponent(), prop.getDescKey(), new Object[0]);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$7(PropertyImageButton button) {
        this.properties.put(button.getProperty(), button.getSelectedValue());
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$6(Button button, PoseStack poseStack, int x, int y) {
        this.renderDescription(poseStack, SELECT_POS_TEXT, SELECT_POS_DESC, new Object[0]);
    }

    private /* synthetic */ void lambda$setupPropertiesWidgets$5(Button button) {
        this.selectedPos = Optional.ofNullable(this.f_96541_.f_91074_.m_142538_());
        this.close();
    }

    private record RadialSlice(float minDegree, float maxDegree, ResourceLocation texture, ResourceLocation selectedTexture, int x, int y, int u, int v, int iconX, int iconY, BuildingToolMode mode) {
    }
}

