/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core;

import cofh.core.capability.CapabilityRedstoneFlux;
import cofh.core.config.ConfigManager;
import cofh.core.config.IBaseConfig;
import cofh.core.config.world.OreConfig;
import cofh.core.entity.AbstractGrenade;
import cofh.lib.client.renderer.entity.TNTMinecartRendererCoFH;
import cofh.lib.client.renderer.entity.TNTRendererCoFH;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.thermal.core.client.gui.ChargeBenchScreen;
import cofh.thermal.core.client.gui.TinkerBenchScreen;
import cofh.thermal.core.client.gui.device.DeviceCollectorScreen;
import cofh.thermal.core.client.gui.device.DeviceComposterScreen;
import cofh.thermal.core.client.gui.device.DeviceFisherScreen;
import cofh.thermal.core.client.gui.device.DeviceHiveExtractorScreen;
import cofh.thermal.core.client.gui.device.DeviceNullifierScreen;
import cofh.thermal.core.client.gui.device.DevicePotionDiffuserScreen;
import cofh.thermal.core.client.gui.device.DeviceRockGenScreen;
import cofh.thermal.core.client.gui.device.DeviceSoilInfuserScreen;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.client.gui.device.DeviceWaterGenScreen;
import cofh.thermal.core.client.gui.storage.EnergyCellScreen;
import cofh.thermal.core.client.gui.storage.FluidCellScreen;
import cofh.thermal.core.client.gui.storage.SatchelScreen;
import cofh.thermal.core.client.renderer.entity.BasalzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BasalzRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzRenderer;
import cofh.thermal.core.client.renderer.entity.model.BasalzModel;
import cofh.thermal.core.client.renderer.entity.model.BlitzModel;
import cofh.thermal.core.client.renderer.entity.model.BlizzModel;
import cofh.thermal.core.client.renderer.entity.model.ElementalProjectileModel;
import cofh.thermal.core.config.ThermalClientConfig;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.config.ThermalDeviceConfig;
import cofh.thermal.core.config.ThermalWorldConfig;
import cofh.thermal.core.entity.explosive.DetonateUtils;
import cofh.thermal.core.entity.monster.Basalz;
import cofh.thermal.core.entity.monster.Blitz;
import cofh.thermal.core.entity.monster.Blizz;
import cofh.thermal.core.init.TCoreBlocks;
import cofh.thermal.core.init.TCoreContainers;
import cofh.thermal.core.init.TCoreEntities;
import cofh.thermal.core.init.TCoreFluids;
import cofh.thermal.core.init.TCoreItems;
import cofh.thermal.core.init.TCoreRecipeManagers;
import cofh.thermal.core.init.TCoreRecipeSerializers;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.lib.common.ThermalFeatures;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalProxy;
import cofh.thermal.lib.common.ThermalProxyClient;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal")
public class ThermalCore {
    public static final Logger LOG = LogManager.getLogger((String)"thermal");
    public static final ThermalProxy PROXY = (ThermalProxy)DistExecutor.unsafeRunForDist(() -> ThermalProxyClient::new, () -> ThermalProxy::new);
    public static final ConfigManager CONFIG_MANAGER = new ConfigManager();
    public static final DeferredRegisterCoFH<Block> BLOCKS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thermal");
    public static final DeferredRegisterCoFH<Item> ITEMS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"thermal");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"thermal");
    public static final DeferredRegisterCoFH<MenuType<?>> CONTAINERS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"thermal");
    public static final DeferredRegisterCoFH<EntityType<?>> ENTITIES = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"thermal").preventDataFixers(true);
    public static final DeferredRegisterCoFH<GlobalLootModifierSerializer<?>> LOOT_SERIALIZERS = DeferredRegisterCoFH.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"thermal");
    public static final DeferredRegisterCoFH<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"thermal");
    public static final DeferredRegisterCoFH<SoundEvent> SOUND_EVENTS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"thermal");
    public static final DeferredRegisterCoFH<BlockEntityType<?>> TILE_ENTITIES = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"thermal");

    public ThermalCore() {
        this.setFeatureFlags();
        this.addWorldConfigs();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CONFIG_MANAGER.register(modEventBus).addClientConfig((IBaseConfig)new ThermalClientConfig()).addServerConfig((IBaseConfig)new ThermalCoreConfig()).addServerConfig((IBaseConfig)new ThermalDeviceConfig()).addCommonConfig((IBaseConfig)new ThermalWorldConfig());
        modEventBus.addListener(this::entityAttributeSetup);
        modEventBus.addListener(this::entityLayerSetup);
        modEventBus.addListener(this::entityRendererSetup);
        modEventBus.addListener(this::capSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addGenericListener(GlobalLootModifierSerializer.class, this::registerLootData);
        modEventBus.addListener(this::registrySetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        FLUIDS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENTITIES.register(modEventBus);
        LOOT_SERIALIZERS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ThermalFeatures.register(modEventBus);
    }

    private void setFeatureFlags() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_AREA_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_FILTER_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_UPGRADE_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_CREATIVE_AUGMENTS, true);
        ThermalFlags.setFlag("tinker_bench", true);
    }

    private void addWorldConfigs() {
        List<ResourceKey> defaultDimensions = Collections.singletonList(Level.f_46428_);
        ThermalWorldConfig.addOreConfig("niter_ore", new OreConfig("Niter", 2, -16, 64, 7, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER)));
        ThermalWorldConfig.addOreConfig("sulfur_ore", new OreConfig("Sulfur", 2, -16, 32, 7, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER)));
        ThermalWorldConfig.addOreConfig("tin_ore", new OreConfig("Tin", 6, -20, 60, 9, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN)));
        ThermalWorldConfig.addOreConfig("lead_ore", new OreConfig("Lead", 6, -60, 40, 8, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD)));
        ThermalWorldConfig.addOreConfig("silver_ore", new OreConfig("Silver", 4, -60, 40, 8, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER)));
        ThermalWorldConfig.addOreConfig("nickel_ore", new OreConfig("Nickel", 4, -40, 120, 8, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL)));
        ThermalWorldConfig.addOreConfig("apatite_ore", new OreConfig("Apatite", 4, -16, 96, 9, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_APATITE)));
        ThermalWorldConfig.addOreConfig("cinnabar_ore", new OreConfig("Cinnabar", 1, -16, 48, 5, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CINNABAR)));
        ThermalWorldConfig.addOreConfig("oil_sand", new OreConfig("Oil Sand", 2, 40, 80, 24, defaultDimensions, ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_OIL)));
    }

    private void registerLootData(RegistryEvent.Register<GlobalLootModifierSerializer<?>> event) {
        ThermalFlags.manager().setup();
        TCoreRecipeTypes.register();
    }

    private void entityAttributeSetup(EntityAttributeCreationEvent event) {
        event.put((EntityType)TCoreEntities.BASALZ.get(), Basalz.registerAttributes().m_22265_());
        event.put((EntityType)TCoreEntities.BLITZ.get(), Blitz.registerAttributes().m_22265_());
        event.put((EntityType)TCoreEntities.BLIZZ.get(), Blizz.registerAttributes().m_22265_());
    }

    private void entityLayerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BasalzModel.BASALZ_LAYER, BasalzModel::createBodyLayer);
        event.registerLayerDefinition(BlitzModel.BLITZ_LAYER, BlitzModel::createBodyLayer);
        event.registerLayerDefinition(BlizzModel.BLIZZ_LAYER, BlizzModel::createBodyLayer);
        event.registerLayerDefinition(ElementalProjectileModel.PROJECTILE_LAYER, ElementalProjectileModel::createBodyLayer);
    }

    private void entityRendererSetup(EntityRenderersEvent.RegisterRenderers event) {
        for (RegistryObject<EntityType<? extends AbstractGrenade>> registryObject : DetonateUtils.GRENADES) {
            event.registerEntityRenderer((EntityType)registryObject.get(), ThrownItemRenderer::new);
        }
        for (RegistryObject<EntityType<? extends AbstractGrenade>> registryObject : DetonateUtils.TNT) {
            event.registerEntityRenderer((EntityType)registryObject.get(), TNTRendererCoFH::new);
        }
        for (RegistryObject<EntityType<? extends AbstractGrenade>> registryObject : DetonateUtils.CARTS) {
            event.registerEntityRenderer((EntityType)registryObject.get(), TNTMinecartRendererCoFH::new);
        }
        event.registerEntityRenderer((EntityType)TCoreEntities.BASALZ.get(), BasalzRenderer::new);
        event.registerEntityRenderer((EntityType)TCoreEntities.BLITZ.get(), BlitzRenderer::new);
        event.registerEntityRenderer((EntityType)TCoreEntities.BLIZZ.get(), BlizzRenderer::new);
        event.registerEntityRenderer((EntityType)TCoreEntities.BASALZ_PROJECTILE.get(), BasalzProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)TCoreEntities.BLITZ_PROJECTILE.get(), BlitzProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)TCoreEntities.BLIZZ_PROJECTILE.get(), BlizzProjectileRenderer::new);
    }

    private void capSetup(RegisterCapabilitiesEvent event) {
        CapabilityRedstoneFlux.register((RegisterCapabilitiesEvent)event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TCoreBlocks::setup);
        event.enqueueWork(TCoreItems::setup);
        event.enqueueWork(TCoreFluids::setup);
        event.enqueueWork(TCoreEntities::setup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerGuiFactories);
        event.enqueueWork(this::registerRenderLayers);
    }

    private void registrySetup(NewRegistryEvent event) {
        CONFIG_MANAGER.setupClient();
        CONFIG_MANAGER.setupServer();
        CONFIG_MANAGER.setupCommon();
        ThermalFeatures.register();
    }

    private void registerGuiFactories() {
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_HIVE_EXTRACTOR_CONTAINER.get()), DeviceHiveExtractorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_TREE_EXTRACTOR_CONTAINER.get()), DeviceTreeExtractorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_FISHER_CONTAINER.get()), DeviceFisherScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_COMPOSTER_CONTAINER.get()), DeviceComposterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_SOIL_INFUSER_CONTAINER.get()), DeviceSoilInfuserScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_WATER_GEN_CONTAINER.get()), DeviceWaterGenScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_ROCK_GEN_CONTAINER.get()), DeviceRockGenScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_COLLECTOR_CONTAINER.get()), DeviceCollectorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_POTION_DIFFUSER_CONTAINER.get()), DevicePotionDiffuserScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.DEVICE_NULLIFIER_CONTAINER.get()), DeviceNullifierScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.TINKER_BENCH_CONTAINER.get()), TinkerBenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.CHARGE_BENCH_CONTAINER.get()), ChargeBenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.SATCHEL_CONTAINER.get()), SatchelScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.ENERGY_CELL_CONTAINER.get()), EnergyCellScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)TCoreContainers.FLUID_CELL_CONTAINER.get()), FluidCellScreen::new);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("obsidian_glass")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("signalum_glass")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("lumium_glass")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("enderium_glass")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("machine_frame")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("energy_cell_frame")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("energy_cell")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("fluid_cell_frame")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("fluid_cell")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("device_tree_extractor")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("device_composter")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("device_water_gen")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("device_rock_gen")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("device_collector")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("device_potion_diffuser")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BLOCKS.get("device_nullifier")), (RenderType)cutout);
    }

    static {
        TCoreBlocks.register();
        TCoreItems.register();
        TCoreFluids.register();
        TCoreContainers.register();
        TCoreEntities.register();
        TCoreSounds.register();
        TCoreTileEntities.register();
        TCoreRecipeManagers.register();
        TCoreRecipeSerializers.register();
    }
}

