/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.inventory.container.device.DeviceMagnetBlockerContainer;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DeviceMagnetBlockerTile
extends DeviceTileBase
implements ITickableTile.IServerTickable,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Area", "Filter");
    public static final Set<ItemEntity> AFFECTED_ENTITIES = Collections.newSetFromMap(new WeakHashMap());
    protected static final int TIME_CONSTANT = 1;
    protected static final Predicate<ItemEntity> VALID_ITEM_ENTITY = item -> {
        if (!item.m_6084_() || item.m_32063_()) {
            return false;
        }
        CompoundTag data = item.getPersistentData();
        return !data.m_128471_("PreventRemoteMovement") || data.m_128471_("AllowMachineRemoteMovement");
    };
    protected static final int RADIUS = 4;
    public int radius = 4;
    protected AABB area;
    protected int process = 1;

    public DeviceMagnetBlockerTile(BlockPos pos, BlockState state) {
        super(null, pos, state);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    @Override
    protected void updateActiveState(boolean prevActive) {
        if (!prevActive && this.isActive) {
            this.process = 1;
        }
        super.updateActiveState(prevActive);
    }

    public void tickServer() {
        this.updateActiveState();
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.getTimeConstant();
        this.demagnetizeItems(this.getArea());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceMagnetBlockerContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    public int getRadius() {
        return this.radius;
    }

    public int getTimeConstant() {
        return 1;
    }

    protected void demagnetizeItems(AABB area) {
        List items = this.f_58857_.m_6443_(ItemEntity.class, area, VALID_ITEM_ENTITY);
        Predicate filterRules = this.filter.getItemRules();
        for (ItemEntity item : items) {
            ItemStack entityStack;
            if (AFFECTED_ENTITIES.contains(item) || !filterRules.test(entityStack = item.m_32055_())) continue;
            AFFECTED_ENTITIES.add(item);
            item.getPersistentData().m_128379_("PreventRemoteMovement", true);
        }
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 4;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"Radius"));
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.area = null;
    }

    public AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.f_58858_.m_142082_(-this.radius, -1, -this.radius), this.f_58858_.m_142082_(1 + this.radius, 1 + this.radius, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? 11017314 : 0x555555;
    }
}

