/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DevicePotionDiffuserContainer;
import cofh.thermal.core.util.managers.device.PotionDiffuserManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;

public class DevicePotionDiffuserTile
extends DeviceTileBase
implements ITickableTile,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Fluid", "Area", "Filter", "Potion");
    protected static final int TIME_CONSTANT = 60;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && PotionDiffuserManager.instance().validBoost((ItemStack)item));
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && FluidHelper.hasPotionTag((FluidStack)fluid));
    protected static final int FLUID_AMOUNT = 25;
    protected static final int RADIUS = 4;
    protected int radius = 4;
    protected AABB area;
    protected boolean cached;
    protected List<MobEffectInstance> effects = Collections.emptyList();
    protected boolean instant;
    protected int process = 1;
    protected int boostCycles;
    protected int boostMax = PotionDiffuserManager.instance().getDefaultEnergy();
    protected int boostAmplifier;
    protected float boostDuration;
    protected float potionAmpMod = 0.0f;
    protected float potionDurMod = 0.0f;

    public DevicePotionDiffuserTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_POTION_DIFFUSER_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.ACCESSIBLE);
        this.tankInv.addTank(this.inputTank, StorageGroup.ACCESSIBLE);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
    }

    @Override
    protected void updateActiveState(boolean prevActive) {
        if (!prevActive && this.isActive) {
            this.process = 1;
        }
        super.updateActiveState(prevActive);
    }

    @Override
    protected boolean isValid() {
        if (this.inputTank.getAmount() < 25) {
            this.cached = false;
            return false;
        }
        return true;
    }

    public void tick() {
        this.updateActiveState();
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.getTimeConstant();
        if (Utils.isClientWorld((Level)this.world())) {
            this.diffuseClient();
            return;
        }
        Fluid curFluid = this.renderFluid.getFluid();
        this.cacheEffects();
        this.diffuse();
        if (curFluid != this.renderFluid.getFluid()) {
            TileStatePacket.sendToClient((IPacketHandlerTile)this);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DevicePotionDiffuserContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    public int getScaledDuration(int scale) {
        return !this.isActive || this.boostCycles <= 0 || this.boostMax <= 0 ? 0 : scale * this.boostCycles / this.boostMax;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void handleControlPacket(FriendlyByteBuf buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.boostCycles);
        buffer.writeInt(this.boostMax);
        buffer.writeInt(this.boostAmplifier);
        buffer.writeFloat(this.boostDuration);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.boostCycles = buffer.readInt();
        this.boostMax = buffer.readInt();
        this.boostAmplifier = buffer.readInt();
        this.boostDuration = buffer.readFloat();
    }

    @Override
    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeBoolean(this.instant);
        return buffer;
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        super.handleStatePacket(buffer);
        this.process = buffer.readInt();
        this.instant = buffer.readBoolean();
        ModelDataManager.requestModelDataRefresh((BlockEntity)this);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.boostCycles = nbt.m_128451_("BoostCycles");
        this.boostMax = nbt.m_128451_("BoostMax");
        this.boostAmplifier = nbt.m_128451_("BoostAmp");
        this.boostDuration = nbt.m_128457_("BoostDur");
        this.instant = nbt.m_128471_("Instant");
        this.process = nbt.m_128451_("Proc");
        this.cacheEffects();
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("BoostCycles", this.boostCycles);
        nbt.m_128405_("BoostMax", this.boostMax);
        nbt.m_128405_("BoostAmp", this.boostAmplifier);
        nbt.m_128350_("BoostDur", this.boostDuration);
        nbt.m_128379_("Instant", this.instant);
        nbt.m_128405_("Proc", this.process);
    }

    public int getRadius() {
        return this.radius;
    }

    public int getTimeConstant() {
        return 60;
    }

    public boolean isInstant() {
        return this.instant;
    }

    protected void cacheEffects() {
        if (this.inputTank.isEmpty()) {
            if (this.cached) {
                this.effects.clear();
                this.instant = false;
                this.cached = false;
            }
        } else if (!this.cached) {
            this.effects = PotionUtils.m_43566_((CompoundTag)this.inputTank.getFluidStack().getTag());
            for (MobEffectInstance effect : this.effects) {
                this.instant |= effect.m_19544_().m_8093_();
            }
            this.cached = true;
        }
    }

    protected void diffuse() {
        if (this.inputTank.getAmount() < 25) {
            return;
        }
        if (this.effects.isEmpty() || this.f_58857_ == null) {
            return;
        }
        AABB area = this.getArea();
        List targets = this.f_58857_.m_6443_(LivingEntity.class, area, EntitySelector.f_20403_);
        if (targets.isEmpty()) {
            return;
        }
        if (this.boostCycles > 0) {
            --this.boostCycles;
        } else if (PotionDiffuserManager.instance().validBoost(this.inputSlot.getItemStack())) {
            this.boostMax = this.boostCycles = PotionDiffuserManager.instance().getBoostCycles(this.inputSlot.getItemStack());
            this.boostAmplifier = PotionDiffuserManager.instance().getBoostAmplifier(this.inputSlot.getItemStack());
            this.boostDuration = PotionDiffuserManager.instance().getBoostDurationMod(this.inputSlot.getItemStack());
            this.inputSlot.consume(1);
        } else {
            this.boostCycles = 0;
            this.boostAmplifier = 0;
            this.boostDuration = 0.0f;
        }
        for (LivingEntity target : targets) {
            if (!target.m_5801_()) continue;
            for (MobEffectInstance effect : this.effects) {
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_(null, null, target, this.getEffectAmplifier(effect), 0.5);
                    continue;
                }
                MobEffectInstance potion = new MobEffectInstance(effect.m_19544_(), this.getEffectDuration(effect), this.getEffectAmplifier(effect), effect.m_19571_(), effect.m_19572_());
                target.m_7292_(potion);
            }
        }
        this.inputTank.modify(-25);
        this.renderFluid = this.inputTank.getFluidStack();
    }

    protected void diffuseClient() {
        if (this.renderFluid.getAmount() < 25) {
            return;
        }
        AABB area = new AABB(this.f_58858_.m_142082_(-this.radius, -1, -this.radius), this.f_58858_.m_142082_(1 + this.radius, 1 + this.radius, 1 + this.radius));
        List targets = this.f_58857_.m_6443_(LivingEntity.class, area, EntitySelector.f_20402_);
        if (targets.isEmpty()) {
            return;
        }
        ThermalCore.PROXY.spawnDiffuserParticles(this);
    }

    protected int getEffectAmplifier(MobEffectInstance effect) {
        return Math.min(3, Math.round((float)effect.m_19564_() + this.potionAmpMod + (float)this.boostAmplifier));
    }

    protected int getEffectDuration(MobEffectInstance effect) {
        return Math.min(72000, Math.round((float)effect.m_19557_() * (1.0f + this.potionDurMod + this.boostDuration))) / 4;
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 4;
        this.potionAmpMod = 0.0f;
        this.potionDurMod = 0.0f;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"Radius"));
        this.potionAmpMod += AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"PotionAmp");
        this.potionDurMod += AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"PotionDur");
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.area = null;
    }

    public AABB getArea() {
        if (this.area == null) {
            this.area = new AABB(this.f_58858_.m_142082_(-this.radius, -1, -this.radius), this.f_58858_.m_142082_(1 + this.radius, 1 + this.radius, 1 + this.radius));
        }
        return this.area;
    }

    public int getColor() {
        return this.isActive ? (this.renderFluid.isEmpty() ? 0xF800F8 : FluidHelper.color((FluidStack)this.renderFluid)) : 0x555555;
    }
}

