/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DeviceRockGenContainer;
import cofh.thermal.core.util.managers.device.RockGenManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DeviceRockGenTile
extends DeviceTileBase
implements ITickableTile.IServerTickable {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade");
    protected static final Supplier<ItemStack> COBBLESTONE = () -> new ItemStack((ItemLike)Blocks.f_50652_, 0);
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH(e -> false).setEmptyItem(COBBLESTONE).setEnabled(() -> this.isActive);
    protected Block below = Blocks.f_50016_;
    protected Block adjacent = Blocks.f_50016_;
    protected int adjLava = 0;
    protected boolean cached;
    protected boolean valid;
    protected int process;
    protected int processMax = RockGenManager.instance().getDefaultEnergy();
    protected int genAmount = 1;

    public DeviceRockGenTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_ROCK_GEN_TILE.get(), pos, state);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76195_, 1000);
    }

    public Block getBelow() {
        return this.below;
    }

    public Block getAdjacent() {
        return this.adjacent;
    }

    public int getAdjLava() {
        return this.adjLava;
    }

    @Override
    protected void updateValidity() {
        if (this.f_58857_ == null || !this.f_58857_.isAreaLoaded(this.f_58858_, 1)) {
            return;
        }
        this.adjLava = 0;
        this.valid = false;
        Block[] adjBlocks = new Block[4];
        BlockPos[] cardinals = new BlockPos[]{this.f_58858_.m_142127_(), this.f_58858_.m_142128_(), this.f_58858_.m_142125_(), this.f_58858_.m_142126_()};
        for (int i = 0; i < 4; ++i) {
            BlockPos adj = cardinals[i];
            FluidState fluidState = this.f_58857_.m_6425_(adj);
            if (fluidState.m_76152_().equals(Fluids.f_76195_)) {
                ++this.adjLava;
            }
            adjBlocks[i] = fluidState.m_76178_() || fluidState.m_76170_() ? this.f_58857_.m_8055_(adj).m_60734_() : Blocks.f_50016_;
        }
        if (this.adjLava > 0) {
            Block under = this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60734_();
            RockGenManager.RockGenRecipe recipe = RockGenManager.instance().getResult(under, adjBlocks);
            ItemStack result = recipe.getResult();
            if (!result.m_41619_()) {
                this.outputSlot.setEmptyItem(() -> new ItemStack((ItemLike)result.m_41720_(), 0));
                if (!this.outputSlot.isEmpty() && !ItemHelper.itemsEqualWithTags((ItemStack)result, (ItemStack)this.outputSlot.getItemStack())) {
                    this.outputSlot.clear();
                }
                Block prevBelow = this.below;
                Block prevAdj = this.adjacent;
                this.below = recipe.getBelow();
                this.adjacent = recipe.getAdjacent();
                if (this.below != prevBelow || this.adjacent != prevAdj) {
                    TileStatePacket.sendToClient((IPacketHandlerTile)this);
                }
                this.processMax = recipe.getTime();
                this.genAmount = Math.max(1, result.m_41613_());
                if (((Biome)this.f_58857_.m_204166_(this.f_58858_).m_203334_()).m_47567_() == Biome.BiomeCategory.NETHER) {
                    this.processMax = Math.max(1, this.processMax / 2);
                }
                this.process = this.processMax;
                this.valid = true;
            }
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            this.updateValidity();
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    public void tickServer() {
        this.updateActiveState();
        if (!this.isActive) {
            return;
        }
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.process = this.processMax;
        this.outputSlot.modify((int)((float)this.genAmount * this.baseMod));
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceRockGenContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    public int getScaledProgress(int scale) {
        if (!this.isActive || this.processMax <= 0 || this.outputSlot.isFull()) {
            return 0;
        }
        return scale * (this.processMax - this.process) / this.processMax;
    }

    @Override
    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.processMax);
        return buffer;
    }

    @Override
    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.process = buffer.readInt();
        this.processMax = buffer.readInt();
    }

    @Override
    public FriendlyByteBuf getStatePacket(FriendlyByteBuf buffer) {
        super.getStatePacket(buffer);
        buffer.writeInt(this.process);
        buffer.writeInt(this.adjLava);
        buffer.m_130070_(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.below).toString());
        buffer.m_130070_(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.adjacent).toString());
        return buffer;
    }

    @Override
    public void handleStatePacket(FriendlyByteBuf buffer) {
        super.handleStatePacket(buffer);
        this.process = buffer.readInt();
        this.adjLava = buffer.readInt();
        this.below = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.m_130277_()));
        this.adjacent = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(buffer.m_130277_()));
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.process = nbt.m_128451_("Proc");
        this.processMax = nbt.m_128451_("ProcMax");
        this.adjLava = nbt.m_128451_("Lava");
        this.below = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("Below")));
        this.adjacent = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("Adjacent")));
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Proc", this.process);
        nbt.m_128405_("ProcMax", this.processMax);
        nbt.m_128405_("Lava", this.adjLava);
        nbt.m_128359_("Below", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.below).toString());
        nbt.m_128359_("Adjacent", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this.adjacent).toString());
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }
}

