/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.data;

import cofh.lib.data.RecipeProviderCoFH;
import cofh.lib.tags.ItemTagsCoFH;
import cofh.lib.util.DeferredRegisterCoFH;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.util.references.ThermalTags;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class TCoreRecipeProvider
extends RecipeProviderCoFH {
    public TCoreRecipeProvider(DataGenerator generatorIn) {
        super(generatorIn, "thermal");
        this.manager = ThermalFlags.manager();
    }

    public String m_6055_() {
        return "Thermal Core: Recipes";
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        this.generateStorageRecipes(consumer, (Item)reg.get("charcoal_block"), Items.f_42414_);
        this.generateStorageRecipes(consumer, (Item)reg.get("bamboo_block"), Items.f_41911_);
        this.generateStorageRecipes(consumer, (Item)reg.get("sugar_cane_block"), Items.f_41909_);
        this.generateStorageRecipes(consumer, (Item)reg.get("gunpowder_block"), Items.f_42403_);
        this.generateStorageRecipes(consumer, (Item)reg.get("apple_block"), Items.f_42410_);
        this.generateStorageRecipes(consumer, (Item)reg.get("beetroot_block"), Items.f_42732_);
        this.generateStorageRecipes(consumer, (Item)reg.get("carrot_block"), Items.f_42619_);
        this.generateStorageRecipes(consumer, (Item)reg.get("potato_block"), Items.f_42620_);
        this.generateGearRecipe(consumer, (Item)reg.get("copper_gear"), Items.f_151052_, TCoreRecipeProvider.forgeTag((String)"ingots/copper"));
        this.generateGearRecipe(consumer, (Item)reg.get("iron_gear"), Items.f_42416_, TCoreRecipeProvider.forgeTag((String)"ingots/iron"));
        this.generateGearRecipe(consumer, (Item)reg.get("gold_gear"), Items.f_42417_, TCoreRecipeProvider.forgeTag((String)"ingots/gold"));
        this.generateGearRecipe(consumer, (Item)reg.get("netherite_gear"), Items.f_42418_, TCoreRecipeProvider.forgeTag((String)"ingots/netherite"));
        this.generateGearRecipe(consumer, (Item)reg.get("diamond_gear"), Items.f_42416_, TCoreRecipeProvider.forgeTag((String)"gems/diamond"));
        this.generateGearRecipe(consumer, (Item)reg.get("emerald_gear"), Items.f_42416_, TCoreRecipeProvider.forgeTag((String)"gems/emerald"));
        this.generateGearRecipe(consumer, (Item)reg.get("quartz_gear"), Items.f_42416_, TCoreRecipeProvider.forgeTag((String)"gems/quartz"));
        this.generateGearRecipe(consumer, (Item)reg.get("lapis_gear"), Items.f_42416_, TCoreRecipeProvider.forgeTag((String)"gems/lapis"));
        this.generateStorageRecipes(consumer, (Item)reg.get("sawdust_block"), (Item)reg.get("sawdust"));
        this.generateStorageRecipes(consumer, (Item)reg.get("coal_coke_block"), (Item)reg.get("coal_coke"));
        this.generateStorageRecipes(consumer, (Item)reg.get("bitumen_block"), (Item)reg.get("bitumen"));
        this.generateStorageRecipes(consumer, (Item)reg.get("tar_block"), (Item)reg.get("tar"));
        this.generateStorageRecipes(consumer, (Item)reg.get("rosin_block"), (Item)reg.get("rosin"));
        this.generateSmallStorageRecipes(consumer, (Item)reg.get("rubber_block"), (Item)reg.get("rubber"));
        this.generateSmallStorageRecipes(consumer, (Item)reg.get("cured_rubber_block"), (Item)reg.get("cured_rubber"));
        this.generateSmallStorageRecipes(consumer, (Item)reg.get("slag_block"), (Item)reg.get("slag"));
        this.generateSmallStorageRecipes(consumer, (Item)reg.get("rich_slag_block"), (Item)reg.get("rich_slag"));
        this.generateTypeRecipes(reg, consumer, "signalum");
        this.generateTypeRecipes(reg, consumer, "lumium");
        this.generateTypeRecipes(reg, consumer, "enderium");
        this.generateSmeltingAndBlastingRecipes(reg, consumer, "signalum", 0.0f);
        this.generateSmeltingAndBlastingRecipes(reg, consumer, "lumium", 0.0f);
        this.generateSmeltingAndBlastingRecipes(reg, consumer, "enderium", 0.0f);
        this.generateSmeltingAndBlastingRecipes(reg, consumer, (Item)reg.get("copper_dust"), Items.f_151052_, 0.0f, "smelting", "_dust");
        this.generateSmeltingAndBlastingRecipes(reg, consumer, (Item)reg.get("iron_dust"), Items.f_42416_, 0.0f, "smelting", "_dust");
        this.generateSmeltingAndBlastingRecipes(reg, consumer, (Item)reg.get("gold_dust"), Items.f_42417_, 0.0f, "smelting", "_dust");
        this.generateSmeltingAndBlastingRecipes(reg, consumer, (Item)reg.get("netherite_dust"), Items.f_42418_, 0.0f, "smelting", "_dust");
        this.generatePackingRecipe(consumer, Items.f_151052_, (Item)reg.get("copper_nugget"), "_from_nuggets");
        this.generatePackingRecipe(consumer, Items.f_42418_, (Item)reg.get("netherite_nugget"), "_from_nuggets");
        this.generateUnpackingRecipe(consumer, Items.f_151052_, (Item)reg.get("copper_nugget"), "_from_ingot");
        this.generateUnpackingRecipe(consumer, Items.f_42418_, (Item)reg.get("netherite_nugget"), "_from_ingot");
        this.generateSmeltingRecipe(reg, consumer, Items.f_41832_, (Item)reg.get("slag"), 0.1f, "smelting");
        this.generateSmeltingRecipe(reg, consumer, (Item)reg.get("rubber"), (Item)reg.get("cured_rubber"), 0.2f, "smelting");
        this.generateAlloyRecipes(consumer);
        this.generateArmorRecipes(consumer);
        this.generateAugmentRecipes(consumer);
        this.generateBasicRecipes(consumer);
        this.generateChargeRecipes(consumer);
        this.generateComponentRecipes(consumer);
        this.generateExplosiveRecipes(consumer);
        this.generateRockwoolRecipes(consumer);
        this.generateSlagRecipes(consumer);
        this.generateTileRecipes(consumer);
    }

    private void generateAlloyRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("signalum_dust")), (int)4).m_206419_(ItemTagsCoFH.DUSTS_COPPER).m_206419_(ItemTagsCoFH.DUSTS_COPPER).m_206419_(ItemTagsCoFH.DUSTS_COPPER).m_206419_(ItemTagsCoFH.DUSTS_SILVER).m_206419_(Tags.Items.DUSTS_REDSTONE).m_206419_(Tags.Items.DUSTS_REDSTONE).m_206419_(Tags.Items.DUSTS_REDSTONE).m_206419_(Tags.Items.DUSTS_REDSTONE).m_142284_("has_redstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176500_(consumer, "thermal:signalum_dust_4");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("lumium_dust")), (int)4).m_206419_(ItemTagsCoFH.DUSTS_TIN).m_206419_(ItemTagsCoFH.DUSTS_TIN).m_206419_(ItemTagsCoFH.DUSTS_TIN).m_206419_(ItemTagsCoFH.DUSTS_SILVER).m_206419_(Tags.Items.DUSTS_GLOWSTONE).m_206419_(Tags.Items.DUSTS_GLOWSTONE).m_142284_("has_glowstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_GLOWSTONE)).m_176500_(consumer, "thermal:lumium_dust_4");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("enderium_dust")), (int)2).m_206419_(ItemTagsCoFH.DUSTS_LEAD).m_206419_(ItemTagsCoFH.DUSTS_LEAD).m_206419_(ItemTagsCoFH.DUSTS_LEAD).m_206419_(ItemTagsCoFH.DUSTS_DIAMOND).m_126184_(this.fromTags(new TagKey[]{Tags.Items.ENDER_PEARLS, ItemTagsCoFH.DUSTS_ENDER_PEARL})).m_126184_(this.fromTags(new TagKey[]{Tags.Items.ENDER_PEARLS, ItemTagsCoFH.DUSTS_ENDER_PEARL})).m_142284_("has_ender_pearl", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.ENDER_PEARLS)).m_176500_(consumer, "thermal:enderium_dust_2");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("signalum_ingot")), (int)4).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_COPPER, Tags.Items.INGOTS_COPPER})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_COPPER, Tags.Items.INGOTS_COPPER})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_COPPER, Tags.Items.INGOTS_COPPER})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_SILVER, ItemTagsCoFH.INGOTS_SILVER})).m_206419_(Tags.Items.DUSTS_REDSTONE).m_206419_(Tags.Items.DUSTS_REDSTONE).m_206419_(Tags.Items.DUSTS_REDSTONE).m_206419_(Tags.Items.DUSTS_REDSTONE).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_redstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176500_(consumer, "thermal:fire_charge/signalum_ingot_4");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("lumium_ingot")), (int)4).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_TIN, ItemTagsCoFH.INGOTS_TIN})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_TIN, ItemTagsCoFH.INGOTS_TIN})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_TIN, ItemTagsCoFH.INGOTS_TIN})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_SILVER, ItemTagsCoFH.INGOTS_SILVER})).m_206419_(Tags.Items.DUSTS_GLOWSTONE).m_206419_(Tags.Items.DUSTS_GLOWSTONE).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_glowstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_GLOWSTONE)).m_176500_(consumer, "thermal:fire_charge/lumium_ingot_4");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("enderium_ingot")), (int)2).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_LEAD, ItemTagsCoFH.INGOTS_LEAD})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_LEAD, ItemTagsCoFH.INGOTS_LEAD})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_LEAD, ItemTagsCoFH.INGOTS_LEAD})).m_206419_(ItemTagsCoFH.DUSTS_DIAMOND).m_126184_(this.fromTags(new TagKey[]{Tags.Items.ENDER_PEARLS, ItemTagsCoFH.DUSTS_ENDER_PEARL})).m_126184_(this.fromTags(new TagKey[]{Tags.Items.ENDER_PEARLS, ItemTagsCoFH.DUSTS_ENDER_PEARL})).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_ender_pearl", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.ENDER_PEARLS)).m_176500_(consumer, "thermal:fire_charge/enderium_ingot_2");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("obsidian_glass")), (int)2).m_206419_(Tags.Items.OBSIDIAN).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_QUARTZ, Tags.Items.GEMS_QUARTZ})).m_206419_(Tags.Items.SAND).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_obsidian", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.OBSIDIAN)).m_176500_(consumer, "thermal:fire_charge/obsidian_glass_2");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("signalum_glass")), (int)2).m_126209_((ItemLike)reg.get("obsidian_glass")).m_126209_((ItemLike)reg.get("obsidian_glass")).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_SIGNALUM, ItemTagsCoFH.INGOTS_SIGNALUM})).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_signalum_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.DUSTS_SIGNALUM)).m_142284_("has_signalum_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_SIGNALUM)).m_176500_(consumer, "thermal:fire_charge/signalum_glass_2");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("lumium_glass")), (int)2).m_126209_((ItemLike)reg.get("obsidian_glass")).m_126209_((ItemLike)reg.get("obsidian_glass")).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_LUMIUM, ItemTagsCoFH.INGOTS_LUMIUM})).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_lumium_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.DUSTS_LUMIUM)).m_142284_("has_lumium_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_LUMIUM)).m_176500_(consumer, "thermal:fire_charge/lumium_glass_2");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("enderium_glass")), (int)2).m_126209_((ItemLike)reg.get("obsidian_glass")).m_126209_((ItemLike)reg.get("obsidian_glass")).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.DUSTS_ENDERIUM, ItemTagsCoFH.INGOTS_ENDERIUM})).m_126209_((ItemLike)Items.f_42613_).m_142284_("has_enderium_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.DUSTS_ENDERIUM)).m_142284_("has_enderium_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_ENDERIUM)).m_176500_(consumer, "thermal:fire_charge/enderium_glass_2");
    }

    private void generateArmorRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        String folder = "armor";
        Item beekeeperFabric = (Item)reg.get("beekeeper_fabric");
        Item divingFabric = (Item)reg.get("diving_fabric");
        Item hazmatFabric = (Item)reg.get("hazmat_fabric");
        ShapedRecipeBuilder.m_126116_((ItemLike)beekeeperFabric).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126127_(Character.valueOf('H'), (ItemLike)Items.f_42784_).m_126130_(" S ").m_126130_("SHS").m_126130_(" S ").m_142284_("has_honeycomb", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42784_)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BEEKEEPER_ARMOR));
        Item result = (Item)reg.get("beekeeper_helmet");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_126127_(Character.valueOf('X'), (ItemLike)beekeeperFabric).m_126130_("XXX").m_126130_("X X").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)beekeeperFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BEEKEEPER_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("beekeeper_chestplate");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_126127_(Character.valueOf('X'), (ItemLike)beekeeperFabric).m_126130_("X X").m_126130_("XXX").m_126130_("XXX").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)beekeeperFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BEEKEEPER_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("beekeeper_leggings");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_126127_(Character.valueOf('X'), (ItemLike)beekeeperFabric).m_126130_("XXX").m_126130_("X X").m_126130_("X X").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)beekeeperFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BEEKEEPER_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("beekeeper_boots");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_126127_(Character.valueOf('X'), (ItemLike)beekeeperFabric).m_126130_("X X").m_126130_("L L").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)beekeeperFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BEEKEEPER_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        ShapedRecipeBuilder.m_126116_((ItemLike)divingFabric).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_206416_(Character.valueOf('H'), Tags.Items.GEMS_PRISMARINE).m_126130_(" S ").m_126130_("SHS").m_126130_(" S ").m_142284_("has_prismarine", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_PRISMARINE)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DIVING_ARMOR));
        result = (Item)reg.get("diving_helmet");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('X'), (ItemLike)divingFabric).m_126130_("XIX").m_126130_("IGI").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)divingFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DIVING_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("diving_chestplate");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('X'), (ItemLike)divingFabric).m_126130_("X X").m_126130_("IXI").m_126130_("XXX").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)divingFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DIVING_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("diving_leggings");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('X'), (ItemLike)divingFabric).m_126130_("XXX").m_126130_("I I").m_126130_("X X").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)divingFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DIVING_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("diving_boots");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('X'), (ItemLike)divingFabric).m_126130_("X X").m_126130_("LIL").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)divingFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DIVING_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        ShapedRecipeBuilder.m_126116_((ItemLike)hazmatFabric).m_206416_(Character.valueOf('S'), Tags.Items.STRING).m_126127_(Character.valueOf('H'), (ItemLike)reg.get("cured_rubber")).m_126130_(" S ").m_126130_("SHS").m_126130_(" S ").m_142284_("has_cured_rubber", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("cured_rubber")))).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_HAZMAT_ARMOR));
        result = (Item)reg.get("hazmat_helmet");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), Tags.Items.GLASS_PANES).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('X'), (ItemLike)hazmatFabric).m_126130_("XIX").m_126130_("IGI").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)hazmatFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_HAZMAT_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("hazmat_chestplate");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('X'), (ItemLike)hazmatFabric).m_126130_("X X").m_126130_("IXI").m_126130_("XXX").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)hazmatFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_HAZMAT_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("hazmat_leggings");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('X'), (ItemLike)hazmatFabric).m_126130_("XXX").m_126130_("I I").m_126130_("X X").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)hazmatFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_HAZMAT_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("hazmat_boots");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_126127_(Character.valueOf('R'), (ItemLike)reg.get("cured_rubber")).m_126127_(Character.valueOf('X'), (ItemLike)hazmatFabric).m_126130_("X X").m_126130_("LRL").m_142284_("has_fabric", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)hazmatFabric)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_HAZMAT_ARMOR), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
    }

    private void generateAugmentRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        String folder = "augments";
        Item redstoneServo = (Item)reg.get("redstone_servo");
        Item rfCoil = (Item)reg.get("rf_coil");
        Item result = (Item)reg.get("area_radius_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_IRON).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_TIN).m_126127_(Character.valueOf('X'), (ItemLike)redstoneServo).m_126130_(" G ").m_126130_("IXI").m_126130_(" G ").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_AREA_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("dynamo_output_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_SILVER).m_206416_(Character.valueOf('S'), ItemTagsCoFH.PLATES_SIGNALUM).m_206416_(Character.valueOf('X'), ThermalTags.Items.HARDENED_GLASS).m_126130_(" G ").m_126130_("SXS").m_126130_(" G ").m_142284_("has_hardened_glass", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_(ThermalTags.Items.HARDENED_GLASS)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DYNAMO_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("dynamo_fuel_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_LEAD).m_206416_(Character.valueOf('L'), ItemTagsCoFH.PLATES_LUMIUM).m_206416_(Character.valueOf('X'), ThermalTags.Items.HARDENED_GLASS).m_126130_(" G ").m_126130_("LXL").m_126130_(" G ").m_142284_("has_hardened_glass", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_(ThermalTags.Items.HARDENED_GLASS)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DYNAMO_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("dynamo_throttle_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('E'), ItemTagsCoFH.INGOTS_ELECTRUM).m_206416_(Character.valueOf('l'), ItemTagsCoFH.NUGGETS_LEAD).m_126130_(" l ").m_126130_("lEl").m_126130_(" l ").m_142284_("has_electrum_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_ELECTRUM)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_DYNAMO_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("fluid_filter_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('c'), ItemTagsCoFH.NUGGETS_BRONZE).m_206416_(Character.valueOf('S'), ItemTagsCoFH.INGOTS_SIGNALUM).m_126130_(" c ").m_126130_("cSc").m_126130_(" c ").m_142284_("has_signalum_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_SIGNALUM)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_FILTER_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("item_filter_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('t'), ItemTagsCoFH.NUGGETS_TIN).m_206416_(Character.valueOf('S'), ItemTagsCoFH.INGOTS_SIGNALUM).m_126130_(" t ").m_126130_("tSt").m_126130_(" t ").m_142284_("has_signalum_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_SIGNALUM)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_FILTER_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("machine_speed_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('E'), ItemTagsCoFH.PLATES_ELECTRUM).m_206416_(Character.valueOf('L'), ItemTagsCoFH.GEARS_LEAD).m_126127_(Character.valueOf('X'), (ItemLike)rfCoil).m_126130_(" L ").m_126130_("EXE").m_126130_(" L ").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_MACHINE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("machine_efficiency_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('L'), ItemTagsCoFH.PLATES_LUMIUM).m_206416_(Character.valueOf('N'), ItemTagsCoFH.GEARS_NICKEL).m_126127_(Character.valueOf('X'), (ItemLike)rfCoil).m_126130_(" N ").m_126130_("LXL").m_126130_(" N ").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_MACHINE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("machine_output_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('B'), ItemTagsCoFH.GEARS_BRONZE).m_206416_(Character.valueOf('I'), ItemTagsCoFH.PLATES_INVAR).m_126127_(Character.valueOf('X'), (ItemLike)redstoneServo).m_126130_(" B ").m_126130_("IXI").m_126130_(" B ").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_MACHINE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("machine_catalyst_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('C'), ItemTagsCoFH.GEARS_CONSTANTAN).m_206416_(Character.valueOf('L'), ItemTagsCoFH.PLATES_LEAD).m_126127_(Character.valueOf('X'), (ItemLike)redstoneServo).m_126130_(" C ").m_126130_("LXL").m_126130_(" C ").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_MACHINE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("machine_cycle_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('C'), ItemTagsCoFH.PLATES_CONSTANTAN).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_SIGNALUM).m_206416_(Character.valueOf('S'), ItemTagsCoFH.PLATES_SILVER).m_126127_(Character.valueOf('X'), (ItemLike)redstoneServo).m_126130_("SGS").m_126130_("CXC").m_126130_("SGS").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_MACHINE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("machine_null_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41982_).m_126130_(" i ").m_126130_("iCi").m_126130_(" i ").m_142284_("has_cactus", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_41982_)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_MACHINE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("potion_amplifier_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_SIGNALUM).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_BRONZE).m_206416_(Character.valueOf('X'), ThermalTags.Items.HARDENED_GLASS).m_126130_(" G ").m_126130_("IXI").m_126130_(" G ").m_142284_("has_hardened_glass", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_(ThermalTags.Items.HARDENED_GLASS)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_POTION_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("potion_duration_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_LUMIUM).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_BRONZE).m_206416_(Character.valueOf('X'), ThermalTags.Items.HARDENED_GLASS).m_126130_(" G ").m_126130_("IXI").m_126130_(" G ").m_142284_("has_hardened_glass", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_(ThermalTags.Items.HARDENED_GLASS)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_POTION_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("rf_coil_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('S'), ItemTagsCoFH.INGOTS_SILVER).m_126127_(Character.valueOf('X'), (ItemLike)rfCoil).m_126130_(" G ").m_126130_("SXS").m_126130_(" G ").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_STORAGE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("rf_coil_storage_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('S'), ItemTagsCoFH.INGOTS_SILVER).m_126127_(Character.valueOf('X'), (ItemLike)rfCoil).m_126130_(" S ").m_126130_("GXG").m_126130_(" G ").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_STORAGE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("rf_coil_xfer_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('S'), ItemTagsCoFH.INGOTS_SILVER).m_126127_(Character.valueOf('X'), (ItemLike)rfCoil).m_126130_(" S ").m_126130_("SXS").m_126130_(" G ").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_STORAGE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("fluid_tank_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('R'), (ItemLike)ThermalCore.ITEMS.get("cured_rubber")).m_206416_(Character.valueOf('X'), ThermalTags.Items.HARDENED_GLASS).m_126130_("RIR").m_126130_("IXI").m_126130_("RIR").m_142284_("has_hardened_glass", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_(ThermalTags.Items.HARDENED_GLASS)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_STORAGE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("upgrade_augment_1");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_INVAR).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_GOLD).m_126130_("IGI").m_126130_("RXR").m_126130_("IGI").m_142284_("has_invar_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_INVAR)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_UPGRADE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("upgrade_augment_2");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), Tags.Items.GEMS_QUARTZ).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_ELECTRUM).m_206416_(Character.valueOf('R'), ItemTagsCoFH.GEARS_SIGNALUM).m_126127_(Character.valueOf('X'), (ItemLike)reg.get("upgrade_augment_1")).m_126130_("IGI").m_126130_("RXR").m_126130_("IGI").m_142284_("has_electrum_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_ELECTRUM)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_UPGRADE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("upgrade_augment_3");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), ThermalTags.Items.HARDENED_GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_ENDERIUM).m_206416_(Character.valueOf('R'), ItemTagsCoFH.GEARS_LUMIUM).m_126127_(Character.valueOf('X'), (ItemLike)reg.get("upgrade_augment_2")).m_126130_("IGI").m_126130_("RXR").m_126130_("IGI").m_142284_("has_enderium_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_ENDERIUM)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_UPGRADE_AUGMENTS), this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("rs_control_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_206416_(Character.valueOf('r'), Tags.Items.DUSTS_REDSTONE).m_126130_(" i ").m_126130_("iri").m_126130_(" i ").m_142284_("has_redstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("side_config_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('i'), ItemTagsCoFH.NUGGETS_TIN).m_206416_(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).m_126130_(" i ").m_126130_("iGi").m_126130_(" i ").m_142284_("has_gold_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_GOLD)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("xp_storage_augment");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_GOLD).m_126127_(Character.valueOf('C'), (ItemLike)reg.get("xp_crystal")).m_126130_(" i ").m_126130_("iCi").m_126130_(" i ").m_142284_("has_crystal", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("xp_crystal")))).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
    }

    private void generateBasicRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        String folder = "tools";
        Item result = (Item)reg.get("wrench");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_IRON).m_126130_("I I").m_126130_(" G ").m_126130_(" I ").m_142284_("has_iron_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("redprint");
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)Items.f_42516_).m_126209_((ItemLike)Items.f_42516_).m_206419_(Tags.Items.DUSTS_REDSTONE).m_206419_(Tags.Items.DUSTS_REDSTONE).m_142284_("has_redstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("lock");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('i'), Tags.Items.NUGGETS_IRON).m_206416_(Character.valueOf('S'), ItemTagsCoFH.INGOTS_SIGNALUM).m_126130_(" i ").m_126130_("iSi").m_126130_("iii").m_142284_("has_signalum_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_SIGNALUM)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("satchel");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_TIN).m_206416_(Character.valueOf('L'), Tags.Items.LEATHER).m_206416_(Character.valueOf('W'), ThermalTags.Items.ROCKWOOL).m_126130_("LWL").m_126130_("WIW").m_126130_("LWL").m_142284_("has_leather", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.LEATHER)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("detonator");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('G'), ItemTagsCoFH.GEARS_SIGNALUM).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('S'), ItemTagsCoFH.INGOTS_SILVER).m_126130_(" S ").m_126130_("IGI").m_126130_("III").m_142284_("has_signalum_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_SIGNALUM)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("rf_potato");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_206416_(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('L'), ItemTagsCoFH.NUGGETS_LEAD).m_206416_(Character.valueOf('P'), Tags.Items.CROPS_POTATO).m_126127_(Character.valueOf('R'), (ItemLike)reg.get("cured_rubber")).m_126130_("LDL").m_126130_("RPR").m_126130_("DLD").m_142284_("has_potato", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.CROPS_POTATO)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        result = (Item)reg.get("xp_crystal");
        ShapedRecipeBuilder.m_126116_((ItemLike)result).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42612_).m_206416_(Character.valueOf('E'), Tags.Items.GEMS_EMERALD).m_206416_(Character.valueOf('L'), Tags.Items.GEMS_LAPIS).m_126130_(" L ").m_126130_("EBE").m_126130_(" L ").m_142284_("has_experience_bottle", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42612_)).m_176500_(consumer, this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result));
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("phytogro")), (int)8).m_206419_(Tags.Items.SAND).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_APATITE, ItemTagsCoFH.DUSTS_APATITE})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_APATITE, ItemTagsCoFH.DUSTS_APATITE})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_NITER, ItemTagsCoFH.DUSTS_NITER})).m_142284_("has_apatite", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.GEMS_APATITE)).m_176500_(consumer, "thermal:phytogro_8");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("phytogro")), (int)4).m_206419_(Tags.Items.SAND).m_126209_((ItemLike)Items.f_42499_).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_APATITE, ItemTagsCoFH.DUSTS_APATITE})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_NITER, ItemTagsCoFH.DUSTS_NITER})).m_142284_("has_apatite", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.GEMS_APATITE)).m_176500_(consumer, "thermal:phytogro_4");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("phytogro")), (int)2).m_206419_(Tags.Items.SAND).m_126209_((ItemLike)Items.f_42499_).m_126209_((ItemLike)reg.get("rich_slag")).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_NITER, ItemTagsCoFH.DUSTS_NITER})).m_142284_("rich_slag", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("rich_slag")))).m_176500_(consumer, "thermal:phytogro_2");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("junk_net")), (int)1).m_206416_(Character.valueOf('#'), Tags.Items.STRING).m_206416_(Character.valueOf('n'), Tags.Items.NUGGETS_IRON).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("n#n").m_126130_("#S#").m_126130_("n#n").m_142284_("has_string", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.STRING)).m_176498_((Consumer)this.withConditions(consumer).flag("device_fisher"));
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("aquachow")), (int)4).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42518_).m_142284_("has_wheat", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.CROPS_WHEAT)).m_176500_((Consumer)this.withConditions(consumer).flag("device_fisher"), "thermal:aquachow_4");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("deep_aquachow")), (int)4).m_126209_((ItemLike)Items.f_42405_).m_126209_((ItemLike)Items.f_42732_).m_126209_((ItemLike)Items.f_42518_).m_206419_(ItemTagsCoFH.NUGGETS_LEAD).m_142284_("has_beetroot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.CROPS_BEETROOT)).m_176500_((Consumer)this.withConditions(consumer).flag("device_fisher"), "thermal:deep_aquachow_4");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("basalz_powder")), (int)2).m_126209_((ItemLike)reg.get("basalz_rod")).m_142284_("has_basalz_rod", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("basalz_rod")))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("blitz_powder")), (int)2).m_126209_((ItemLike)reg.get("blitz_rod")).m_142284_("has_blitz_rod", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blitz_rod")))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("blizz_powder")), (int)2).m_126209_((ItemLike)reg.get("blizz_rod")).m_142284_("has_blizz_rod", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blizz_rod")))).m_176498_(consumer);
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42492_).m_206419_(ItemTagsCoFH.GEMS_APATITE).m_142284_("has_apatite", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.GEMS_APATITE)).m_176500_(consumer, "thermal:cyan_dye_from_apatite");
        ShapelessRecipeBuilder.m_126191_((ItemLike)((ItemLike)reg.get("rubber")), (int)3).m_126209_((ItemLike)reg.get("latex_bucket")).m_142284_("latex_bucket", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("latex_bucket")))).m_176500_(consumer, "thermal:rubber_3");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("rubber")), (int)1).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42447_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_41939_).m_126130_("###").m_126130_("#B#").m_126130_("###").m_142284_("has_dandelion", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_41939_)).m_176500_(consumer, "thermal:rubber_from_dandelion");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("rubber")), (int)1).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42447_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42029_).m_126130_("###").m_126130_("#B#").m_126130_("###").m_142284_("has_vine", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42029_)).m_176500_(consumer, "thermal:rubber_from_vine");
        ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50493_).m_126209_((ItemLike)reg.get("compost")).m_206419_(Tags.Items.SAND).m_206419_(ThermalTags.Items.SLAG).m_142284_("has_compost", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("compost")))).m_176500_(consumer, "thermal:dirt_crafting");
        ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50599_).m_126209_((ItemLike)reg.get("compost")).m_206419_(ItemTags.f_13143_).m_206419_(Tags.Items.SAND).m_206419_(ThermalTags.Items.SLAG).m_142284_("has_compost", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("compost")))).m_176500_(consumer, "thermal:podzol_crafting");
        ShapelessRecipeBuilder.m_126189_((ItemLike)Blocks.f_50195_).m_126209_((ItemLike)reg.get("compost")).m_206419_(Tags.Items.MUSHROOMS).m_206419_(Tags.Items.SAND).m_206419_(ThermalTags.Items.SLAG).m_142284_("has_compost", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("compost")))).m_176500_(consumer, "thermal:mycelium_crafting");
    }

    private void generateChargeRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        Item earthCharge = (Item)reg.get("earth_charge");
        Item iceCharge = (Item)reg.get("ice_charge");
        Item lightningCharge = (Item)reg.get("lightning_charge");
        ShapelessRecipeBuilder.m_126191_((ItemLike)earthCharge, (int)3).m_206419_(Tags.Items.GUNPOWDER).m_126209_((ItemLike)reg.get("basalz_powder")).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_})).m_142284_("has_basalz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("basalz_powder")))).m_176500_(consumer, "thermal:earth_charge_3");
        ShapelessRecipeBuilder.m_126191_((ItemLike)iceCharge, (int)3).m_206419_(Tags.Items.GUNPOWDER).m_126209_((ItemLike)reg.get("blizz_powder")).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_})).m_142284_("has_blizz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blizz_powder")))).m_176500_(consumer, "thermal:ice_charge_3");
        ShapelessRecipeBuilder.m_126191_((ItemLike)lightningCharge, (int)3).m_206419_(Tags.Items.GUNPOWDER).m_126209_((ItemLike)reg.get("blitz_powder")).m_126184_(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_})).m_142284_("has_blitz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blitz_powder")))).m_176500_(consumer, "thermal:lightning_charge_3");
        ShapelessRecipeBuilder.m_126191_((ItemLike)Items.f_42695_, (int)4).m_126209_((ItemLike)Items.f_42192_).m_126209_((ItemLike)earthCharge).m_142284_("has_prismarine", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42192_)).m_176500_(consumer, "thermal:earth_charge/prismarine_shard_from_prismarine");
        ShapelessRecipeBuilder.m_126191_((ItemLike)Items.f_42695_, (int)9).m_126209_((ItemLike)Items.f_42193_).m_126209_((ItemLike)earthCharge).m_142284_("has_prismarine_bricks", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42193_)).m_176500_(consumer, "thermal:earth_charge/prismarine_shard_from_prismarine_bricks");
        ShapelessRecipeBuilder.m_126191_((ItemLike)Items.f_42692_, (int)4).m_126209_((ItemLike)Items.f_42157_).m_126209_((ItemLike)earthCharge).m_142284_("has_quartz_block", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42157_)).m_176500_(consumer, "thermal:earth_charge/quartz_from_quartz_block");
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)reg.get("diamond_dust"))).m_206419_(Tags.Items.GEMS_DIAMOND).m_126209_((ItemLike)earthCharge).m_142284_("has_diamond", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_176500_(consumer, "thermal:earth_charge/diamond_dust_from_diamond");
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)reg.get("emerald_dust"))).m_206419_(Tags.Items.GEMS_EMERALD).m_126209_((ItemLike)earthCharge).m_142284_("has_emerald", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_EMERALD)).m_176500_(consumer, "thermal:earth_charge/emerald_dust_from_emerald");
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)reg.get("ender_pearl_dust"))).m_206419_(Tags.Items.ENDER_PEARLS).m_126209_((ItemLike)earthCharge).m_142284_("has_ender_pearl", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.ENDER_PEARLS)).m_176500_(consumer, "thermal:earth_charge/ender_pearl_dust_from_ender_pearl");
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)reg.get("lapis_dust"))).m_206419_(Tags.Items.GEMS_LAPIS).m_126209_((ItemLike)earthCharge).m_142284_("has_lapis", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_LAPIS)).m_176500_(consumer, "thermal:earth_charge/lapis_dust_from_lapis");
        ShapelessRecipeBuilder.m_126189_((ItemLike)((ItemLike)reg.get("quartz_dust"))).m_206419_(Tags.Items.GEMS_QUARTZ).m_126209_((ItemLike)earthCharge).m_142284_("has_quartz", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_QUARTZ)).m_176500_(consumer, "thermal:earth_charge/quartz_dust_from_quartz");
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_41999_).m_126209_((ItemLike)Items.f_42448_).m_126209_((ItemLike)iceCharge).m_142284_("has_lava_bucket", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42448_)).m_176500_(consumer, "thermal:ice_charge/obsidian_from_lava_bucket");
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_41980_).m_126209_((ItemLike)Items.f_42447_).m_126209_((ItemLike)iceCharge).m_142284_("has_water_bucket", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42447_)).m_176500_(consumer, "thermal:ice_charge/ice_from_water_bucket");
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42604_).m_126209_((ItemLike)Items.f_42601_).m_126209_((ItemLike)lightningCharge).m_142284_("has_villager_spawn_egg", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42601_)).m_176500_(consumer, "thermal:lightning_charge/witch_from_villager");
        ShapelessRecipeBuilder.m_126189_((ItemLike)Items.f_42611_).m_126209_((ItemLike)Items.f_42630_).m_126209_((ItemLike)lightningCharge).m_142284_("has_pig_spawn_egg", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42630_)).m_176500_(consumer, "thermal:lightning_charge/zombified_piglin_from_pig");
    }

    private void generateComponentRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("redstone_servo"))).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126130_(" R ").m_126130_(" I ").m_126130_(" R ").m_142284_("has_redstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("rf_coil"))).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126130_("  R").m_126130_(" I ").m_126130_("R  ").m_142284_("has_redstone_dust", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176498_(consumer);
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("drill_head"))).m_206416_(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126130_(" I ").m_126130_("ICI").m_126130_("III").m_142284_("has_iron_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_TOOL_COMPONENTS));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("saw_blade"))).m_206416_(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126130_("II ").m_126130_("ICI").m_126130_(" II").m_142284_("has_iron_ingot", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_TOOL_COMPONENTS));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("machine_frame"))).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('T'), ItemTagsCoFH.GEARS_TIN).m_126130_("IGI").m_126130_("GTG").m_126130_("IGI").m_142284_("has_tin", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_TIN)).m_176498_((Consumer)this.withConditions(consumer).flag("machine_frame"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("energy_cell_frame"))).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_LEAD).m_206416_(Character.valueOf('E'), ItemTagsCoFH.GEARS_ELECTRUM).m_126130_("IGI").m_126130_("GEG").m_126130_("IGI").m_142284_("has_lead", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_LEAD)).m_176498_((Consumer)this.withConditions(consumer).flag("energy_cell_frame"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("fluid_cell_frame"))).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_BRONZE).m_206416_(Character.valueOf('E'), ItemTagsCoFH.GEARS_IRON).m_126130_("IGI").m_126130_("GEG").m_126130_("IGI").m_142284_("has_bronze", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)ItemTagsCoFH.INGOTS_BRONZE)).m_176498_((Consumer)this.withConditions(consumer).flag("fluid_cell_frame"));
    }

    private void generateExplosiveRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        ShapelessRecipeBuilder.m_126191_((ItemLike)Items.f_42403_, (int)4).m_126209_((ItemLike)Items.f_42414_).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_NITER, ItemTagsCoFH.DUSTS_NITER})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_NITER, ItemTagsCoFH.DUSTS_NITER})).m_126184_(this.fromTags(new TagKey[]{ItemTagsCoFH.GEMS_SULFUR, ItemTagsCoFH.DUSTS_SULFUR})).m_142284_("has_gunpowder", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.GUNPOWDER)).m_176500_(consumer, "thermal:gunpowder_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("explosive_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), Tags.Items.SAND).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_gunpowder", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.GUNPOWDER)).m_176500_(consumer, "thermal:explosive_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("slime_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), Tags.Items.SLIMEBALLS).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_slimeball", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.SLIMEBALLS)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES), "thermal:slime_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("redstone_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), Tags.Items.DUSTS_REDSTONE).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_redstone", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES), "thermal:redstone_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("glowstone_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), Tags.Items.DUSTS_GLOWSTONE).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_glowstone", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_GLOWSTONE)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES), "thermal:glowstone_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("ender_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('P'), Tags.Items.ENDER_PEARLS).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_ender_pearl", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.ENDER_PEARLS)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES), "thermal:ender_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("phyto_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("phytogro")).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_phytogro", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("phytogro")))).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_PHYTOGRO_EXPLOSIVES), "thermal:phyto_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("earth_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("basalz_powder")).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_basalz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("basalz_powder")))).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES), "thermal:earth_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("fire_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42593_).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_blaze_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42593_)).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES), "thermal:fire_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("ice_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("blizz_powder")).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_blizz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blizz_powder")))).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES), "thermal:ice_grenade_4");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("lightning_grenade")), (int)4).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("blitz_powder")).m_126130_("GPG").m_126130_("PIP").m_126130_("GPG").m_142284_("has_blitz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blitz_powder")))).m_176500_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES), "thermal:lightning_grenade_4");
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("slime_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('P'), Tags.Items.SLIMEBALLS).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_slimeball", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.SLIMEBALLS)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("redstone_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('P'), Tags.Items.DUSTS_REDSTONE).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_redstone", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_REDSTONE)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("glowstone_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('P'), Tags.Items.DUSTS_GLOWSTONE).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_glowstone", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_GLOWSTONE)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("ender_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_206416_(Character.valueOf('P'), Tags.Items.ENDER_PEARLS).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_ender_pearl", (CriterionTriggerInstance)TCoreRecipeProvider.m_206406_((TagKey)Tags.Items.ENDER_PEARLS)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("phyto_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("phytogro")).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_phytogro", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("phytogro")))).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_PHYTOGRO_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("earth_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("basalz_powder")).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_basalz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("basalz_powder")))).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("fire_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42593_).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_blaze_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)Items.f_42593_)).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("ice_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("blizz_powder")).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_blizz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blizz_powder")))).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("lightning_tnt"))).m_206416_(Character.valueOf('G'), Tags.Items.GUNPOWDER).m_126127_(Character.valueOf('P'), (ItemLike)reg.get("blitz_powder")).m_126130_("GPG").m_126130_("PGP").m_126130_("GPG").m_142284_("has_blitz_powder", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("blitz_powder")))).m_176498_((Consumer)this.withConditions(consumer).flag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
    }

    private void generateRockwoolRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        Item rockwool = (Item)reg.get("white_rockwool");
        String folder = "rockwool";
        this.generateSmeltingAndBlastingRecipes(reg, consumer, (Item)reg.get("slag"), rockwool, 0.1f, "rockwool");
        Item result = (Item)reg.get("orange_rockwool");
        String recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_ORANGE).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("magenta_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_MAGENTA).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("light_blue_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_LIGHT_BLUE).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("yellow_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_YELLOW).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("lime_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_LIME).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("pink_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_PINK).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("gray_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_GRAY).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("light_gray_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_LIGHT_GRAY).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("cyan_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_CYAN).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("purple_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_PURPLE).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("blue_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_BLUE).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("brown_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_BROWN).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("green_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_GREEN).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("red_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_RED).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
        result = (Item)reg.get("black_rockwool");
        recipeId = this.modid + ":" + folder + "/" + TCoreRecipeProvider.name((Item)result) + "_from_dye";
        ShapelessRecipeBuilder.m_126189_((ItemLike)result).m_126209_((ItemLike)rockwool).m_206419_(Tags.Items.DYES_BLACK).m_142284_("has_" + TCoreRecipeProvider.name((Item)rockwool), (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rockwool)).m_176500_(consumer, recipeId);
    }

    private void generateSlagRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        this.generateSmeltingRecipe(reg, consumer, (Item)reg.get("slag_block"), (Item)reg.get("polished_slag"), 0.1f, "smelting");
        this.generateSmeltingRecipe(reg, consumer, (Item)reg.get("rich_slag_block"), (Item)reg.get("polished_rich_slag"), 0.1f, "smelting");
        this.generateSmeltingRecipe(reg, consumer, (Item)reg.get("slag_bricks"), (Item)reg.get("cracked_slag_bricks"), 0.1f, "smelting");
        this.generateSmeltingRecipe(reg, consumer, (Item)reg.get("rich_slag_bricks"), (Item)reg.get("cracked_rich_slag_bricks"), 0.1f, "smelting");
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("slag_bricks")), (int)4).m_126127_(Character.valueOf('#'), (ItemLike)reg.get("polished_slag")).m_126130_("##").m_126130_("##").m_142284_("has_slag", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("slag")))).m_176498_(consumer);
        ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)reg.get("rich_slag_bricks")), (int)4).m_126127_(Character.valueOf('#'), (ItemLike)reg.get("polished_rich_slag")).m_126130_("##").m_126130_("##").m_142284_("has_rich_slag", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)((ItemLike)reg.get("rich_slag")))).m_176498_(consumer);
        this.generateStonecuttingRecipe(reg, consumer, (Item)reg.get("polished_slag"), (Item)reg.get("chiseled_slag"), "stonecutting");
        this.generateStonecuttingRecipe(reg, consumer, (Item)reg.get("polished_rich_slag"), (Item)reg.get("chiseled_rich_slag"), "stonecutting");
    }

    private void generateTileRecipes(Consumer<FinishedRecipe> consumer) {
        DeferredRegisterCoFH<Item> reg = ThermalCore.ITEMS;
        Item energyCellFrame = (Item)reg.get("energy_cell_frame");
        Item fluidCellFrame = (Item)reg.get("fluid_cell_frame");
        Item redstoneServo = (Item)reg.get("redstone_servo");
        Item rfCoil = (Item)reg.get("rf_coil");
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_hive_extractor"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42574_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTags.f_13168_).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_IRON).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_hive_extractor"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_tree_extractor"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42446_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTags.f_13168_).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_IRON).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_tree_extractor"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_fisher"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42523_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTags.f_13168_).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_BRONZE).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_fisher"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_composter"))).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50715_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTags.f_13168_).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_IRON).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_composter"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_soil_infuser"))).m_126127_(Character.valueOf('C'), (ItemLike)reg.get("phytogro")).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTags.f_13168_).m_126127_(Character.valueOf('P'), (ItemLike)rfCoil).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_LUMIUM).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176498_((Consumer)this.withConditions(consumer).flag("device_soil_infuser"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_rock_gen"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_41869_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_INVAR).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_CONSTANTAN).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_rock_gen"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_water_gen"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42446_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_BRONZE).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), Tags.Items.INGOTS_IRON).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_water_gen"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_collector"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42155_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_TIN).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), Tags.Items.ENDER_PEARLS).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_collector"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_magnet_blocker"))).m_206416_(Character.valueOf('C'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_TIN).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_LEAD).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_magnet_blocker"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_nullifier"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42448_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_TIN).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), Tags.Items.DUSTS_REDSTONE).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_nullifier"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("device_potion_diffuser"))).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42590_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_SILVER).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_206416_(Character.valueOf('X'), ItemTagsCoFH.GEARS_CONSTANTAN).m_126130_("IXI").m_126130_("GCG").m_126130_("IPI").m_142284_("has_redstone_servo", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)redstoneServo)).m_176498_((Consumer)this.withConditions(consumer).flag("device_potion_diffuser"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("energy_cell"))).m_126127_(Character.valueOf('C'), (ItemLike)energyCellFrame).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)rfCoil).m_126127_(Character.valueOf('R'), (ItemLike)reg.get("cured_rubber")).m_206416_(Character.valueOf('X'), Tags.Items.STORAGE_BLOCKS_REDSTONE).m_126130_("RXR").m_126130_("ICI").m_126130_("RPR").m_142284_("has_energy_cell_frame", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)energyCellFrame)).m_176498_((Consumer)this.withConditions(consumer).flag("energy_cell"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("fluid_cell"))).m_126127_(Character.valueOf('C'), (ItemLike)fluidCellFrame).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)redstoneServo).m_126127_(Character.valueOf('R'), (ItemLike)reg.get("cured_rubber")).m_206416_(Character.valueOf('X'), ThermalTags.Items.HARDENED_GLASS).m_126130_("RXR").m_126130_("ICI").m_126130_("RPR").m_142284_("has_fluid_cell_frame", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)fluidCellFrame)).m_176498_((Consumer)this.withConditions(consumer).flag("fluid_cell"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("tinker_bench"))).m_126127_(Character.valueOf('C'), (ItemLike)Blocks.f_50091_).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('P'), (ItemLike)rfCoil).m_206416_(Character.valueOf('X'), ItemTags.f_13168_).m_126130_("III").m_126130_("GCG").m_126130_("XPX").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176498_((Consumer)this.withConditions(consumer).flag("tinker_bench"));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)reg.get("charge_bench"))).m_206416_(Character.valueOf('C'), Tags.Items.STORAGE_BLOCKS_REDSTONE).m_206416_(Character.valueOf('I'), ItemTagsCoFH.INGOTS_ELECTRUM).m_126127_(Character.valueOf('P'), (ItemLike)rfCoil).m_206416_(Character.valueOf('X'), ItemTagsCoFH.INGOTS_LEAD).m_126130_("III").m_126130_("PCP").m_126130_("XPX").m_142284_("has_rf_coil", (CriterionTriggerInstance)TCoreRecipeProvider.m_125977_((ItemLike)rfCoil)).m_176498_((Consumer)this.withConditions(consumer).flag("charge_bench"));
    }
}

