/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.event;

import cofh.core.util.ProxyClient;
import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.item.WrenchItem;
import cofh.thermal.lib.common.ThermalAugmentRules;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="thermal")
public class TCoreClientEvents {
    private TCoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (AugmentDataHelper.hasAugmentData((ItemStack)stack)) {
            CompoundTag augmentData = AugmentDataHelper.getAugmentData((ItemStack)stack);
            if (augmentData == null || augmentData.m_128456_()) {
                return;
            }
            String type = augmentData.m_128461_("Type");
            if (!type.isEmpty()) {
                MutableComponent typeText = StringHelper.getTextComponent((String)("info.thermal.augment.type." + type)).m_130940_(ChatFormatting.WHITE);
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.type").m_130940_(ChatFormatting.YELLOW).m_130946_(": ").m_7220_((Component)typeText));
            }
            for (String mod : augmentData.m_128431_()) {
                if (mod.equals("Type") || !StringHelper.canLocalize((String)("info.thermal.augment.attr." + mod))) continue;
                float value = augmentData.m_128457_(mod);
                boolean bad = ThermalAugmentRules.isAdditive(mod) && value < 0.0f || ThermalAugmentRules.isAdditive(mod) && value > 0.0f && ThermalAugmentRules.isInverse(mod) || ThermalAugmentRules.isMultiplicative(mod) && (ThermalAugmentRules.isInverse(mod) ? (double)value > 1.0 : (double)value < 1.0);
                MutableComponent modText = new TextComponent((ThermalAugmentRules.isAdditive(mod) && value > 0.0f ? "+" : "") + (String)(ThermalAugmentRules.isInteger(mod) ? StringHelper.DF0.format(value) : (ThermalAugmentRules.isMultiplicative(mod) ? StringHelper.DF2.format(value) + "x" : StringHelper.DF0.format(value * 100.0f) + "%"))).m_130940_(bad ? ChatFormatting.RED : ChatFormatting.GREEN);
                if (ThermalAugmentRules.isMaximized(mod)) {
                    modText.m_130940_(ChatFormatting.UNDERLINE);
                }
                tooltip.add(StringHelper.getTextComponent((String)("info.thermal.augment.attr." + mod)).m_130946_(": ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)modText));
            }
        }
    }

    @SubscribeEvent
    public static void handleRenderWorldLast(RenderLevelLastEvent event) {
        Item heldItem;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (heldItem = player.m_21205_().m_41720_()) instanceof WrenchItem && ((WrenchItem)heldItem).getMode(player.m_21205_()) > 0) {
            TCoreClientEvents.renderOperationalAreas(player, event.getPoseStack());
        }
    }

    private static boolean playerWithinDistance(BlockPos pos, Player player, double distanceSq) {
        return pos.m_203193_((Position)player.m_20182_()) <= distanceSq;
    }

    private static void line(VertexConsumer builder, Matrix4f positionMatrix, BlockPos pos, float dx1, float dy1, float dz1, float dx2, float dy2, float dz2, int r, int g, int b, int a) {
        builder.m_85982_(positionMatrix, (float)pos.m_123341_() + dx1, (float)pos.m_123342_() + dy1, (float)pos.m_123343_() + dz1).m_6122_(r, g, b, a).m_5752_();
        builder.m_85982_(positionMatrix, (float)pos.m_123341_() + dx2, (float)pos.m_123342_() + dy2, (float)pos.m_123343_() + dz2).m_6122_(r, g, b, a).m_5752_();
    }

    private static void box(VertexConsumer builder, Matrix4f positionMatrix, BlockPos pos, AABB area, int color) {
        float lenX = (float)(area.f_82291_ - area.f_82288_);
        float lenY = (float)(area.f_82292_ - area.f_82289_);
        float lenZ = (float)(area.f_82293_ - area.f_82290_);
        int a = 192;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, 0.0f, lenX, 0.0f, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, lenY, 0.0f, lenX, lenY, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, lenZ, lenX, 0.0f, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, lenY, lenZ, lenX, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, 0.0f, 0.0f, lenX, 0.0f, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, lenY, 0.0f, 0.0f, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, lenY, 0.0f, lenX, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, 0.0f, 0.0f, lenY, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, 0.0f, 0.0f, lenX, lenY, 0.0f, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, 0.0f, 0.0f, lenZ, 0.0f, lenY, lenZ, r, g, b, a);
        TCoreClientEvents.line(builder, positionMatrix, pos, lenX, 0.0f, lenZ, lenX, lenY, lenZ, r, g, b, a);
    }

    private static void renderOperationalAreas(LocalPlayer player, PoseStack matrixStack) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(RenderTypes.OVERLAY_LINES);
        matrixStack.m_85836_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        Matrix4f positionMatrix = matrixStack.m_85850_().m_85861_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (IAreaEffectTile tile : ProxyClient.getAreaEffectTiles()) {
            if (!tile.canPlayerAccess((Player)player) || !TCoreClientEvents.playerWithinDistance(tile.pos(), (Player)player, 1024.0)) continue;
            AABB area = tile.getArea();
            pos.m_122169_(area.f_82288_, area.f_82289_, area.f_82290_);
            TCoreClientEvents.box(builder, positionMatrix, (BlockPos)pos, area, tile.getColor());
        }
        matrixStack.m_85849_();
        RenderSystem.m_69465_();
        buffer.m_109912_(RenderTypes.OVERLAY_LINES);
    }
}

