/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.init.CoreMobEffects;
import cofh.core.item.IMultiModeItem;
import cofh.core.item.ItemCoFH;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.api.block.IDismantleable;
import cofh.lib.api.block.IWrenchable;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class WrenchItem
extends ItemCoFH
implements IMultiModeItem {
    private final Multimap<Attribute, AttributeModifier> toolAttributes;

    public WrenchItem(Item.Properties builder) {
        super(builder);
        ImmutableMultimap.Builder multimap = ImmutableMultimap.builder();
        multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 0.0, AttributeModifier.Operation.ADDITION));
        this.toolAttributes = multimap.build();
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.wrench.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    protected boolean useDelegate(ItemStack stack, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (player == null || world.m_46859_(pos)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (player.m_36341_() && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(world, pos, state, player)) {
            if (Utils.isServerWorld((Level)world)) {
                BlockHitResult target = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
                ((IDismantleable)block).dismantleBlock(world, pos, state, (HitResult)target, player, false);
            }
            player.m_6674_(context.m_43724_());
            return true;
        }
        if (!player.m_36341_()) {
            if (block instanceof IWrenchable && ((IWrenchable)block).canWrench(world, pos, state, player)) {
                BlockHitResult target = new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_());
                ((IWrenchable)block).wrenchBlock(world, pos, state, (HitResult)target, player);
                return true;
            }
            return BlockHelper.attemptRotateBlock((BlockState)state, (Level)world, (BlockPos)pos);
        }
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.WRENCHED.get(), 60, 0, false, false));
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        return player.m_36204_(context.m_8083_(), context.m_43719_(), context.m_43722_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        return player.m_36204_(context.m_8083_(), context.m_43719_(), stack) && this.useDelegate(stack, context) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.toolAttributes : ImmutableMultimap.of();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack((ItemLike)this);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_142538_(), SoundEvents.f_11897_, SoundSource.PLAYERS, 0.4f, (this.isActive(stack) ? 0.7f : 0.5f) + 0.1f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((Player)player, (Component)new TranslatableComponent("info.thermal.wrench.mode." + this.getMode(stack)));
    }
}

