/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.device;

import cofh.core.init.CoreFluids;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.device.HiveExtractorMapping;
import cofh.thermal.lib.util.managers.AbstractManager;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class HiveExtractorManager
extends AbstractManager {
    private static final int COMB_AMOUNT = 2;
    private static final int HONEY_AMOUNT = 250;
    private static final HiveExtractorManager INSTANCE = new HiveExtractorManager();
    protected IdentityHashMap<Block, Pair<ItemStack, FluidStack>> hiveMap = new IdentityHashMap();

    public static HiveExtractorManager instance() {
        return INSTANCE;
    }

    protected void clear() {
        this.hiveMap.clear();
    }

    public boolean specificHive(BlockState hive) {
        return this.hiveMap.containsKey(hive.m_60734_());
    }

    public ItemStack getItem(BlockState hive) {
        return this.specificHive(hive) ? ItemHelper.cloneStack((ItemStack)((ItemStack)this.hiveMap.get(hive.m_60734_()).getLeft())) : ItemHelper.cloneStack((Item)Items.f_42784_, (int)2);
    }

    public FluidStack getFluid(BlockState hive) {
        return this.specificHive(hive) ? (FluidStack)this.hiveMap.get(hive.m_60734_()).getRight() : new FluidStack((Fluid)CoreFluids.HONEY_FLUID.get(), 250);
    }

    public void addMapping(HiveExtractorMapping mapping) {
        if (mapping.getHive() == Blocks.f_50016_ || mapping.getItem().m_41619_() && mapping.getFluid().isEmpty()) {
            return;
        }
        this.hiveMap.put(mapping.getHive(), (Pair<ItemStack, FluidStack>)Pair.of((Object)mapping.getItem(), (Object)mapping.getFluid()));
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map mappings = recipeManager.m_44054_(TCoreRecipeTypes.MAPPING_HIVE_EXTRACTOR);
        for (Map.Entry entry : mappings.entrySet()) {
            this.addMapping((HiveExtractorMapping)((Object)entry.getValue()));
        }
    }
}

