/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.managers.dynamo;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.util.recipes.dynamo.StirlingFuel;
import cofh.thermal.lib.util.managers.SingleItemFuelManager;
import cofh.thermal.lib.util.recipes.ThermalFuel;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class StirlingFuelManager
extends SingleItemFuelManager {
    private static final StirlingFuelManager INSTANCE = new StirlingFuelManager();
    protected static final int DEFAULT_ENERGY = 16000;
    protected List<StirlingFuel> convertedFuels = new ArrayList<StirlingFuel>();

    public static StirlingFuelManager instance() {
        return INSTANCE;
    }

    private StirlingFuelManager() {
        super(16000);
    }

    @Override
    public boolean validFuel(ItemStack input) {
        if (input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        return this.getEnergy(input) > 0;
    }

    @Override
    protected void clear() {
        this.fuelMap.clear();
        this.convertedFuels.clear();
    }

    public int getEnergy(ItemStack stack) {
        IDynamoFuel fuel = this.getFuel(stack);
        return fuel != null ? fuel.getEnergy() : this.getEnergyFurnaceFuel(stack);
    }

    public int getEnergyFurnaceFuel(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_().hasContainerItem(stack)) {
            return 0;
        }
        int energy = ForgeHooks.getBurnTime((ItemStack)stack, null) * 10;
        return energy >= 1000 ? energy : 0;
    }

    @Override
    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.m_44054_(TCoreRecipeTypes.FUEL_STIRLING);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addFuel((ThermalFuel)((Object)entry.getValue()));
        }
        this.createConvertedRecipes(recipeManager);
    }

    public List<StirlingFuel> getConvertedFuels() {
        return this.convertedFuels;
    }

    protected void createConvertedRecipes(RecipeManager recipeManager) {
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack query = new ItemStack((ItemLike)item);
            try {
                if (this.getFuel(query) != null || !this.validFuel(query)) continue;
                this.convertedFuels.add(this.convert(query, this.getEnergy(query)));
            }
            catch (Exception e) {
                ThermalCore.LOG.error(query.m_41720_().getRegistryName() + " threw an exception when querying the fuel value as the mod author is doing non-standard things in their item code (possibly tag related). It may not display in JEI but should function as fuel.");
            }
        }
    }

    protected StirlingFuel convert(ItemStack item, int energy) {
        return new StirlingFuel(new ResourceLocation("thermal", "stirling_" + item.m_41720_().getRegistryName().m_135815_()), energy, Collections.singletonList(Ingredient.m_43927_((ItemStack[])new ItemStack[]{item})), Collections.emptyList());
    }
}

