/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.common;

import cofh.thermal.lib.util.managers.IManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.crafting.RecipeManager;

public class ThermalRecipeManagers {
    private static final ThermalRecipeManagers INSTANCE = new ThermalRecipeManagers();
    private RecipeManager clientRecipeManager;
    private RecipeManager serverRecipeManager;
    private final List<IManager> managers = new ArrayList<IManager>();

    public static ThermalRecipeManagers instance() {
        return INSTANCE;
    }

    public void setClientRecipeManager(RecipeManager recipeManager) {
        this.clientRecipeManager = recipeManager;
    }

    public void setServerRecipeManager(RecipeManager recipeManager) {
        this.serverRecipeManager = recipeManager;
    }

    public static void registerManager(IManager manager) {
        if (!ThermalRecipeManagers.instance().managers.contains(manager)) {
            ThermalRecipeManagers.instance().managers.add(manager);
        }
    }

    public void config() {
        for (IManager sub : this.managers) {
            sub.config();
        }
    }

    public void refreshServer() {
        if (this.serverRecipeManager == null) {
            return;
        }
        for (IManager sub : this.managers) {
            sub.refresh(this.serverRecipeManager);
        }
    }

    public void refreshClient() {
        if (this.clientRecipeManager == null) {
            return;
        }
        for (IManager sub : this.managers) {
            sub.refresh(this.clientRecipeManager);
        }
    }
}

