/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.world;

import cofh.thermal.lib.common.ThermalFeatures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class DimensionPlacement
extends PlacementFilter {
    public static final Codec<DimensionPlacement> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)ResourceLocation.f_135803_.listOf().fieldOf("dimensions").forGetter(o -> o.dimensions.stream().map(ResourceKey::m_135782_).collect(Collectors.toList()))).apply((Applicative)codec, r -> new DimensionPlacement(r.stream().map(o -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)o)).collect(Collectors.toSet()))));
    private final Set<ResourceKey<Level>> dimensions;

    protected DimensionPlacement(Set<ResourceKey<Level>> dimensions) {
        this.dimensions = dimensions;
    }

    public static DimensionPlacement of(Set<ResourceKey<Level>> dimensions) {
        return new DimensionPlacement(dimensions);
    }

    protected boolean m_183168_(PlacementContext ctx, Random rand, BlockPos pos) {
        ServerLevel level = ctx.m_191831_().m_6018_();
        return this.dimensions.contains(level.m_46472_());
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)ThermalFeatures.DIMENSION_PLACEMENT.get();
    }

    public static class Type
    implements PlacementModifierType<DimensionPlacement> {
        public Codec<DimensionPlacement> m_191869_() {
            return CODEC;
        }
    }
}

