/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.Bindings;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.resource.PathResourcePack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twilightforest.TFConfig;
import twilightforest.TFEventListener;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.capabilities.CapabilityList;
import twilightforest.client.ClientInitiator;
import twilightforest.client.particle.TFParticleType;
import twilightforest.command.TFCommand;
import twilightforest.compat.CuriosCompat;
import twilightforest.compat.TConCompat;
import twilightforest.compat.TFCompat;
import twilightforest.compat.UndergardenCompat;
import twilightforest.dispenser.TFDispenserBehaviors;
import twilightforest.enchantment.TFEnchantments;
import twilightforest.entity.TFEntities;
import twilightforest.inventory.TFContainers;
import twilightforest.item.FieryPickItem;
import twilightforest.item.TFItems;
import twilightforest.item.recipe.TFRecipes;
import twilightforest.item.recipe.UncraftingEnabledCondition;
import twilightforest.loot.TFTreasure;
import twilightforest.network.TFPacketHandler;
import twilightforest.potions.TFMobEffects;
import twilightforest.util.TFStats;
import twilightforest.world.components.BiomeGrassColors;
import twilightforest.world.components.biomesources.LandmarkBiomeSource;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.feature.BlockSpikeFeature;
import twilightforest.world.registration.TFBiomeFeatures;
import twilightforest.world.registration.TFNoiseGenerationSettings;
import twilightforest.world.registration.TFStructureProcessors;
import twilightforest.world.registration.TFStructures;
import twilightforest.world.registration.TwilightFeatures;
import twilightforest.world.registration.biomes.BiomeKeys;

@Mod(value="twilightforest")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TwilightForestMod {
    public static final String ID = "twilightforest";
    private static final String MODEL_DIR = "textures/model/";
    private static final String GUI_DIR = "textures/gui/";
    private static final String ENVIRO_DIR = "textures/environment/";
    public static final String ARMOR_DIR = "twilightforest:textures/armor/";
    public static final GameRules.Key<GameRules.BooleanValue> ENFORCED_PROGRESSION_RULE = GameRules.m_46189_((String)"tfEnforcedProgression", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final Logger LOGGER = LogManager.getLogger((String)"twilightforest");
    private static final Rarity rarity = Rarity.create((String)"TWILIGHT", (ChatFormatting)ChatFormatting.DARK_GREEN);

    public TwilightForestMod() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Common::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPair.getRight());
        TFConfig.COMMON_CONFIG = (TFConfig.Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(TFConfig.Client::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPair.getRight());
        TFConfig.CLIENT_CONFIG = (TFConfig.Client)specPair.getLeft();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientInitiator::call);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityList::attachEntityCapability);
        IEventBus modbus = FMLJavaModLoadingContext.get().getModEventBus();
        BiomeKeys.BIOMES.register(modbus);
        TFBlockEntities.BLOCK_ENTITIES.register(modbus);
        TFBlocks.BLOCKS.register(modbus);
        TFContainers.CONTAINERS.register(modbus);
        TFEnchantments.ENCHANTMENTS.register(modbus);
        TFEntities.ENTITIES.register(modbus);
        TFBiomeFeatures.FEATURES.register(modbus);
        TwilightFeatures.FOLIAGE_PLACERS.register(modbus);
        TFItems.ITEMS.register(modbus);
        TFMobEffects.MOB_EFFECTS.register(modbus);
        TFNoiseGenerationSettings.NOISE_GENERATORS.register(modbus);
        TFParticleType.PARTICLE_TYPES.register(modbus);
        TwilightFeatures.PLACEMENT_MODIFIERS.register(modbus);
        TFRecipes.RECIPE_SERIALIZERS.register(modbus);
        TFRecipes.RECIPE_TYPES.register(modbus);
        TFEntities.SPAWN_EGGS.register(modbus);
        TFStats.STATS.register(modbus);
        TFStructureProcessors.STRUCTURE_PROCESSORS.register(modbus);
        TwilightFeatures.TREE_DECORATORS.register(modbus);
        TwilightFeatures.TRUNK_PLACERS.register(modbus);
        if (ModList.get().isLoaded("undergarden")) {
            UndergardenCompat.ENTITIES.register(modbus);
        }
        if (ModList.get().isLoaded("tconstruct")) {
            TConCompat.FLUIDS.register(modbus);
            TConCompat.MODIFIERS.register(modbus);
        }
        modbus.addListener(this::sendIMCs);
        modbus.addListener(CapabilityList::registerCapabilities);
        modbus.addGenericListener(SoundEvent.class, TFSounds::registerSounds);
        modbus.addGenericListener(StructureFeature.class, TFStructures::register);
        if (ModList.get().isLoaded("curios")) {
            ((IEventBus)Bindings.getForgeBus().get()).addListener(CuriosCompat::keepCurios);
        }
        new BiomeGrassColors();
        if (((Boolean)TFConfig.COMMON_CONFIG.doCompat.get()).booleanValue()) {
            try {
                TFCompat.preInitCompat();
            }
            catch (Exception e) {
                TFConfig.COMMON_CONFIG.doCompat.set((Object)false);
                LOGGER.error("Had an error loading preInit compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        } else {
            LOGGER.warn("Skipping compatibility!");
        }
    }

    @SubscribeEvent
    public static void addClassicPack(AddPackFindersEvent event) {
        try {
            if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                Path resourcePath = ModList.get().getModFileById(ID).getFile().findResource(new String[]{"classic"});
                PathResourcePack pack = new PathResourcePack(ModList.get().getModFileById(ID).getFile().getFileName() + ":" + resourcePath, resourcePath);
                PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                if (metadataSection != null) {
                    event.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/twilight_forest_legacy_resources", (Component)new TextComponent("Twilight Classic"), false, () -> pack, metadataSection, Pack.Position.TOP, PackSource.f_10528_, false)));
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @SubscribeEvent
    public static void registerSerializers(RegistryEvent.Register<RecipeSerializer<?>> evt) {
        CraftingHelper.register((IConditionSerializer)new UncraftingEnabledCondition.Serializer());
        TFTreasure.init();
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)TwilightForestMod.prefix("twilight_biomes"), TFBiomeProvider.TF_CODEC);
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)TwilightForestMod.prefix("landmarks"), LandmarkBiomeSource.CODEC);
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)TwilightForestMod.prefix("structure_locating_wrapper"), ChunkGeneratorTwilight.CODEC);
    }

    @SubscribeEvent
    public static void registerLootModifiers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> evt) {
        evt.getRegistry().register((IForgeRegistryEntry)new FieryPickItem.Serializer().setRegistryName("twilightforest:fiery_pick_smelting"));
        evt.getRegistry().register((IForgeRegistryEntry)new TFEventListener.Serializer().setRegistryName("twilightforest:giant_block_grouping"));
    }

    public void sendIMCs(InterModEnqueueEvent evt) {
        TFCompat.sendIMCs();
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent evt) {
        TFPacketHandler.init();
        TFAdvancements.init();
        BiomeKeys.addBiomeTypes();
        if (((Boolean)TFConfig.COMMON_CONFIG.doCompat.get()).booleanValue()) {
            try {
                TFCompat.initCompat(evt);
            }
            catch (Exception e) {
                TFConfig.COMMON_CONFIG.doCompat.set((Object)false);
                LOGGER.error("Had an error loading init compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.doCompat.get()).booleanValue()) {
            try {
                TFCompat.postInitCompat();
            }
            catch (Exception e) {
                TFConfig.COMMON_CONFIG.doCompat.set((Object)false);
                LOGGER.error("Had an error loading postInit compatibility!");
                LOGGER.catching(e.fillInStackTrace());
            }
        }
        TFConfig.build();
        BlockSpikeFeature.loadStalactites();
        evt.enqueueWork(() -> {
            TFBlocks.tfCompostables();
            TFBlocks.tfBurnables();
            TFBlocks.tfPots();
            TFSounds.registerParrotSounds();
            TFDispenserBehaviors.init();
            WoodType.m_61844_((WoodType)TFBlocks.TWILIGHT_OAK);
            WoodType.m_61844_((WoodType)TFBlocks.CANOPY);
            WoodType.m_61844_((WoodType)TFBlocks.MANGROVE);
            WoodType.m_61844_((WoodType)TFBlocks.DARKWOOD);
            WoodType.m_61844_((WoodType)TFBlocks.TIMEWOOD);
            WoodType.m_61844_((WoodType)TFBlocks.TRANSFORMATION);
            WoodType.m_61844_((WoodType)TFBlocks.MINING);
            WoodType.m_61844_((WoodType)TFBlocks.SORTING);
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_HELMET.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_CHESTPLATE.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_LEGGINGS.get(), CauldronInteraction.f_175615_);
            CauldronInteraction.f_175607_.put((Item)TFItems.ARCTIC_BOOTS.get(), CauldronInteraction.f_175615_);
            AxeItem.f_150683_ = Maps.newHashMap((Map)AxeItem.f_150683_);
            AxeItem.f_150683_.put((Block)TFBlocks.TWILIGHT_OAK_LOG.get(), (Block)TFBlocks.STRIPPED_TWILIGHT_OAK_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.CANOPY_LOG.get(), (Block)TFBlocks.STRIPPED_CANOPY_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MANGROVE_LOG.get(), (Block)TFBlocks.STRIPPED_MANGROVE_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.DARK_LOG.get(), (Block)TFBlocks.STRIPPED_DARK_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TIME_LOG.get(), (Block)TFBlocks.STRIPPED_TIME_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TRANSFORMATION_LOG.get(), (Block)TFBlocks.STRIPPED_TRANSFORMATION_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MINING_LOG.get(), (Block)TFBlocks.STRIPPED_MINING_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.SORTING_LOG.get(), (Block)TFBlocks.STRIPPED_SORTING_LOG.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TWILIGHT_OAK_WOOD.get(), (Block)TFBlocks.STRIPPED_TWILIGHT_OAK_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.CANOPY_WOOD.get(), (Block)TFBlocks.STRIPPED_CANOPY_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MANGROVE_WOOD.get(), (Block)TFBlocks.STRIPPED_MANGROVE_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.DARK_WOOD.get(), (Block)TFBlocks.STRIPPED_DARK_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TIME_WOOD.get(), (Block)TFBlocks.STRIPPED_TIME_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.TRANSFORMATION_WOOD.get(), (Block)TFBlocks.STRIPPED_TRANSFORMATION_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.MINING_WOOD.get(), (Block)TFBlocks.STRIPPED_MINING_WOOD.get());
            AxeItem.f_150683_.put((Block)TFBlocks.SORTING_WOOD.get(), (Block)TFBlocks.STRIPPED_SORTING_WOOD.get());
        });
    }

    public void registerCommands(RegisterCommandsEvent event) {
        TFCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ResourceLocation prefix(String name) {
        return new ResourceLocation(ID, name.toLowerCase(Locale.ROOT));
    }

    public static ResourceLocation getModelTexture(String name) {
        return new ResourceLocation(ID, MODEL_DIR + name);
    }

    public static ResourceLocation getGuiTexture(String name) {
        return new ResourceLocation(ID, GUI_DIR + name);
    }

    public static ResourceLocation getEnvTexture(String name) {
        return new ResourceLocation(ID, ENVIRO_DIR + name);
    }

    public static Rarity getRarity() {
        return rarity;
    }
}

