/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.TwilightForestMod;
import twilightforest.util.PlayerHelper;

public class AuroraBrickBlock
extends Block {
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)15);

    public AuroraBrickBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, TwilightForestMod.prefix("progress_glacier")) ? 0.1f : super.m_5880_(state, player, getter, pos);
    }

    private static float getFractalNoise(int iteration, float size, BlockPos pos) {
        return iteration == 0 ? 0.0f : (SimplexNoise.noise(((float)pos.m_123341_() + (float)iteration * size) / size, ((float)pos.m_123342_() + (float)iteration * size) / size, ((float)pos.m_123343_() + (float)iteration * size) / size) + 1.0f) * 0.5f + AuroraBrickBlock.getFractalNoise(iteration - 1, size, pos);
    }

    public static float fractalNoise(int iterations, float size, BlockPos pos) {
        return AuroraBrickBlock.getFractalNoise(iterations, size, pos) / (float)iterations;
    }

    private static int calcVariant(BlockPos pos) {
        return (int)(AuroraBrickBlock.fractalNoise(3, 48.0f, pos) * 120.0f % 16.0f) % 16;
    }

    public static float rippleFractialNoise(int iterations, float size, BlockPos pos, float minimum, float maximum, float frequency) {
        float i = maximum - minimum;
        return Math.abs(AuroraBrickBlock.getFractalNoise(iterations, size, pos) * frequency % (2.0f * i) - i) + minimum;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(AuroraBrickBlock.calcVariant(ctx.m_8083_())));
    }

    @Deprecated
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)this.m_49966_().m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(AuroraBrickBlock.calcVariant(currentPos)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
    }

    private static class SimplexNoise {
        private static final Grad[] grad3 = new Grad[]{new Grad(1.0f, 1.0f, 0.0f), new Grad(-1.0f, 1.0f, 0.0f), new Grad(1.0f, -1.0f, 0.0f), new Grad(-1.0f, -1.0f, 0.0f), new Grad(1.0f, 0.0f, 1.0f), new Grad(-1.0f, 0.0f, 1.0f), new Grad(1.0f, 0.0f, -1.0f), new Grad(-1.0f, 0.0f, -1.0f), new Grad(0.0f, 1.0f, 1.0f), new Grad(0.0f, -1.0f, 1.0f), new Grad(0.0f, 1.0f, -1.0f), new Grad(0.0f, -1.0f, -1.0f)};
        private static final short[] p = new short[]{151, 160, 137, 91, 90, 15, 131, 13, 201, 95, 96, 53, 194, 233, 7, 225, 140, 36, 103, 30, 69, 142, 8, 99, 37, 240, 21, 10, 23, 190, 6, 148, 247, 120, 234, 75, 0, 26, 197, 62, 94, 252, 219, 203, 117, 35, 11, 32, 57, 177, 33, 88, 237, 149, 56, 87, 174, 20, 125, 136, 171, 168, 68, 175, 74, 165, 71, 134, 139, 48, 27, 166, 77, 146, 158, 231, 83, 111, 229, 122, 60, 211, 133, 230, 220, 105, 92, 41, 55, 46, 245, 40, 244, 102, 143, 54, 65, 25, 63, 161, 1, 216, 80, 73, 209, 76, 132, 187, 208, 89, 18, 169, 200, 196, 135, 130, 116, 188, 159, 86, 164, 100, 109, 198, 173, 186, 3, 64, 52, 217, 226, 250, 124, 123, 5, 202, 38, 147, 118, 126, 255, 82, 85, 212, 207, 206, 59, 227, 47, 16, 58, 17, 182, 189, 28, 42, 223, 183, 170, 213, 119, 248, 152, 2, 44, 154, 163, 70, 221, 153, 101, 155, 167, 43, 172, 9, 129, 22, 39, 253, 19, 98, 108, 110, 79, 113, 224, 232, 178, 185, 112, 104, 218, 246, 97, 228, 251, 34, 242, 193, 238, 210, 144, 12, 191, 179, 162, 241, 81, 51, 145, 235, 249, 14, 239, 107, 49, 192, 214, 31, 181, 199, 106, 157, 184, 84, 204, 176, 115, 121, 50, 45, 127, 4, 150, 254, 138, 236, 205, 93, 222, 114, 67, 29, 24, 72, 243, 141, 128, 195, 78, 66, 215, 61, 156, 180};
        private static final short[] perm = new short[512];
        private static final short[] permMod12 = new short[512];
        private static final float F3 = 0.33333334f;
        private static final float G3 = 0.16666667f;

        private SimplexNoise() {
        }

        private static int fastfloor(float x) {
            int xi = (int)x;
            return x < (float)xi ? xi - 1 : xi;
        }

        private static float dot(Grad g, float x, float y, float z) {
            return g.x * x + g.y * y + g.z * z;
        }

        static float noise(float xin, float yin, float zin) {
            float n3;
            float n2;
            float n1;
            float n0;
            int k2;
            int j2;
            int i2;
            int k1;
            int j1;
            int i1;
            float s = (xin + yin + zin) * 0.33333334f;
            int i = SimplexNoise.fastfloor(xin + s);
            int j = SimplexNoise.fastfloor(yin + s);
            int k = SimplexNoise.fastfloor(zin + s);
            float t = (float)(i + j + k) * 0.16666667f;
            float X0 = (float)i - t;
            float Y0 = (float)j - t;
            float Z0 = (float)k - t;
            float x0 = xin - X0;
            float y0 = yin - Y0;
            float z0 = zin - Z0;
            if (x0 >= y0) {
                if (y0 >= z0) {
                    i1 = 1;
                    j1 = 0;
                    k1 = 0;
                    i2 = 1;
                    j2 = 1;
                    k2 = 0;
                } else if (x0 >= z0) {
                    i1 = 1;
                    j1 = 0;
                    k1 = 0;
                    i2 = 1;
                    j2 = 0;
                    k2 = 1;
                } else {
                    i1 = 0;
                    j1 = 0;
                    k1 = 1;
                    i2 = 1;
                    j2 = 0;
                    k2 = 1;
                }
            } else if (y0 < z0) {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 0;
                j2 = 1;
                k2 = 1;
            } else if (x0 < z0) {
                i1 = 0;
                j1 = 1;
                k1 = 0;
                i2 = 0;
                j2 = 1;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 1;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            }
            float x1 = x0 - (float)i1 + 0.16666667f;
            float y1 = y0 - (float)j1 + 0.16666667f;
            float z1 = z0 - (float)k1 + 0.16666667f;
            float x2 = x0 - (float)i2 + 0.33333334f;
            float y2 = y0 - (float)j2 + 0.33333334f;
            float z2 = z0 - (float)k2 + 0.33333334f;
            float x3 = x0 - 1.0f + 0.5f;
            float y3 = y0 - 1.0f + 0.5f;
            float z3 = z0 - 1.0f + 0.5f;
            int ii = i & 0xFF;
            int jj = j & 0xFF;
            int kk = k & 0xFF;
            short gi0 = permMod12[ii + perm[jj + perm[kk]]];
            short gi1 = permMod12[ii + i1 + perm[jj + j1 + perm[kk + k1]]];
            short gi2 = permMod12[ii + i2 + perm[jj + j2 + perm[kk + k2]]];
            short gi3 = permMod12[ii + 1 + perm[jj + 1 + perm[kk + 1]]];
            float t0 = 0.6f - x0 * x0 - y0 * y0 - z0 * z0;
            if (t0 < 0.0f) {
                n0 = 0.0f;
            } else {
                t0 *= t0;
                n0 = t0 * t0 * SimplexNoise.dot(grad3[gi0], x0, y0, z0);
            }
            float t1 = 0.6f - x1 * x1 - y1 * y1 - z1 * z1;
            if (t1 < 0.0f) {
                n1 = 0.0f;
            } else {
                t1 *= t1;
                n1 = t1 * t1 * SimplexNoise.dot(grad3[gi1], x1, y1, z1);
            }
            float t2 = 0.6f - x2 * x2 - y2 * y2 - z2 * z2;
            if (t2 < 0.0f) {
                n2 = 0.0f;
            } else {
                t2 *= t2;
                n2 = t2 * t2 * SimplexNoise.dot(grad3[gi2], x2, y2, z2);
            }
            float t3 = 0.6f - x3 * x3 - y3 * y3 - z3 * z3;
            if (t3 < 0.0f) {
                n3 = 0.0f;
            } else {
                t3 *= t3;
                n3 = t3 * t3 * SimplexNoise.dot(grad3[gi3], x3, y3, z3);
            }
            return 32.0f * (n0 + n1 + n2 + n3);
        }

        static {
            for (int i = 0; i < 512; ++i) {
                SimplexNoise.perm[i] = p[i & 0xFF];
                SimplexNoise.permMod12[i] = (short)(perm[i] % 12);
            }
        }

        private static class Grad {
            float x;
            float y;
            float z;

            Grad(float x, float y, float z) {
                this.x = x;
                this.y = y;
                this.z = z;
            }
        }
    }
}

