/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.block.TFPlantBlock;
import twilightforest.client.particle.data.LeafParticleData;
import twilightforest.network.SpawnFallenLeafFromPacket;
import twilightforest.network.TFPacketHandler;

public class FallenLeavesBlock
extends TFPlantBlock {
    private static final VoxelShape FALLEN_LEAVES_SHAPE = FallenLeavesBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public FallenLeavesBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos, Direction.UP);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter access, BlockPos pos, CollisionContext context) {
        return FALLEN_LEAVES_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        super.m_7100_(state, world, pos, random);
        if (random.nextInt(50) == 0) {
            float dist = 10.0f;
            if (!world.m_46861_(pos)) {
                int y = 0;
                while ((float)y <= dist) {
                    if (world.m_8055_(pos.m_6630_(y)).m_60767_() == Material.f_76274_) {
                        dist = y;
                        break;
                    }
                    ++y;
                }
                if (dist > 10.0f) {
                    return;
                }
            }
            int color = Minecraft.m_91087_().m_91298_().m_92577_(Blocks.f_50050_.m_49966_(), (BlockAndTintGetter)world, pos, 0);
            int r = Mth.m_14045_((int)((color >> 16 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
            int g = Mth.m_14045_((int)((color >> 8 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
            int b = Mth.m_14045_((int)((color & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
            world.m_7106_((ParticleOptions)new LeafParticleData(r, g, b), (double)((float)pos.m_123341_() + random.nextFloat()), (double)((float)pos.m_123342_() + dist - 0.25f), (double)((float)pos.m_123343_() + random.nextFloat()), 0.0, 0.0, 0.0);
        }
    }

    @Deprecated
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entityIn) {
        super.m_7892_(state, world, pos, entityIn);
        if (entityIn instanceof LivingEntity && (entityIn.m_20184_().m_7096_() != 0.0 || entityIn.m_20184_().m_7094_() != 0.0) && this.RANDOM.nextBoolean()) {
            if (world.f_46443_) {
                int color = Minecraft.m_91087_().m_91298_().m_92577_(Blocks.f_50050_.m_49966_(), (BlockAndTintGetter)world, pos, 0);
                int r = Mth.m_14045_((int)((color >> 16 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
                int g = Mth.m_14045_((int)((color >> 8 & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
                int b = Mth.m_14045_((int)((color & 0xFF) + this.RANDOM.nextInt(34) - 17), (int)0, (int)255);
                world.m_7106_((ParticleOptions)new LeafParticleData(r, g, b), (double)((float)pos.m_123341_() + world.f_46441_.nextFloat()), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + world.f_46441_.nextFloat()), (double)(world.f_46441_.nextFloat() * -0.5f) * entityIn.m_20184_().m_7096_(), (double)(world.f_46441_.nextFloat() * 0.5f + 0.25f), (double)(world.f_46441_.nextFloat() * -0.5f) * entityIn.m_20184_().m_7094_());
            } else if (world instanceof ServerLevel) {
                TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entityIn), (Object)new SpawnFallenLeafFromPacket(pos, entityIn.m_20184_()));
            }
        }
    }
}

