/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import twilightforest.TFSounds;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.SkeletonDruid;
import twilightforest.world.registration.TFFeature;

public class SwarmSpider
extends Spider {
    protected boolean shouldSpawn = false;

    public SwarmSpider(EntityType<? extends SwarmSpider> type, Level world) {
        this(type, world, true);
    }

    public SwarmSpider(EntityType<? extends SwarmSpider> type, Level world, boolean spawnMore) {
        super(type, world);
        this.setSpawnMore(spawnMore);
        this.f_21364_ = 2;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Spider.m_33815_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.f_25345_.removeIf(t -> t.m_26015_() instanceof MeleeAttackGoal);
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            protected double m_6639_(LivingEntity attackTarget) {
                return 4.0f + attackTarget.m_20205_();
            }
        });
        this.f_21346_.f_25345_.removeIf(t -> t.m_26012_() == 2 && t.m_26015_() instanceof NearestAttackableTargetGoal);
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return TFSounds.SWARM_SPIDER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return TFSounds.SWARM_SPIDER_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.SWARM_SPIDER_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(TFSounds.SWARM_SPIDER_STEP, 0.15f, 1.0f);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.3f;
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.shouldSpawnMore()) {
            int more = 1 + this.f_19796_.nextInt(2);
            for (int i = 0; i < more; ++i) {
                if (this.spawnAnother()) continue;
                this.spawnAnother();
            }
            this.setSpawnMore(false);
        }
        super.m_8119_();
    }

    public boolean m_7327_(Entity entity) {
        return this.f_19796_.nextInt(4) == 0 && super.m_7327_(entity);
    }

    protected boolean spawnAnother() {
        SwarmSpider another = new SwarmSpider((EntityType<? extends SwarmSpider>)((EntityType)TFEntities.SWARM_SPIDER.get()), this.f_19853_, false);
        double sx = this.m_20185_() + (this.f_19796_.nextBoolean() ? 0.9 : -0.9);
        double sy = this.m_20186_();
        double sz = this.m_20189_() + (this.f_19796_.nextBoolean() ? 0.9 : -0.9);
        another.m_7678_(sx, sy, sz, this.f_19796_.nextFloat() * 360.0f, 0.0f);
        if (!another.m_5545_((LevelAccessor)this.f_19853_, MobSpawnType.MOB_SUMMONED)) {
            another.m_146870_();
            return false;
        }
        this.f_19853_.m_7967_((Entity)another);
        another.m_21373_();
        return true;
    }

    public static boolean getCanSpawnHere(EntityType<? extends SwarmSpider> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        return world.m_46791_() != Difficulty.PEACEFUL && SwarmSpider.isValidLightLevel(world, pos, random) && SwarmSpider.m_21400_(entity, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor world, BlockPos pos, Random random) {
        int chunkZ;
        int chunkX = Mth.m_14143_((float)pos.m_123341_()) >> 4;
        return TFFeature.getNearestFeature(chunkX, chunkZ = Mth.m_14143_((float)pos.m_123343_()) >> 4, (WorldGenLevel)((ServerLevel)world)) == TFFeature.HEDGE_MAZE || Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random);
    }

    public boolean shouldSpawnMore() {
        return this.shouldSpawn;
    }

    public void setSpawnMore(boolean flag) {
        this.shouldSpawn = flag;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("SpawnMore", this.shouldSpawnMore());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSpawnMore(compound.m_128471_("SpawnMore"));
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.5f;
    }

    public int m_5792_() {
        return 16;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingData, @Nullable CompoundTag dataTag) {
        livingData = super.m_6518_(worldIn, difficulty, reason, livingData, dataTag);
        if (this.m_146895_() != null || worldIn.m_5822_().nextInt(20) <= difficulty.m_19048_().m_19028_()) {
            SkeletonDruid druid = (SkeletonDruid)((EntityType)TFEntities.SKELETON_DRUID.get()).m_20615_(this.f_19853_);
            druid.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            druid.m_6863_(true);
            druid.m_6518_(worldIn, difficulty, MobSpawnType.JOCKEY, null, null);
            if (this.m_146862_(e -> true)) {
                this.m_20153_();
            }
            druid.m_20329_((Entity)this);
        }
        return livingData;
    }
}

