/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.armor.YetiArmorModel;

public class YetiArmorItem
extends ArmorItem {
    private static final MutableComponent TOOLTIP = new TranslatableComponent("item.twilightforest.yeti_armor.tooltip").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));

    public YetiArmorItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties props) {
        super(material, slot, props);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EquipmentSlot slot, String layer) {
        if (slot == EquipmentSlot.LEGS || slot == EquipmentSlot.CHEST) {
            return "twilightforest:textures/armor/yetiarmor_2.png";
        }
        return "twilightforest:textures/armor/yetiarmor_1.png";
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> list) {
        if (this.m_41389_(tab)) {
            ItemStack istack = new ItemStack((ItemLike)this);
            switch (this.f_40377_) {
                case HEAD: 
                case CHEST: 
                case LEGS: {
                    istack.m_41663_(Enchantments.f_44965_, 2);
                    break;
                }
                case FEET: {
                    istack.m_41663_(Enchantments.f_44965_, 2);
                    istack.m_41663_(Enchantments.f_44967_, 4);
                    break;
                }
            }
            list.add((Object)istack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltips, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltips, flags);
        tooltips.add((Component)TOOLTIP);
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(ArmorRender.INSTANCE);
    }

    private static final class ArmorRender
    implements IItemRenderProperties {
        private static final ArmorRender INSTANCE = new ArmorRender();

        private ArmorRender() {
        }

        public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
            EntityModelSet models = Minecraft.m_91087_().m_167973_();
            ModelPart root = models.m_171103_(armorSlot == EquipmentSlot.LEGS ? TFModelLayers.YETI_ARMOR_INNER : TFModelLayers.YETI_ARMOR_OUTER);
            return new YetiArmorModel(armorSlot, root);
        }
    }
}

