/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.block.TFBlocks;
import twilightforest.world.components.structures.HollowHillComponent;
import twilightforest.world.registration.TFFeature;

public class HydraLairComponent
extends HollowHillComponent {
    public HydraLairComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(TFFeature.TFHydra, nbt);
    }

    public HydraLairComponent(TFFeature feature, Random rand, int i, int x, int y, int z) {
        super(TFFeature.TFHydra, feature, i, 2, x, y + 2, z);
    }

    public void m_142537_(StructurePiece structurecomponent, StructurePieceAccessor accessor, Random random) {
    }

    @Override
    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        int stalacts = 64;
        int stalags = 8;
        for (i = 0; i < stalacts; ++i) {
            dest = this.randomCeilingCoordinates(rand, this.radius);
            this.generateOreStalactite(world, (Vec3i)dest.m_122184_(0, 1, 0), sbb);
        }
        for (i = 0; i < stalacts; ++i) {
            dest = this.randomCeilingCoordinates(rand, this.radius);
            this.generateBlockSpike(world, STONE_STALACTITE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < stalags; ++i) {
            dest = this.randomFloorCoordinates(rand, this.radius);
            this.generateBlockSpike(world, STONE_STALAGMITE, dest.m_123341_(), dest.m_123342_(), dest.m_123343_(), sbb);
        }
        this.m_73434_(world, ((Block)TFBlocks.HYDRA_BOSS_SPAWNER.get()).m_49966_(), 27, 3, 27, sbb);
    }

    @Override
    BlockPos.MutableBlockPos randomFloorCoordinates(Random rand, float maximumRadius) {
        float degree = rand.nextFloat() * 4.537856f + 1.7453294f;
        float radius = maximumRadius * 0.9f * (rand.nextFloat() * 0.35f + 0.65f);
        float dist = Mth.m_14116_((float)(radius * radius));
        float height = 4.0f - Mth.m_14089_((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 20.0f);
        return new BlockPos.MutableBlockPos((double)(maximumRadius - Mth.m_14089_((float)degree) * radius), (double)height, (double)(maximumRadius - Mth.m_14031_((float)degree) * radius));
    }

    @Override
    BlockPos.MutableBlockPos randomCeilingCoordinates(Random rand, float maximumRadius) {
        float degree = rand.nextFloat() * 4.537856f + 1.7453294f;
        float radius = rand.nextFloat() * 0.9f * maximumRadius;
        float dist = Mth.m_14116_((float)(radius * radius));
        float height = Mth.m_14089_((float)(dist / (float)this.hdiam * (float)Math.PI)) * ((float)this.hdiam / 4.0f);
        return new BlockPos.MutableBlockPos((double)(maximumRadius - Mth.m_14089_((float)degree) * radius), (double)height, (double)(maximumRadius - Mth.m_14031_((float)degree) * radius));
    }
}

